/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver.serial;

import com.tridium.basicdriver.BBasicNetwork;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="interMessageDelay", type="BRelTime", defaultValue="BRelTime.make(0)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE, BFacets.MIN, BRelTime.make(0), BFacets.MAX, BRelTime.SECOND)")}), @NiagaraProperty(name="serialPortConfig", type="BSerialHelper", defaultValue="new BSerialHelper()")})
public abstract class BSerialNetwork
extends BBasicNetwork
implements BISerialHelperParent {
    @Generated
    public static final Property interMessageDelay = BSerialNetwork.newProperty((int)0, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    @Generated
    public static final Property serialPortConfig = BSerialNetwork.newProperty((int)0, (BValue)new BSerialHelper(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSerialNetwork.class);
    private Log log = null;
    private final Object logLock = new Object();
    private Subscriber subscriber;
    private String serialInitError = null;

    @Generated
    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    @Generated
    public void setInterMessageDelay(BRelTime v) {
        this.set(interMessageDelay, (BValue)v, null);
    }

    @Generated
    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    @Generated
    public void setSerialPortConfig(BSerialHelper v) {
        this.set(serialPortConfig, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceStarted() throws Exception {
        this.subscriber = new NameSubscriber(this);
        this.subscriber.subscribe((BComponent)this.getParent());
        this.subscriber.subscribe((BComponent)this.getSerialPortConfig());
        this.getSerialPortConfig().setSerialHelperParent((BISerialHelperParent)this);
        if (this.log == null) {
            this.log = this.getLog();
        }
        Object object = this.logLock;
        synchronized (object) {
            this.log = this.getLog();
        }
        super.serviceStarted();
    }

    @Override
    public void serviceStopped() throws Exception {
        super.serviceStopped();
        this.subscriber.unsubscribeAll();
        this.subscriber = null;
    }

    @Override
    public void startComm() throws Exception {
        try {
            super.startComm();
            this.serialInitError = null;
        }
        catch (Exception e) {
            this.serialInitError = "Could not enable serial communication (" + e + ")";
            throw e;
        }
        finally {
            String error = this.checkSerialConfig();
            if (error == null) {
                this.configOk();
            } else {
                this.configFail(error);
            }
        }
    }

    protected String checkSerialConfig() {
        if (this.getSerialPortConfig().getPortName().equals("none")) {
            return "No port selected for serial communication.";
        }
        return this.serialInitError;
    }

    @Override
    public final Log getLog() {
        String serialLogName = this.getName() + "_" + this.getSerialPortConfig().getPortName();
        if (!SlotPath.isValidName((String)serialLogName)) {
            serialLogName = SlotPath.escape((String)serialLogName);
        }
        return Log.getLog((String)serialLogName);
    }

    public final String getLoggerName() {
        String serialLogName = this.getType().getTypeName() + "_" + this.getSerialPortConfig().getPortName();
        if (!SlotPath.isValidName((String)serialLogName)) {
            serialLogName = SlotPath.escape((String)serialLogName);
        }
        return serialLogName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLog() {
        String serialLogName = this.getName() + "_" + this.getSerialPortConfig().getPortName();
        if (!SlotPath.isValidName((String)serialLogName)) {
            serialLogName = SlotPath.escape((String)serialLogName);
        }
        Log newLog = Log.getLog((String)serialLogName);
        if (this.log == null) {
            this.log = this.getLog();
        }
        Object object = this.logLock;
        synchronized (object) {
            if (this.log != null) {
                newLog.setSeverity(this.log.getSeverity());
                if (!newLog.getLogName().equals(this.log.getLogName())) {
                    Log.deleteLog((String)this.log.getLogName());
                }
            }
            this.log = newLog;
        }
    }

    public final void reopenPort() {
        try {
            String newPort = this.getSerialPortConfig().getPortName();
            if (newPort.equals("none")) {
                this.configFail("No port selected for serial communication.");
                this.stopComm();
                return;
            }
            this.restartSerialNetwork();
        }
        catch (Exception e) {
            this.getLog().error("BSerialNetwork caught exception in reopenPort(): ", (Throwable)e);
        }
    }

    private void restartSerialNetwork() throws Exception {
        if (!(this.isDisabled() || this.isDown() || this.isFatalFault())) {
            if (this.log.isTraceOn()) {
                this.log.trace(this.getName() + " *** Restarting serial comm ***");
            }
            this.stopComm();
            this.startComm();
        }
    }

    protected final void serialServiceStarted() throws Exception {
    }

    protected final void serialServiceStopped() throws Exception {
    }

    protected final void serialNetworkStarted() {
    }

    protected final void serialNetworkStopped() {
    }

    protected final void serialNetworkChanged(Property prop, Context context) {
    }

    private class NameSubscriber
    extends Subscriber {
        private BSerialNetwork net;

        public NameSubscriber(BSerialNetwork net) {
            this.net = net;
        }

        public void event(BComponentEvent event) {
            if (event.getId() == 3) {
                if (event.getSlot().equals((Object)this.net.getPropertyInParent())) {
                    this.net.updateLog();
                }
            } else if (event.getId() == 0 && event.getSlot().equals((Object)BSerialHelper.portName)) {
                this.net.updateLog();
            }
        }
    }
}

