/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.datatypes.BTimeStamp;
import com.tridium.lonIp.link.LonIpAddress;
import com.tridium.lonIp.messages.Acknowledge;
import com.tridium.lonIp.messages.ChannelMembership;
import com.tridium.lonIp.messages.ChannelRouting;
import com.tridium.lonIp.messages.DataMessage;
import com.tridium.lonIp.messages.DeviceRegistration;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.RequestMessage;
import com.tridium.lonIp.messages.SendList;
import com.tridium.lonIp.messages.StatisticsResp;
import com.tridium.lonIp.messages.Unknown;
import com.tridium.lonworks.loncomm.LinkedQueue;
import com.tridium.lonworks.util.LonByteArrayUtil;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public abstract class LonIpMessage
implements LinkedQueue.Linkable,
LonIp {
    public int retries = 0;
    public int repeatTime = 0;
    public int packetLength;
    public int version = 1;
    public int packetType;
    public int extendedHdrSize = 0;
    public int protocolFlags = 0;
    public int vendorCode = 0;
    public byte[] sessionId = DEFAULT_SESSION_ID;
    public int sequenceNumber;
    public BTimeStamp timeStamp = BTimeStamp.DEFAULT;
    public boolean hasExtendedNat = false;
    public BIpAddress ipAdr = null;
    public BIpAddress natAdr = null;
    public int ipPort;
    private static final byte[] DEFAULT_SESSION_ID = new byte[]{0, 0, 0, 0};
    private static final Logger log = Logger.getLogger("LonIp.lonIpMessage");
    public LonIpAddress sendList = null;
    private InetAddress srcAddress = null;
    private int srcPort;
    public LinkedQueue.Linkable next = null;

    public static LonIpMessage make(byte[] a) throws LonException {
        LonIpMessage ipMsg = null;
        switch (a[3]) {
            case 1: {
                ipMsg = new DataMessage();
                break;
            }
            case 3: 
            case 113: {
                ipMsg = new DeviceRegistration();
                break;
            }
            case 96: 
            case 99: 
            case 100: 
            case 102: 
            case 104: {
                ipMsg = new RequestMessage();
                break;
            }
            case 4: {
                ipMsg = new ChannelMembership();
                break;
            }
            case 6: {
                ipMsg = new SendList();
                break;
            }
            case 8: {
                ipMsg = new ChannelRouting();
                break;
            }
            case 7: {
                ipMsg = new Acknowledge();
                break;
            }
            case 112: {
                ipMsg = new StatisticsResp();
                break;
            }
            default: {
                ipMsg = new Unknown();
            }
        }
        if (ipMsg != null) {
            ipMsg.fromNetworkBytes(a);
        }
        return ipMsg;
    }

    public boolean isDataMessage() {
        return false;
    }

    public byte[] toNetworkBytes() {
        LonOutputStream out = new LonOutputStream();
        out.writeUnsigned16(0);
        out.writeUnsigned8(this.version);
        out.writeUnsigned8(this.packetType);
        out.writeUnsigned8(this.hasExtendedNat ? 3 : 0);
        out.writeUnsigned8(this.protocolFlags);
        out.writeUnsigned16(this.vendorCode);
        out.writeByteArray(this.sessionId, 4);
        out.writeSigned32(this.sequenceNumber);
        this.timeStamp.toOutputStream(out);
        if (this.hasExtendedNat) {
            this.ipAdr.toOutputStream(out);
            this.natAdr.toOutputStream(out);
            out.writeUnsigned16(this.ipPort);
            out.writeUnsigned16(0);
        }
        this.toOutputStream(out);
        byte[] a = out.toByteArray();
        int len = a.length;
        a[0] = (byte)(len >> 8 & 0xFF);
        a[1] = (byte)(len & 0xFF);
        return a;
    }

    public final void fromNetworkBytes(byte[] a) throws LonException {
        LonInputStream in = new LonInputStream(a);
        this.packetLength = in.readUnsigned16();
        this.version = in.readUnsigned8();
        this.packetType = in.readUnsigned8();
        this.extendedHdrSize = in.readUnsigned8();
        this.protocolFlags = in.readUnsigned8();
        this.vendorCode = in.readUnsigned16();
        this.sessionId = in.readByteArray(4);
        this.sequenceNumber = in.readSigned32();
        this.timeStamp = BTimeStamp.fromInputStream(in);
        if (this.extendedHdrSize == 3) {
            this.hasExtendedNat = true;
            this.ipAdr = BIpAddress.fromInputStream(in);
            this.natAdr = BIpAddress.fromInputStream(in);
            this.ipPort = in.readUnsigned16();
            in.readUnsigned16();
        } else if (this.extendedHdrSize > 0) {
            for (int i = 0; i < this.extendedHdrSize; ++i) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("**** extended header " + LonByteArrayUtil.toString((byte[])in.readByteArray(4)));
            }
        }
        this.fromInputStream(in);
    }

    public abstract void fromInputStream(LonInputStream var1) throws LonException;

    public abstract void toOutputStream(LonOutputStream var1);

    public void addExtendedNat(BIpLonNetworkConfig netCfg, boolean forCfgSvr) {
        this.hasExtendedNat = true;
        this.ipAdr = netCfg.getMyIpAddress();
        this.natAdr = netCfg.getNatIpAddress();
        this.ipPort = forCfgSvr ? netCfg.getLonIpConfigServerPort().getPublicServerPort() : netCfg.getRcvPort();
    }

    public synchronized boolean retry() {
        if (this.retries <= 0) {
            return false;
        }
        try {
            this.wait(this.repeatTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        --this.retries;
        return this.retries >= 0;
    }

    public synchronized void responseReceived() {
        this.retries = 0;
        this.notify();
    }

    public InetAddress getSrcAddress() {
        return this.srcAddress;
    }

    public void setSrcAddress(InetAddress adr) {
        this.srcAddress = adr;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(int prt) {
        this.srcPort = prt;
    }

    public LinkedQueue.Linkable getNext() {
        return this.next;
    }

    public void setNext(LinkedQueue.Linkable nxt) {
        this.next = nxt;
    }
}

