/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.enums.BIpLonCnFlagsEnum;
import com.tridium.lonIp.enums.BIpLonIpFlagsEnum;
import com.tridium.lonIp.enums.BIpLonNodeTypeEnum;
import com.tridium.lonIp.enums.BIpLonRouterTypeEnum;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class ChannelRouting
extends LonIpMessage {
    public BDateTime dateTime;
    public int mcIpPort = 0;
    public int ucIpPort = 0;
    public BIpAddress mcIpAdr = BIpAddress.DEFAULT;
    public BIpAddress ucIpAdr = BIpAddress.DEFAULT;
    public BIpLonIpFlagsEnum ipFlags = NIAGARA_IP_FLAG;
    public BIpLonRouterTypeEnum routerType = NIAGARA_ROUTER_TYPE;
    public BIpLonCnFlagsEnum cnFlags = NIAGARA_FLAG;
    public BIpLonNodeTypeEnum nodeType = NIAGARA_NODE_TYPE;
    public BNeuronId[] nids;
    public SubnetNodeRecord[] snRec;
    public DomainRecord[] domRec;

    public ChannelRouting() {
        this.packetType = 8;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("dateTime=").append((Object)this.dateTime).append("\n");
        sb.append((Object)this.ipFlags).append(":").append((Object)this.routerType).append(":").append((Object)this.cnFlags).append(":").append((Object)this.nodeType).append("\n");
        sb.append("ucIpAdr=").append((Object)this.ucIpAdr).append(":").append(this.ucIpPort).append("\n");
        for (int i = 0; i < this.snRec.length; ++i) {
            SubnetNodeRecord sr = this.snRec[i];
            sb.append("s\\n=").append(sr.sn).append(":");
            if (this.nids.length > sr.nidNdx) {
                BNeuronId nid = this.nids[sr.nidNdx];
                sb.append("id=").append(nid.toString()).append("\n");
            }
            if (this.domRec.length <= sr.domainNdx) continue;
            DomainRecord dr = this.domRec[sr.domainNdx];
            sb.append("s\\n mask=").append(LonByteArrayUtil.toString((byte[])dr.subnetMask)).append("\n");
            sb.append("grp mask=").append(LonByteArrayUtil.toString((byte[])dr.groupMask)).append("\n");
            sb.append("domainId=").append(dr.domainId).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void fromInputStream(LonInputStream in) throws LonException {
        int i;
        this.dateTime = BDateTime.fromInputStream(in);
        this.mcIpPort = in.readUnsigned16();
        this.ucIpPort = in.readUnsigned16();
        this.mcIpAdr = BIpAddress.fromInputStream(in);
        this.ucIpAdr = BIpAddress.fromInputStream(in);
        this.ipFlags = BIpLonIpFlagsEnum.makeValid(in.readUnsigned8());
        this.routerType = BIpLonRouterTypeEnum.makeValid(in.readUnsigned8());
        this.cnFlags = BIpLonCnFlagsEnum.makeValid(in.readUnsigned8());
        this.nodeType = BIpLonNodeTypeEnum.makeValid(in.readUnsigned8());
        int nidCnt = in.readUnsigned16() / 6;
        in.readUnsigned16();
        int snRecCnt = in.readUnsigned16() / 6;
        int dmRecCnt = in.readUnsigned16() / 72;
        this.nids = new BNeuronId[nidCnt];
        for (i = 0; i < nidCnt; ++i) {
            this.nids[i] = BNeuronId.make((byte[])in.readByteArray(6));
        }
        this.snRec = new SubnetNodeRecord[snRecCnt];
        for (i = 0; i < snRecCnt; ++i) {
            SubnetNodeRecord sr = new SubnetNodeRecord();
            sr.sn = BSubnetNode.make((int)in.readUnsigned8(), (int)in.readUnsigned8());
            sr.domainNdx = in.readUnsigned16();
            sr.nidNdx = in.readUnsigned16();
            this.snRec[i] = sr;
        }
        this.domRec = new DomainRecord[dmRecCnt];
        for (i = 0; i < dmRecCnt; ++i) {
            DomainRecord dr = new DomainRecord();
            dr.subnetMask = in.readByteArray(32);
            dr.groupMask = in.readByteArray(32);
            int domLen = in.readUnsigned8();
            in.readUnsigned8();
            dr.domainId = BDomainId.make((int)domLen, (byte[])in.readByteArray(6));
            this.domRec[i] = dr;
        }
    }

    @Override
    public void toOutputStream(LonOutputStream out) {
        int i;
        this.dateTime.toOutputStream(out);
        out.writeUnsigned16(this.mcIpPort);
        out.writeUnsigned16(this.ucIpPort);
        this.mcIpAdr.toOutputStream(out);
        this.ucIpAdr.toOutputStream(out);
        out.writeUnsigned8(this.ipFlags.getOrdinal());
        out.writeUnsigned8(this.routerType.getOrdinal());
        out.writeUnsigned8(this.cnFlags.getOrdinal());
        out.writeUnsigned8(this.nodeType.getOrdinal());
        int nidCnt = this.nids.length;
        int snRecCnt = this.snRec.length;
        int dmRecCnt = this.domRec.length;
        out.writeUnsigned16(nidCnt * 6);
        out.writeUnsigned16(0);
        out.writeUnsigned16(snRecCnt * 6);
        out.writeUnsigned16(dmRecCnt * 72);
        for (i = 0; i < nidCnt; ++i) {
            out.writeByteArray(this.nids[i].getByteArray(), 6);
        }
        for (i = 0; i < snRecCnt; ++i) {
            SubnetNodeRecord sr = this.snRec[i];
            out.writeUnsigned8(sr.sn.getSubnetId());
            out.writeUnsigned8(sr.sn.getNodeId());
            out.writeUnsigned16(sr.domainNdx);
            out.writeUnsigned16(sr.nidNdx);
        }
        for (i = 0; i < dmRecCnt; ++i) {
            DomainRecord dr = this.domRec[i];
            out.writeByteArray(dr.subnetMask, 32);
            out.writeByteArray(dr.groupMask, 32);
            out.writeUnsigned8(dr.domainId.getLength());
            out.writeUnsigned8(0);
            out.writeByteArray(dr.domainId.getDomainId(), 6);
        }
    }

    public static class DomainRecord {
        public byte[] subnetMask;
        public byte[] groupMask;
        public BDomainId domainId;
    }

    public static class SubnetNodeRecord {
        public BSubnetNode sn;
        public int domainNdx;
        public int nidNdx;
    }
}

