/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.datatypes;

import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.nre.firewall.IpProtocol;
import java.util.logging.Level;
import javax.baja.firewall.BServerPort;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BIpLonConfigServerPort
extends BServerPort {
    @Generated
    public static final Type TYPE = Sys.loadType(BIpLonConfigServerPort.class);
    private static final String BIP_LON_SERVER_PORT_FACET_KEY = "BLonIpServerPort";
    private static final String BIP_LON_SERVER_PORT_FACET_VALUE = "lonIpServerPortAlreadyProcessed";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIpLonConfigServerPort() {
    }

    public BIpLonConfigServerPort(int publicServerPort, IpProtocol protocol) {
        super(publicServerPort, protocol);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BIpLonNetworkConfig;
    }

    protected void updateFirewallRules() {
        BIpLonNetworkConfig parent = (BIpLonNetworkConfig)this.getParent();
        if (parent.getIsConfigServer()) {
            super.updateFirewallRules();
        }
    }

    protected void removeFirewallRules() {
        BIpLonNetworkConfig parent = (BIpLonNetworkConfig)this.getParent();
        if (parent.getIsConfigServer()) {
            super.removeFirewallRules();
        }
    }

    protected void updateFirewallOnConfigServerChanged(boolean isConfigServer) {
        if (firewallLog.isLoggable(Level.FINE)) {
            firewallLog.fine(isConfigServer ? "LonIpNetwork is now a config server, opening firewall port " + this.getPublicServerPort() : "LonIpNetwork is no longer a config server, closing firewall port " + this.getPublicServerPort());
        }
        if (isConfigServer) {
            super.updateFirewallRules();
        } else {
            super.removeFirewallRules();
        }
    }

    public void changed(Property property, Context context) {
        BasicContext newContext = new BasicContext(context, BFacets.make((String)BIP_LON_SERVER_PORT_FACET_KEY, (String)BIP_LON_SERVER_PORT_FACET_VALUE));
        super.changed(property, (Context)newContext);
    }
}

