/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.datatypes;

import com.tridium.lonIp.ChannelMonitor;
import com.tridium.lonIp.ConfigServer;
import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.datatypes.BMemberTable;
import com.tridium.lonIp.enums.BIpLonCnFlagsEnum;
import com.tridium.lonIp.enums.BIpLonIpFlagsEnum;
import com.tridium.lonIp.enums.BIpLonNodeTypeEnum;
import com.tridium.lonIp.enums.BIpLonRouterTypeEnum;
import com.tridium.lonIp.enums.BMemberStateEnum;
import com.tridium.lonIp.enums.BStatusAuxCommandEnum;
import com.tridium.lonIp.messages.ChannelRouting;
import com.tridium.lonIp.messages.DeviceRegistration;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonIp.util.MemberAction;
import com.tridium.lonworks.datatypes.BLonRouteTable;
import java.net.InetAddress;
import java.util.logging.Logger;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="cnName", type="String", defaultValue=""), @NiagaraProperty(name="ipUcAddress", type="BIpAddress", defaultValue="BIpAddress.DEFAULT"), @NiagaraProperty(name="ipUcPort", type="int", defaultValue="1628"), @NiagaraProperty(name="natIpAddress", type="BIpAddress", defaultValue="BIpAddress.DEFAULT"), @NiagaraProperty(name="ipFlags", type="BIpLonIpFlagsEnum", defaultValue="BIpLonIpFlagsEnum.Udp"), @NiagaraProperty(name="routerType", type="BIpLonRouterTypeEnum", defaultValue="BIpLonRouterTypeEnum.Configured"), @NiagaraProperty(name="cnFlags", type="BIpLonCnFlagsEnum", defaultValue="BIpLonCnFlagsEnum.none"), @NiagaraProperty(name="nodeType", type="BIpLonNodeTypeEnum", defaultValue="BIpLonNodeTypeEnum.NonIpToIpRouter"), @NiagaraProperty(name="subnetNode", type="BSubnetNode", defaultValue="BSubnetNode.DEFAULT"), @NiagaraProperty(name="subnetMask", type="BLonRouteTable", defaultValue="BLonRouteTable.DEFAULT"), @NiagaraProperty(name="groupMask", type="BLonRouteTable", defaultValue="BLonRouteTable.DEFAULT"), @NiagaraProperty(name="neuronId", type="BNeuronId", defaultValue="BNeuronId.DEFAULT"), @NiagaraProperty(name="domainId", type="BDomainId", defaultValue="BDomainId.DEFAULT"), @NiagaraProperty(name="configTimeStamp", type="BDateTime", defaultValue="BDateTime.DEFAULT"), @NiagaraProperty(name="routeTimeStamp", type="BDateTime", defaultValue="BDateTime.DEFAULT"), @NiagaraProperty(name="sequence", type="int", defaultValue="1"), @NiagaraProperty(name="iState", type="BMemberStateEnum", defaultValue="BMemberStateEnum.NewMember"), @NiagaraProperty(name="faultCause", type="String", defaultValue="")})
@NiagaraActions(value={@NiagaraAction(name="update"), @NiagaraAction(name="getStatistics"), @NiagaraAction(name="getStatusAux", parameterType="BStatusAuxCommandEnum", defaultValue="BStatusAuxCommandEnum.StatusNoClear")})
public class BChannelMember
extends BComponent
implements BIStatus {
    @Generated
    public static final Property cnName = BChannelMember.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property ipUcAddress = BChannelMember.newProperty((int)0, (BValue)BIpAddress.DEFAULT, null);
    @Generated
    public static final Property ipUcPort = BChannelMember.newProperty((int)0, (int)1628, null);
    @Generated
    public static final Property natIpAddress = BChannelMember.newProperty((int)0, (BValue)BIpAddress.DEFAULT, null);
    @Generated
    public static final Property ipFlags = BChannelMember.newProperty((int)0, (BValue)BIpLonIpFlagsEnum.Udp, null);
    @Generated
    public static final Property routerType = BChannelMember.newProperty((int)0, (BValue)BIpLonRouterTypeEnum.Configured, null);
    @Generated
    public static final Property cnFlags = BChannelMember.newProperty((int)0, (BValue)BIpLonCnFlagsEnum.none, null);
    @Generated
    public static final Property nodeType = BChannelMember.newProperty((int)0, (BValue)BIpLonNodeTypeEnum.NonIpToIpRouter, null);
    @Generated
    public static final Property subnetNode = BChannelMember.newProperty((int)0, (BValue)BSubnetNode.DEFAULT, null);
    @Generated
    public static final Property subnetMask = BChannelMember.newProperty((int)0, (BValue)BLonRouteTable.DEFAULT, null);
    @Generated
    public static final Property groupMask = BChannelMember.newProperty((int)0, (BValue)BLonRouteTable.DEFAULT, null);
    @Generated
    public static final Property neuronId = BChannelMember.newProperty((int)0, (BValue)BNeuronId.DEFAULT, null);
    @Generated
    public static final Property domainId = BChannelMember.newProperty((int)0, (BValue)BDomainId.DEFAULT, null);
    @Generated
    public static final Property configTimeStamp = BChannelMember.newProperty((int)0, (BValue)BDateTime.DEFAULT, null);
    @Generated
    public static final Property routeTimeStamp = BChannelMember.newProperty((int)0, (BValue)BDateTime.DEFAULT, null);
    @Generated
    public static final Property sequence = BChannelMember.newProperty((int)0, (int)1, null);
    @Generated
    public static final Property iState = BChannelMember.newProperty((int)0, (BValue)BMemberStateEnum.NewMember, null);
    @Generated
    public static final Property faultCause = BChannelMember.newProperty((int)0, (String)"", null);
    @Generated
    public static final Action update = BChannelMember.newAction((int)0, null);
    @Generated
    public static final Action getStatistics = BChannelMember.newAction((int)0, null);
    @Generated
    public static final Action getStatusAux = BChannelMember.newAction((int)0, (BValue)BStatusAuxCommandEnum.StatusNoClear, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BChannelMember.class);
    private int retryCount = 0;

    @Generated
    public String getCnName() {
        return this.getString(cnName);
    }

    @Generated
    public void setCnName(String v) {
        this.setString(cnName, v, null);
    }

    @Generated
    public BIpAddress getIpUcAddress() {
        return (BIpAddress)this.get(ipUcAddress);
    }

    @Generated
    public void setIpUcAddress(BIpAddress v) {
        this.set(ipUcAddress, (BValue)v, null);
    }

    @Generated
    public int getIpUcPort() {
        return this.getInt(ipUcPort);
    }

    @Generated
    public void setIpUcPort(int v) {
        this.setInt(ipUcPort, v, null);
    }

    @Generated
    public BIpAddress getNatIpAddress() {
        return (BIpAddress)this.get(natIpAddress);
    }

    @Generated
    public void setNatIpAddress(BIpAddress v) {
        this.set(natIpAddress, (BValue)v, null);
    }

    @Generated
    public BIpLonIpFlagsEnum getIpFlags() {
        return (BIpLonIpFlagsEnum)this.get(ipFlags);
    }

    @Generated
    public void setIpFlags(BIpLonIpFlagsEnum v) {
        this.set(ipFlags, (BValue)v, null);
    }

    @Generated
    public BIpLonRouterTypeEnum getRouterType() {
        return (BIpLonRouterTypeEnum)this.get(routerType);
    }

    @Generated
    public void setRouterType(BIpLonRouterTypeEnum v) {
        this.set(routerType, (BValue)v, null);
    }

    @Generated
    public BIpLonCnFlagsEnum getCnFlags() {
        return (BIpLonCnFlagsEnum)this.get(cnFlags);
    }

    @Generated
    public void setCnFlags(BIpLonCnFlagsEnum v) {
        this.set(cnFlags, (BValue)v, null);
    }

    @Generated
    public BIpLonNodeTypeEnum getNodeType() {
        return (BIpLonNodeTypeEnum)this.get(nodeType);
    }

    @Generated
    public void setNodeType(BIpLonNodeTypeEnum v) {
        this.set(nodeType, (BValue)v, null);
    }

    @Generated
    public BSubnetNode getSubnetNode() {
        return (BSubnetNode)this.get(subnetNode);
    }

    @Generated
    public void setSubnetNode(BSubnetNode v) {
        this.set(subnetNode, (BValue)v, null);
    }

    @Generated
    public BLonRouteTable getSubnetMask() {
        return (BLonRouteTable)this.get(subnetMask);
    }

    @Generated
    public void setSubnetMask(BLonRouteTable v) {
        this.set(subnetMask, (BValue)v, null);
    }

    @Generated
    public BLonRouteTable getGroupMask() {
        return (BLonRouteTable)this.get(groupMask);
    }

    @Generated
    public void setGroupMask(BLonRouteTable v) {
        this.set(groupMask, (BValue)v, null);
    }

    @Generated
    public BNeuronId getNeuronId() {
        return (BNeuronId)this.get(neuronId);
    }

    @Generated
    public void setNeuronId(BNeuronId v) {
        this.set(neuronId, (BValue)v, null);
    }

    @Generated
    public BDomainId getDomainId() {
        return (BDomainId)this.get(domainId);
    }

    @Generated
    public void setDomainId(BDomainId v) {
        this.set(domainId, (BValue)v, null);
    }

    @Generated
    public BDateTime getConfigTimeStamp() {
        return (BDateTime)this.get(configTimeStamp);
    }

    @Generated
    public void setConfigTimeStamp(BDateTime v) {
        this.set(configTimeStamp, (BValue)v, null);
    }

    @Generated
    public BDateTime getRouteTimeStamp() {
        return (BDateTime)this.get(routeTimeStamp);
    }

    @Generated
    public void setRouteTimeStamp(BDateTime v) {
        this.set(routeTimeStamp, (BValue)v, null);
    }

    @Generated
    public int getSequence() {
        return this.getInt(sequence);
    }

    @Generated
    public void setSequence(int v) {
        this.setInt(sequence, v, null);
    }

    @Generated
    public BMemberStateEnum getIState() {
        return (BMemberStateEnum)this.get(iState);
    }

    @Generated
    public void setIState(BMemberStateEnum v) {
        this.set(iState, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public void update() {
        this.invoke(update, null, null);
    }

    @Generated
    public void getStatistics() {
        this.invoke(getStatistics, null, null);
    }

    @Generated
    public void getStatusAux(BStatusAuxCommandEnum parameter) {
        this.invoke(getStatusAux, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BChannelMember() {
    }

    public BChannelMember(InetAddress destAdr, int destPort) {
        this.setIpUcAddress(BIpAddress.make(destAdr));
        this.setIpUcPort(destPort);
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == iState) {
            this.retryCount = 0;
            if (this.getIState() != BMemberStateEnum.Error) {
                this.setFaultCause("");
            }
        }
        BIpChannel ipChan = (BIpChannel)this.getParent().getParent();
        if (p == ipUcAddress || p == ipUcPort || p == routerType || p == subnetNode || p == neuronId || p == domainId) {
            ipChan.getAddressManager().memberChanged(cx);
        }
        if (cx == BMemberTable.internalChange) {
            return;
        }
        BIpLonNetworkConfig netCfg = ipChan.getNetworkConfig();
        if (netCfg.getIsConfigServer()) {
            ConfigServer cs = ipChan.getConfigServer();
            if (p == cnName || p == ipUcAddress || p == ipUcPort) {
                cs.updateMember(this, true);
            }
            if (p == subnetNode || p == neuronId || p == subnetMask || p == groupMask) {
                cs.updateMember(this, false);
            }
        } else if (netCfg.isLocal(this)) {
            ChannelMonitor chanMon = ipChan.getChannelMonitor();
            boolean newConfig = false;
            boolean newRoute = false;
            if (p == cnName || p == ipUcAddress || p == ipUcPort || p == neuronId) {
                newConfig = true;
            }
            if (p == subnetNode || p == neuronId || p == subnetMask || p == groupMask) {
                newRoute = true;
            }
            chanMon.localDataChanged(newConfig, newRoute);
        }
    }

    public boolean isParentLegal(BComponent p) {
        if (!(p instanceof BMemberTable)) {
            return false;
        }
        return super.isParentLegal(p);
    }

    public String toString(Context cx) {
        return this.getCnName() + ":" + (Object)((Object)this.getIpUcAddress()) + ":" + this.getIpUcPort();
    }

    public synchronized int getSequenceAndIncrement() {
        int seq = this.getSequence() + 1;
        this.setSequence(seq);
        return seq;
    }

    public boolean storeChannelRoute(ChannelRouting cr, Logger log) {
        ChannelRouting.SubnetNodeRecord sr = null;
        if (cr.snRec.length == 0) {
            log.fine("ChannelRouting message has no subnet records");
            return false;
        }
        sr = cr.snRec[0];
        if (!this.getSubnetNode().equals((Object)sr.sn)) {
            this.set(subnetNode, (BValue)sr.sn, BMemberTable.internalChange);
        }
        if (cr.nids.length == 0) {
            log.fine("ChannelRouting message has no neuronId records");
        } else {
            BNeuronId nid = cr.nids[sr.nidNdx];
            if (!this.getNeuronId().equals((Object)nid)) {
                this.set(neuronId, (BValue)nid, BMemberTable.internalChange);
            }
        }
        if (cr.domRec.length == 0) {
            log.fine("ChannelRouting message has no domain records");
        } else {
            ChannelRouting.DomainRecord dr = cr.domRec[0];
            BLonRouteTable sm = BLonRouteTable.make((byte[])dr.subnetMask);
            if (!this.getSubnetMask().equals((Object)sm)) {
                this.set(subnetMask, (BValue)sm, BMemberTable.internalChange);
            }
            BLonRouteTable gm = BLonRouteTable.make((byte[])dr.groupMask);
            if (!this.getGroupMask().equals((Object)gm)) {
                this.set(groupMask, (BValue)gm, BMemberTable.internalChange);
            }
            if (!this.getDomainId().equals((Object)dr.domainId)) {
                this.set(domainId, (BValue)dr.domainId, BMemberTable.internalChange);
            }
        }
        boolean routingChange = !this.getRouteTimeStamp().equals((Object)cr.dateTime);
        this.setRouteTimeStamp(cr.dateTime);
        return routingChange;
    }

    public void storeDeviceConfiguration(DeviceRegistration msg) {
        boolean changed = false;
        if (!this.getCnName().equals(msg.name) && this.getIState().equals((Object)BMemberStateEnum.UpToDate)) {
            this.setString(cnName, msg.name, BMemberTable.internalChange);
            changed = true;
        }
        if (!this.getIpFlags().equals((Object)msg.ipFlags)) {
            this.set(ipFlags, (BValue)msg.ipFlags, BMemberTable.internalChange);
            changed = true;
        }
        if (!this.getRouterType().equals((Object)msg.routerType)) {
            this.set(routerType, (BValue)msg.routerType, BMemberTable.internalChange);
            changed = true;
        }
        if (!this.getCnFlags().equals((Object)msg.cnFlags)) {
            this.set(cnFlags, (BValue)msg.cnFlags, BMemberTable.internalChange);
            changed = true;
        }
        if (!this.getNodeType().equals((Object)msg.nodeType)) {
            this.set(nodeType, (BValue)msg.nodeType, BMemberTable.internalChange);
            changed = true;
        }
        this.updateTime(msg.dateTime, changed);
    }

    private void updateTime(BDateTime dt, boolean change) {
        BDateTime lt = this.getConfigTimeStamp();
        if (!lt.isLaterThan(dt)) {
            this.setConfigTimeStamp(BDateTime.make(dt.getSeconds() + 1L));
            return;
        }
        if (!change) {
            return;
        }
        BDateTime nt = BDateTime.make();
        if (lt.isLaterThan(nt)) {
            nt = BDateTime.make(lt.getSeconds() + 1L);
        }
        this.setConfigTimeStamp(nt);
    }

    public void updateNat(LonIpMessage msg) {
        if (msg.hasExtendedNat) {
            if (this.getIpUcAddress().equals((Object)msg.natAdr)) {
                this.setIpUcAddress(msg.ipAdr);
            }
            this.setNatIpAddress(msg.natAdr);
        }
    }

    public boolean hasNatIp() {
        return !this.getNatIpAddress().equals((Object)BIpAddress.DEFAULT);
    }

    public BIpAddress getNetworkIp() {
        if (this.hasNatIp()) {
            return this.getNatIpAddress();
        }
        return this.getIpUcAddress();
    }

    public BIpAddress getSegmentIp(BIpLonNetworkConfig netCfg) {
        return this.getSegmentIp(netCfg.getMyIpAddress(), netCfg.getNatIpAddress());
    }

    public BIpAddress getSegmentIp(BChannelMember cm) {
        return this.getSegmentIp(cm.getIpUcAddress(), cm.getNatIpAddress());
    }

    public BIpAddress getSegmentIp(BIpAddress clientIpUc, BIpAddress clientNatIp) {
        BIpAddress ipUc = this.getIpUcAddress();
        BIpAddress natIp = this.getNatIpAddress();
        if (clientIpUc.equals((Object)ipUc)) {
            return this.getNetworkIp();
        }
        if (natIp.equals((Object)clientNatIp)) {
            return ipUc;
        }
        if (this.hasNatIp()) {
            return natIp;
        }
        return ipUc;
    }

    public void storeLocalConfiguration(BIpLonNetworkConfig netCfg, BLonNetwork lonworks) {
        boolean changed = false;
        if (!netCfg.getNatIpAddress().equals((Object)BIpAddress.DEFAULT) && !this.getNatIpAddress().equals((Object)netCfg.getNatIpAddress())) {
            this.setNatIpAddress(netCfg.getNatIpAddress());
            changed = true;
        }
        if (!this.getIpUcAddress().equals((Object)netCfg.getMyIpAddress())) {
            this.setIpUcAddress(netCfg.getMyIpAddress());
            changed = true;
        }
        if (!this.getCnName().equals(netCfg.getNetName())) {
            this.setCnName(netCfg.getNetName());
            changed = true;
        }
        if (!this.getIpFlags().equals((Object)LonIp.NIAGARA_IP_FLAG)) {
            this.setIpFlags(LonIp.NIAGARA_IP_FLAG);
            changed = true;
        }
        if (!this.getRouterType().equals((Object)LonIp.NIAGARA_ROUTER_TYPE)) {
            this.setRouterType(LonIp.NIAGARA_ROUTER_TYPE);
            changed = true;
        }
        if (!this.getCnFlags().equals((Object)LonIp.NIAGARA_FLAG)) {
            this.setCnFlags(LonIp.NIAGARA_FLAG);
            changed = true;
        }
        if (!this.getNodeType().equals((Object)LonIp.NIAGARA_NODE_TYPE)) {
            this.setNodeType(LonIp.NIAGARA_NODE_TYPE);
            changed = true;
        }
        BDeviceData dd = lonworks.getLocalLonDevice().getDeviceData();
        BSubnetNode sn = dd.getSubnetNodeId();
        if (!this.getSubnetNode().equals((Object)sn)) {
            this.setSubnetNode(sn);
            changed = true;
        }
        BNeuronId nid = dd.getNeuronId();
        if (!this.getNeuronId().equals((Object)nid)) {
            this.setNeuronId(nid);
            changed = true;
        }
        BDomainId domainId = lonworks.getLonNetmgmt().getDomainId();
        if (!this.getDomainId().equals((Object)domainId)) {
            this.setDomainId(domainId);
            changed = true;
        }
        if (this.updateLocalRoutes(lonworks.getLocalLonDevice(), false)) {
            changed = true;
        }
        if (changed) {
            this.setConfigTimeStamp(BDateTime.make());
        }
    }

    public boolean updateLocalRoutes(BLocalLonDevice locDev, boolean notify) {
        boolean changed = false;
        BDeviceData dd = locDev.getDeviceData();
        byte[] sna = new byte[32];
        this.setFlag(0, sna);
        this.setFlag(dd.getSubnetNodeId().getSubnetId(), sna);
        BLonRouteTable sm = BLonRouteTable.make((byte[])sna);
        if (!this.getSubnetMask().equals((Object)sm)) {
            this.setSubnetMask(sm);
            changed = true;
        }
        byte[] gra = new byte[32];
        BAddressEntry[] aea = dd.getAddressTable().getAddresses();
        for (int i = 0; i < aea.length; ++i) {
            if (!aea[i].isGroupAddress()) continue;
            this.setFlag(aea[i].getGroupOrSubnet(), gra);
        }
        BLonRouteTable gm = BLonRouteTable.make((byte[])gra);
        if (!this.getGroupMask().equals((Object)gm)) {
            this.setGroupMask(gm);
            changed = true;
        }
        this.setRouteTimeStamp(BDateTime.make());
        return changed;
    }

    private void setFlag(int index, byte[] a) {
        int byteOffset = index / 8;
        int bitOffset = index % 8;
        int n = byteOffset;
        a[n] = (byte)(a[n] | (byte)(1 << bitOffset));
    }

    public void doUpdate() {
        BIpChannel ipChan = (BIpChannel)this.getParent().getParent();
        BIpLonNetworkConfig netCfg = ipChan.getNetworkConfig();
        if (netCfg.getIsConfigServer()) {
            ipChan.getConfigServer().doUpdateMember(this);
        } else {
            ipChan.getChannelMonitor().doUpdateMember(this);
        }
    }

    public void doGetStatistics() {
        this.action().getStatus(this, false);
    }

    public void doGetStatusAux(BStatusAuxCommandEnum auxCmd) {
        switch (auxCmd.getOrdinal()) {
            case 0: {
                this.action().getStatus(this, false);
                break;
            }
            case 1: {
                this.action().getStatus(this, true);
                break;
            }
            case 2: {
                this.action().getDeviceConfig(this);
                break;
            }
            case 3: {
                this.action().getChannelMembership(this);
                break;
            }
            case 4: {
                this.action().getRoute(this);
            }
        }
    }

    private MemberAction action() {
        return ((BMemberTable)this.getParent()).memberAction();
    }

    public synchronized int incrementRetryCount() {
        ++this.retryCount;
        return this.retryCount;
    }

    public synchronized void error(String s) {
        this.setIState(BMemberStateEnum.Error);
        this.setFaultCause(s);
    }

    public BStatus getStatus() {
        switch (this.getIState().getOrdinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return BStatus.stale;
            }
            case 4: {
                return BStatus.ok;
            }
            case 5: {
                return BStatus.fault;
            }
        }
        return BStatus.fault;
    }
}

