/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp;

import com.tridium.lonIp.Statistics;
import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.datatypes.BMemberTable;
import com.tridium.lonIp.enums.BMemberStateEnum;
import com.tridium.lonIp.link.LonIpAddress;
import com.tridium.lonIp.link.LonIpLinkLayer;
import com.tridium.lonIp.messages.Acknowledge;
import com.tridium.lonIp.messages.ChannelMembership;
import com.tridium.lonIp.messages.ChannelRouting;
import com.tridium.lonIp.messages.DeviceRegistration;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonIp.messages.RequestMessage;
import com.tridium.lonIp.messages.SendList;
import com.tridium.lonIp.messages.StatisticsResp;
import com.tridium.lonIp.util.LonIpAddressManager;
import com.tridium.lonworks.loncomm.LinkedQueue;
import com.tridium.lonworks.util.NmUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;

public class ChannelMonitor
implements Runnable,
LonIp {
    LinkedQueue receiveQueue = new LinkedQueue();
    BChannelMember[] sendList = null;
    Clock.Ticket ticket = null;
    private int delay;
    private int currentDelay;
    private int monitorState = 4;
    private static final int WAIT_DR = 1;
    private static final int WAIT_CM = 2;
    private static final int WAIT_CR = 3;
    private static final int IDLE = 4;
    private boolean isConfigServer = false;
    private boolean useExtendedNat = false;
    private DeviceRegistration currentConfig;
    private ChannelRouting curRoute;
    private final BDateTime sendListDt = BDateTime.DEFAULT;
    private final BLonNetwork lonworks;
    private final BIpChannel ipChan;
    public BIpLonNetworkConfig netCfg;
    private final BMemberTable memTab;
    private final LonIpLinkLayer link;
    private final LonIpAddressManager adrMan;
    private Thread receiveThread;
    private volatile boolean done;
    LonIpAddress configServerIp;
    private final Logger log;

    public ChannelMonitor(BLonNetwork lonworks, LonIpLinkLayer link) {
        this.lonworks = lonworks;
        this.link = link;
        this.ipChan = (BIpChannel)lonworks.get("ipChannel");
        this.netCfg = this.ipChan.getNetworkConfig();
        this.memTab = this.ipChan.getMemberTable();
        this.adrMan = link.adrMan;
        this.log = Logger.getLogger(lonworks.getLogName() + ".channelMonitor");
        this.ipChan.registerChannelMonitor(this);
    }

    public void start() {
        this.isConfigServer = this.netCfg.getIsConfigServer();
        this.useExtendedNat = this.netCfg.getUseExtendedNat();
        this.setConfigServerIp();
        this.done = false;
        this.receiveThread = new Thread((Runnable)this, this.lonworks.getLogName() + ".LonIpChannelMon");
        this.receiveThread.setPriority(5);
        this.receiveThread.start();
    }

    public void stop() {
        this.done = true;
        if (this.receiveThread != null) {
            this.receiveThread.interrupt();
            try {
                this.receiveThread.join();
                this.receiveThread = null;
            }
            catch (InterruptedException interruptedException) {
                this.log.log(Level.SEVERE, "Error occurred stopping monitor receive thread", interruptedException);
            }
        }
    }

    @Override
    public void run() {
        while (!this.ipChan.isRunning()) {
            if (this.done) {
                return;
            }
            NmUtil.wait((int)1000);
        }
        this.currentConfig = this.createDeviceRegistration();
        this.curRoute = this.createChannelRouting();
        this.startDeviceRegistration();
        while (!this.done) {
            try {
                LonIpMessage msg = (LonIpMessage)this.receiveQueue.dequeue();
                if (msg == null) continue;
                this.processIpMessage(msg);
            }
            catch (Throwable throwable) {
                this.log.log(Level.SEVERE, "Error in ChannelMonitor:", throwable);
            }
        }
    }

    private void processIpMessage(LonIpMessage msg) {
        if (msg.hasExtendedNat) {
            this.netCfg.setUseExtendedNat(true);
        }
        if (this.isConfigServer) {
            switch (msg.packetType) {
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 113: {
                    this.sendAck(msg, 3);
                    return;
                }
            }
        }
        switch (msg.packetType) {
            case 113: {
                this.rcvDeviceConfiguration((DeviceRegistration)msg);
                break;
            }
            case 4: {
                this.rcvChannelMembership((ChannelMembership)msg);
                break;
            }
            case 8: {
                this.rcvChannelRouting((ChannelRouting)msg);
                break;
            }
            case 6: {
                this.rcvSendList((SendList)msg);
                break;
            }
            case 7: {
                this.rcvAcknowledge((Acknowledge)msg);
                break;
            }
            case 99: {
                this.rcvDeviceConfigurationRequest((RequestMessage)msg);
                break;
            }
            case 100: {
                this.rcvChannelMembershipRequest((RequestMessage)msg);
                break;
            }
            case 104: {
                this.rcvChannelRoutingRequest((RequestMessage)msg);
                break;
            }
            case 96: {
                this.rcvStatusRequest((RequestMessage)msg);
                break;
            }
            case 102: {
                this.log.log(Level.INFO, "Packet type not processed:" + Integer.toString(msg.packetType, 16));
                break;
            }
            case 3: {
                this.rcvDeviceRegistration((DeviceRegistration)msg);
                break;
            }
            default: {
                this.log.log(Level.INFO, "Packet type not implemented:" + Integer.toString(msg.packetType, 16));
            }
        }
    }

    public void receiveMessage(LonIpMessage sendMessage) {
        this.receiveQueue.enqueue((LinkedQueue.Linkable)sendMessage);
    }

    public void networkConfigChanged(Context cx) {
        if (!this.lonworks.getEnabled()) {
            return;
        }
        this.isConfigServer = this.netCfg.getIsConfigServer();
        this.useExtendedNat = this.netCfg.getUseExtendedNat();
        if (this.netCfg.getConfigServerIp().equals((Object)BIpAddress.DEFAULT)) {
            return;
        }
        this.setConfigServerIp();
        this.currentConfig = this.createDeviceRegistration();
        if (this.lonworks.isFault()) {
            this.lonworks.configOk();
            if (!this.lonworks.isServiceRunning()) {
                this.link.stop();
                this.lonworks.serviceStarted();
            }
        }
        this.startDeviceRegistration();
    }

    public void localDataChanged(boolean newConfig, boolean newRoute) {
        if (newConfig) {
            this.currentConfig = this.createDeviceRegistration();
        }
        if (newRoute) {
            this.curRoute = this.createChannelRouting();
        }
        if (newConfig) {
            this.startDeviceRegistration();
        }
    }

    public void doUpdateMember(BChannelMember cm) {
        if (this.isConfigServer) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("doUpdate member " + cm.getCnName());
        }
        if (this.netCfg.isLocal(cm)) {
            cm.storeLocalConfiguration(this.netCfg, this.lonworks);
            this.localDataChanged(true, true);
        }
    }

    private synchronized void setConfigServerIp() {
        this.configServerIp = LonIpAddress.make(this.netCfg.getConfigServerIp().getInetAddress(), this.netCfg.getLonIpConfigServerPort().getPublicServerPort());
    }

    private void startDeviceRegistration() {
        if (this.isConfigServer || this.netCfg.getConfigServerIp().equals((Object)BIpAddress.DEFAULT)) {
            return;
        }
        this.monitorState = 1;
        this.sendDeviceRegistration();
        this.startTimer();
        this.currentDelay = 1;
        this.delay = 1;
    }

    private synchronized void startTimer() {
        if (this.ticket != null) {
            return;
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this.ipChan, (BRelTime)BRelTime.makeSeconds((int)1), (Action)BIpChannel.channelMonitorTimeout, null);
    }

    private synchronized void stopTimer() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    public void channelTimerCallback() {
        if (this.isConfigServer) {
            this.stopTimer();
            return;
        }
        switch (this.monitorState) {
            case 1: {
                if (--this.delay != 0) break;
                this.sendDeviceRegistration();
                if (this.currentDelay < 30) {
                    this.currentDelay *= 2;
                }
                this.delay = this.currentDelay;
                break;
            }
            case 2: {
                this.sendChannelMembershipRequest();
                break;
            }
            case 3: {
                if (!this.updateDevices()) break;
                this.monitorState = 4;
                break;
            }
            case 4: {
                this.updateDevices();
            }
        }
    }

    private String stateToString() {
        switch (this.monitorState) {
            case 1: {
                return "WAIT_DR";
            }
            case 2: {
                return "WAIT_CM";
            }
            case 3: {
                return "WAIT_CR";
            }
            case 4: {
                return "IDLE";
            }
        }
        return "undefined state {" + this.monitorState + "}";
    }

    private void sendDeviceRegistration() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("send device registration to config server\n" + this.currentConfig.toString());
        }
        this.currentConfig.packetType = 3;
        this.sendToConfigServer(this.currentConfig);
    }

    private void sendRoute() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("send channel route to config server\n" + this.curRoute);
        }
        if (this.curRoute == null) {
            System.out.println("****\n*****\ncurRoute==null\n");
        }
        if (this.netCfg == null) {
            System.out.println("****\n*****\n netCfg==null\n");
        }
        this.sendToConfigServer(this.curRoute);
    }

    private void sendChannelMembershipRequest() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("request channel membership from config server");
        }
        RequestMessage rm = new RequestMessage(100);
        this.sendToConfigServer(rm);
    }

    private void rcvDeviceConfigurationRequest(RequestMessage req) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("receive device configuration request from " + req.getSrcAddress());
        }
        this.currentConfig.packetType = 113;
        this.sendResponse(req, this.currentConfig);
    }

    private void sendResponse(RequestMessage req, LonIpMessage resp) {
        resp.sequenceNumber = req.sequenceNumber;
        this.send(resp, LonIpAddress.make(req));
    }

    private void rcvChannelMembershipRequest(RequestMessage req) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("send channel membership on request to " + req.getSrcAddress());
        }
        ChannelMembership cm = this.createChannelMembership();
        this.send(cm, LonIpAddress.make(req));
    }

    private void rcvChannelRoutingRequest(RequestMessage req) {
        BIpAddress reqIp;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("rcvChannelRoutingRequest from " + req.getSrcAddress() + " for " + (Object)((Object)req.ipAddress));
        }
        if ((reqIp = req.ipAddress).equals((Object)BIpAddress.DEFAULT) || !reqIp.equals((Object)this.netCfg.getMyIpAddress()) && !reqIp.equals((Object)this.netCfg.getNatIpAddress())) {
            this.sendAck(req, 4);
            return;
        }
        this.curRoute = this.createChannelRouting();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("send channel routing on request to " + req.getSrcAddress() + "\n" + this.curRoute.toString());
        }
        this.send(this.curRoute, LonIpAddress.make(req));
    }

    private BIpAddress getMyNetworkIp() {
        return this.netCfg.getMyNetworkIp();
    }

    private int getMyPort() {
        return this.netCfg.getRcvPort();
    }

    private ChannelRouting createChannelRouting() {
        BChannelMember cm = this.memTab.findEntry(this.getMyNetworkIp(), this.getMyPort());
        if (cm == null) {
            return null;
        }
        BDeviceData dd = this.lonworks.getLocalLonDevice().getDeviceData();
        ChannelRouting cr = new ChannelRouting();
        cr.dateTime = cm.getRouteTimeStamp();
        cr.ucIpPort = this.netCfg.getRcvPort();
        cr.ucIpAdr = this.getMyNetworkIp();
        cr.nids = new BNeuronId[]{dd.getNeuronId()};
        ChannelRouting.SubnetNodeRecord snr = new ChannelRouting.SubnetNodeRecord();
        snr.sn = dd.getSubnetNodeId();
        snr.domainNdx = 0;
        snr.nidNdx = 0;
        cr.snRec = new ChannelRouting.SubnetNodeRecord[]{snr};
        ChannelRouting.DomainRecord dmr = new ChannelRouting.DomainRecord();
        dmr.subnetMask = cm.getSubnetMask().getByteArrayCopy();
        dmr.groupMask = cm.getGroupMask().getByteArrayCopy();
        dmr.domainId = this.lonworks.getLonNetmgmt().getDomainId();
        cr.domRec = new ChannelRouting.DomainRecord[]{dmr};
        return cr;
    }

    private ChannelMembership createChannelMembership() {
        ChannelMembership cm = new ChannelMembership();
        cm.dateTime = BDateTime.make();
        BChannelMember[] a = this.memTab.getChannelMembers();
        cm.ips = new BIpAddress[a.length];
        cm.ports = new int[a.length];
        cm.chanRouteTime = new BDateTime[a.length];
        for (int i = 0; i < a.length; ++i) {
            cm.ips[i] = a[i].getSegmentIp(this.netCfg);
            cm.ports[i] = a[i].getIpUcPort();
            cm.chanRouteTime[i] = a[i].getRouteTimeStamp();
        }
        return cm;
    }

    private DeviceRegistration createDeviceRegistration() {
        DeviceRegistration dr = new DeviceRegistration();
        dr.dateTime = BDateTime.make();
        dr.ucIpPort = this.netCfg.getRcvPort();
        dr.ucIpAdr = this.getMyNetworkIp();
        dr.chanMembershipDt = dr.dateTime;
        dr.sendlistDt = this.sendListDt;
        dr.configServerIp = this.netCfg.getIsConfigServer() ? this.getMyNetworkIp() : this.netCfg.getConfigServerIp();
        dr.configServerPort = this.netCfg.getLonIpConfigServerPort().getPublicServerPort();
        dr.mcIps = new BIpAddress[0];
        dr.mcPorts = new int[0];
        dr.id = this.lonworks.getLocalLonDevice().getNeuronIdAddress().getByteArray();
        dr.name = this.netCfg.getNetName();
        return dr;
    }

    private void rcvDeviceConfiguration(DeviceRegistration msg) {
        if (msg.ucIpAdr.equals((Object)this.getMyNetworkIp()) && msg.ucIpPort == this.netCfg.getRcvPort()) {
            this.processMyDeviceConfiguration(msg);
        } else {
            this.processDeviceConfiguration(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMyDeviceConfiguration(DeviceRegistration msg) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("receive device configuration:\n" + msg.toString());
        }
        if (!msg.getSrcAddress().equals(this.configServerIp.inetAdr) || msg.getSrcPort() != this.configServerIp.port) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("config server ip/port changed");
            }
            this.netCfg.setConfigServerIp(BIpAddress.make(msg.getSrcAddress()));
            this.netCfg.getLonIpConfigServerPort().setPublicServerPort(msg.getSrcPort());
        }
        boolean sendRoute = false;
        ChannelMonitor channelMonitor = this;
        synchronized (channelMonitor) {
            if (this.monitorState == 1) {
                sendRoute = true;
            }
            if (this.monitorState == 1 || !msg.chanMembershipDt.equals((Object)this.currentConfig.chanMembershipDt)) {
                this.monitorState = 2;
            }
        }
        this.currentConfig = msg;
        this.sendAck(msg, 0);
        if (sendRoute && this.curRoute != null) {
            this.sendRoute();
        }
    }

    private void processDeviceConfiguration(DeviceRegistration msg) {
        BIpAddress ip = msg.ucIpAdr;
        BChannelMember cm = this.memTab.findEntry(ip, msg.ucIpPort);
        if (cm == null) {
            if (msg.hasExtendedNat) {
                cm = this.memTab.findEntry(msg.ipAdr, msg.ucIpPort);
            } else if (!msg.getSrcAddress().equals(ip.getInetAddress()) && (cm = this.memTab.findEntry(msg.getSrcAddress(), msg.ucIpPort)) != null && ip.equals((Object)this.netCfg.getNatIpAddress())) {
                cm.setNatIpAddress(ip);
            }
            if (cm == null) {
                this.log.warning("receive device configuration for unknown member\n" + msg);
                this.sendAck(msg, 4);
                return;
            }
            cm.updateNat(msg);
        }
        this.sendAck(msg, 0);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("receive device configuration for " + cm.getCnName() + " \n" + msg);
        }
        if (cm.getIState() == BMemberStateEnum.SentDRReq) {
            cm.storeDeviceConfiguration(msg);
            RequestMessage rm = new RequestMessage(104, BDateTime.DEFAULT);
            rm.ipAddress = cm.getSegmentIp(this.netCfg);
            if (this.memTab.hasDuplicateSegmentIp(rm.ipAddress, this.netCfg)) {
                rm.ipUcPort = cm.getIpUcPort();
            }
            this.send(rm, LonIpAddress.make(ip.getInetAddress(), msg.ucIpPort));
            cm.setIState(BMemberStateEnum.SentCRReq);
        }
    }

    private void rcvDeviceRegistration(DeviceRegistration msg) {
        this.log.severe("receive device registration - not config server");
        this.sendAck(msg, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rcvChannelMembership(ChannelMembership msg) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("receive channel membership:\n" + msg.toString());
        }
        boolean anyCRs = false;
        BChannelMember[] members = this.memTab.getChannelMembers();
        for (int i = 0; i < msg.ips.length; ++i) {
            RequestMessage rm;
            BIpAddress ip = msg.ips[i];
            int port = msg.ports[i];
            BChannelMember chanMem = null;
            for (int n = 0; n < members.length; ++n) {
                if (members[n] == null || !members[n].getSegmentIp(this.netCfg).equals((Object)ip) || members[n].getIpUcPort() != port) continue;
                chanMem = members[n];
                members[n] = null;
                break;
            }
            boolean forSelf = ip.equals((Object)super.getMyNetworkIp());
            if (chanMem == null) {
                chanMem = new BChannelMember();
                chanMem.setIpUcAddress(ip);
                chanMem.setIpUcPort(port);
                if (forSelf) {
                    chanMem.storeLocalConfiguration(this.netCfg, this.lonworks);
                    chanMem.setIState(BMemberStateEnum.UpToDate);
                }
                this.memTab.addMember(chanMem, BMemberTable.internalChange);
            }
            if (forSelf) continue;
            if (chanMem.getIState() == BMemberStateEnum.NewMember || chanMem.getIState() == BMemberStateEnum.SentDRReq) {
                chanMem.setIState(BMemberStateEnum.SentDRReq);
                rm = new RequestMessage(99, BDateTime.DEFAULT);
                rm.ipAddress = ip;
                super.send(rm, LonIpAddress.make(ip.getInetAddress(), port));
                anyCRs = true;
                continue;
            }
            if (msg.chanRouteTime[i].isLaterThan(chanMem.getConfigTimeStamp())) {
                chanMem.setIState(BMemberStateEnum.SentCRReq);
                rm = new RequestMessage(104, chanMem.getConfigTimeStamp());
                rm.ipAddress = ip;
                super.send(rm, LonIpAddress.make(ip.getInetAddress(), port));
                continue;
            }
            chanMem.setIState(BMemberStateEnum.UpToDate);
        }
        BChannelMember[] bChannelMemberArray = this;
        synchronized (this) {
            this.monitorState = anyCRs ? 3 : 4;
            // ** MonitorExit[var4_5] (shouldn't be in output)
            for (BChannelMember mem : members) {
                if (mem == null) continue;
                this.memTab.removeMember(mem, BMemberTable.internalChange);
            }
            this.memTab.setTimeStamp(msg.dateTime);
            return;
        }
    }

    private boolean updateDevices() {
        BChannelMember[] members;
        boolean upToDate = true;
        for (BChannelMember chanMem : members = this.memTab.getChannelMembers()) {
            RequestMessage rm;
            LonIpAddress lip = LonIpAddress.make(chanMem.getSegmentIp(this.netCfg).getInetAddress(), chanMem.getIpUcPort());
            if (chanMem.getIState() == BMemberStateEnum.SentDRReq) {
                rm = new RequestMessage(99, BDateTime.DEFAULT);
                rm.ipAddress = chanMem.getSegmentIp(this.netCfg);
                this.send(rm, lip);
                upToDate = false;
                continue;
            }
            if (chanMem.getIState() != BMemberStateEnum.SentCRReq) continue;
            rm = new RequestMessage(104, chanMem.getConfigTimeStamp());
            rm.ipAddress = chanMem.getSegmentIp(this.netCfg);
            this.send(rm, lip);
            upToDate = false;
        }
        return upToDate;
    }

    public Object foo() {
        return new byte[0];
    }

    private void sendToConfigServer(LonIpMessage msg) {
        this.send(msg, this.configServerIp);
    }

    private void rcvSendList(SendList msg) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("receive send list - not implemented");
        }
    }

    private void rcvChannelRouting(ChannelRouting msg) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("received channel routing:\n" + msg);
        }
        if (msg.snRec.length == 0) {
            this.log.fine("ChannelRouting message has no subnet records");
            return;
        }
        if (msg.snRec.length > 1) {
            this.log.fine("ChannelRouting message has " + msg.snRec.length + " subnet records");
        }
        if (msg.nids.length == 0) {
            this.log.fine("ChannelRouting message has no neuronId records");
            return;
        }
        BIpAddress ip = msg.ucIpAdr;
        BChannelMember cm = this.memTab.findEntry(ip, msg.ucIpPort);
        if (cm == null) {
            this.log.fine("received ChannelRouting msg for unknown ip " + (Object)((Object)ip));
            return;
        }
        cm.updateNat(msg);
        cm.storeChannelRoute(msg, this.log);
        if (cm.getIState() == BMemberStateEnum.SentCRReq) {
            cm.setIState(BMemberStateEnum.UpToDate);
        }
    }

    private void rcvAcknowledge(Acknowledge msg) {
    }

    private void rcvStatusRequest(RequestMessage req) {
        this.link.stats.updateGlobalStats(this.ipChan);
        StatisticsResp sr = new StatisticsResp(this.link.stats);
        if (req.clear) {
            this.link.stats = new Statistics();
        }
        this.send(sr, LonIpAddress.make(req));
    }

    private void sendAck(LonIpMessage msg, int ackType) {
        Acknowledge ack = new Acknowledge();
        ack.dateTime = BDateTime.make();
        ack.ackType = ackType;
        if (msg instanceof RequestMessage) {
            ack.requestId = ((RequestMessage)msg).requestId;
        }
        this.send(ack, LonIpAddress.make(msg.getSrcAddress(), msg.getSrcPort()));
    }

    private void send(LonIpMessage ipMsg, LonIpAddress ip) {
        if (this.useExtendedNat) {
            ipMsg.addExtendedNat(this.netCfg, false);
        }
        this.link.sendIpMessage(ipMsg, ip);
    }

    public void spy(SpyWriter out) throws Exception {
        this.adrMan.spy(out);
        out.startProps();
        out.trTitle((Object)"misc", 1);
        out.prop((Object)"isConfigServer", this.isConfigServer);
        out.prop((Object)"useExtendedNat", this.useExtendedNat);
        out.prop((Object)"state", (Object)this.stateToString());
        out.endProps();
    }
}

