/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.ws.jetty;

import com.tridium.crypto.core.cert.DefaultExemptionApprover;
import com.tridium.crypto.core.cert.TridiumHostnameVerifier;
import com.tridium.crypto.core.io.CoreClientTrustManager;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.CryptoSupport;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.baja.nre.security.ClientTlsParameters;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public final class WebsocketClientHolder {
    private static final Object MUTEX = new Object();
    private static WebSocketClient clientInstance;

    private WebsocketClientHolder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebSocketClient getInstance() throws Exception {
        Object object = MUTEX;
        synchronized (object) {
            if (clientInstance == null) {
                clientInstance = WebsocketClientHolder.startClient();
            }
            return clientInstance;
        }
    }

    private static WebSocketClient startClient() throws Exception {
        HttpClient jettyHttpClient = new HttpClient(WebsocketClientHolder.getWebSocketSslContextFactory());
        jettyHttpClient.start();
        WebSocketClient wsClient = new WebSocketClient(jettyHttpClient);
        wsClient.start();
        wsClient.setStopAtShutdown(true);
        return wsClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopClient() throws Exception {
        Object object = MUTEX;
        synchronized (object) {
            if (clientInstance != null) {
                clientInstance.getHttpClient().stop();
                clientInstance.stop();
                clientInstance = null;
            }
        }
    }

    private static SslContextFactory getWebSocketSslContextFactory() throws PrivilegedActionException {
        return AccessController.doPrivileged(() -> {
            CoreCryptoManager ccm = CoreCryptoManager.get();
            SslContextFactory.Client factory = ccm.getSslContextFactory(ClientTlsParameters.DEFAULT);
            factory.setEndpointIdentificationAlgorithm(null);
            factory.setHostnameVerifier((HostnameVerifier)new TridiumHostnameVerifier(ccm.getExemptionStore()));
            SSLContext sslContext = SSLContext.getInstance((String)CryptoSupport.TYPES.get("tlsv1.2"));
            CoreClientTrustManager trustManager = CoreClientTrustManager.make((CoreCryptoManager)ccm, DefaultExemptionApprover::new);
            TrustManager[] tm = new X509TrustManager[]{trustManager};
            sslContext.init(null, tm, null);
            factory.setSslContext(sslContext);
            factory.setSslSessionTimeout(125);
            return factory;
        });
    }
}

