/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.ws.jetty;

import com.tridium.driver.util.DrUtil;
import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.datatypes.BHttpAddress;
import com.tridium.httpClient.datatypes.auth.BAbstractHttpAuth;
import com.tridium.httpClient.datatypes.auth.BAuthorizationHeaderScheme;
import com.tridium.httpClient.datatypes.auth.BNoHttpAuth;
import com.tridium.httpClient.datatypes.exception.HttpCommException;
import com.tridium.httpClient.datatypes.options.BHttpHeaders;
import com.tridium.httpClient.ws.BWebsocketClient;
import com.tridium.httpClient.ws.BWebsocketConfig;
import com.tridium.httpClient.ws.WebsocketCallbacks;
import com.tridium.httpClient.ws.WebsocketClientSession;
import com.tridium.httpClient.ws.WsMessageEvent;
import com.tridium.httpClient.ws.jetty.WebsocketClientHolder;
import com.tridium.util.PrefixLogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.sys.BComplex;
import javax.baja.sys.Type;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;

@WebSocket
public class JettyWebsocketClientSession
implements WebsocketClientSession {
    private Session session;
    private BWebsocketConfig config;
    private WebsocketCallbacks callbacks;
    private final Object sessionMutex = new Object();
    private static final Pattern NULL_CHARS_PATTERN = Pattern.compile("\u0000", 16);

    @Override
    public void init(WebsocketCallbacks callbacks, BWebsocketConfig config) {
        this.callbacks = callbacks;
        this.config = config;
    }

    @Override
    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    @Override
    public int connect(BHttpAddress address, BHttpHeaders headers, BAbstractHttpAuth authenticator, long timeoutMillis) throws HttpCommException {
        String uriAddress = address.buildUrlBase();
        try {
            URI uri = new URI(uriAddress);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            this.applyAuthenticator(request, authenticator);
            headers.asMap().forEach((arg_0, arg_1) -> ((ClientUpgradeRequest)request).setHeader(arg_0, arg_1));
            PrefixLogUtil.logWithPrefix((Logger)BWebsocketClient.WS_LOGGER, (Level)Level.FINE, () -> String.format("Connecting to : %s", uri), (Object)((Object)address));
            Future futureSession = WebsocketClientHolder.getInstance().connect((Object)this, uri, request);
            Session session = (Session)futureSession.get(timeoutMillis, TimeUnit.MILLISECONDS);
            if (session != null) {
                PrefixLogUtil.logWithPrefix((Logger)BWebsocketClient.WS_LOGGER, (Level)Level.FINE, () -> String.format("Connection to : %s initiated", uri), (Object)((Object)address));
                return session.getUpgradeResponse().getStatusCode();
            }
            throw new Exception("Null session");
        }
        catch (Exception e) {
            PrefixLogUtil.logWithPrefix((Logger)BWebsocketClient.WS_LOGGER, (Level)Level.SEVERE, (String)String.format("Connection to : %s failed", uriAddress), (Throwable)e, (Object)this);
            if (e.getCause() instanceof UpgradeException) {
                throw new HttpCommException("Failed to initiate websocket connection", ((UpgradeException)e.getCause()).getResponseStatusCode(), e);
            }
            throw new HttpCommException("Failed to initiate websocket connection", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketConnect
    public void onConnect(Session session) {
        Object object = this.sessionMutex;
        synchronized (object) {
            this.session = session;
        }
        this.callbacks.sessionConnected(session.getRemoteAddress().toString());
    }

    @OnWebSocketMessage
    public void onMessage(String message) {
        String received = NULL_CHARS_PATTERN.matcher(message).replaceAll(Matcher.quoteReplacement(""));
        this.callbacks.messageReceived(this.session.getRemoteAddress().toString(), received);
    }

    @OnWebSocketMessage
    public void onBinaryMessage(byte[] bytes, int offset, int length) {
        String received = new String(bytes, offset, length, StandardCharsets.UTF_8);
        this.callbacks.messageReceived(this.session.getRemoteAddress().toString(), received);
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        this.callbacks.onError((Exception)((Object)new HttpCommException("Unexpected websocket error", cause)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.callbacks.sessionDisconnected(this.session.getRemoteAddress().toString(), statusCode, reason, null);
        Object object = this.sessionMutex;
        synchronized (object) {
            this.session = null;
        }
    }

    @Override
    public WsMessageEvent sendBytes(WsMessageEvent messageEvent, long timeoutMillis) throws HttpCommException {
        if (!this.isConnected()) {
            throw new HttpCommException("Illegal state: no websocket session");
        }
        FutureTask<WsMessageEvent> futureTask = this.createSendMessageTask(messageEvent);
        try {
            new Thread(futureTask).start();
            return futureTask.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            String error = "WebSocket Send Error";
            PrefixLogUtil.logWithPrefix((Logger)BWebsocketClient.WS_LOGGER, (Level)Level.SEVERE, (String)error, (Throwable)e, (Object)((Object)this.config));
            throw new HttpCommException(error, e);
        }
    }

    private FutureTask<WsMessageEvent> createSendMessageTask(WsMessageEvent messageEvent) {
        return new FutureTask<WsMessageEvent>(() -> {
            try (InputStream inputStream = messageEvent.getInputStream();){
                byte[] bytes = new byte[this.config.getFrameBufferSize()];
                long totalBytesRead = 0L;
                boolean complete = false;
                while (!complete) {
                    int bytesRead = inputStream.read(bytes);
                    totalBytesRead += (long)bytesRead;
                    if (bytesRead == -1) break;
                    complete = bytesRead < bytes.length || messageEvent.getExpectedOutgoingBytes() != -1L && totalBytesRead >= messageEvent.getExpectedOutgoingBytes();
                    PrefixLogUtil.logWithPrefix((Logger)BWebsocketClient.WS_LOGGER, (Level)Level.FINE, () -> String.format("Sending %d bytes to: %s", bytesRead, this.session.getRemoteAddress()), (Object)((Object)this.config));
                    byte[] trimmedBytes = new byte[bytesRead];
                    System.arraycopy(bytes, 0, trimmedBytes, 0, bytesRead);
                    this.sendBytes(trimmedBytes, complete);
                    byte[] trimmedBytesForRecord = new byte[bytesRead];
                    System.arraycopy(bytes, 0, trimmedBytesForRecord, 0, bytesRead);
                    messageEvent.appendToMessageRecord(trimmedBytesForRecord);
                }
                this.session.getRemote().flush();
            }
            return messageEvent;
        });
    }

    private void sendBytes(byte[] bytes, boolean complete) throws IOException {
        if (this.config.getWriteRawBytes()) {
            this.session.getRemote().sendPartialBytes(ByteBuffer.wrap(bytes), complete);
        } else {
            this.session.getRemote().sendPartialString(new String(bytes, StandardCharsets.UTF_8), complete);
        }
    }

    @Override
    public void disconnect(boolean stopping) {
        if (this.session != null) {
            this.session.close(stopping ? 1001 : 1000, "NiagaraDisconnect");
        }
    }

    private void applyAuthenticator(ClientUpgradeRequest upgradeRequest, BAbstractHttpAuth authenticator) throws HttpCommException {
        if (authenticator.getType().is(BAuthorizationHeaderScheme.TYPE)) {
            BIHttpCommClient client = (BIHttpCommClient)DrUtil.getParent((BComplex)this.config, (Type)BIHttpCommClient.TYPE);
            if (client == null) {
                throw new HttpCommException("No client provided for ws connection authentication");
            }
            AccessController.doPrivileged(() -> {
                upgradeRequest.setHeader("Authorization", ((BAuthorizationHeaderScheme)authenticator.as(BAuthorizationHeaderScheme.class)).getAuthHeaderValue(client));
                return null;
            });
        } else if (!authenticator.getType().is(BNoHttpAuth.TYPE)) {
            throw new HttpCommException("Unsupported authenticaiton type for jetty ws connections");
        }
    }
}

