/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.util;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.TrustManagerBuilder;
import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.datatypes.BHttpAddress;
import com.tridium.httpClient.datatypes.enums.BHttpMode;
import com.tridium.httpClient.datatypes.exception.HttpCommException;
import com.tridium.httpClient.datatypes.exception.HttpCommRuntimeException;
import com.tridium.httpClient.util.BIHttpConsumer;
import com.tridium.httpClient.util.HttpClientRegister;
import com.tridium.httpClient.util.HttpConsumable;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.baja.net.Http;
import javax.baja.security.BIProtected;
import javax.baja.security.SecurityAuditEvent;
import javax.baja.security.SecurityAuditor;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.util.Lexicon;
import javax.baja.web.authn.AuthMessage;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class HttpClientUtils {
    private static final Pattern TEXT_PATTERN = Pattern.compile(".*\\p{ASCII}+.*");
    private static final String LOGGER_PREFIX = "httpClient";
    public static final int MAX_CLIENT_HINT = 40;
    public static final String DEFAULT_MIME_TYPE = "text/plain";
    public static final Pattern JSON_PATTERN = Pattern.compile("[{\\[].*");
    public static final Lexicon LEX = Lexicon.make(HttpClientUtils.class);
    public static final Logger MAIN_LOGGER = Logger.getLogger("httpClient");
    public static final BIcon HTTP_EXPORT_ICON = BIcon.make((BIcon)BIcon.std((String)"web.png"), (BIcon)BIcon.make((String)"module://icons/x16/badges/export.png"));
    public static final BIcon HTTP_IMPORT_ICON = BIcon.make((BIcon)BIcon.std((String)"web.png"), (BIcon)BIcon.make((String)"module://icons/x16/badges/import.png"));

    private HttpClientUtils() {
    }

    public static Map<String, String> headerMultiMapToMap(Map<String, List<String>> headers) {
        if (headers == null || headers.isEmpty()) {
            return Collections.emptyMap();
        }
        return headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.join((CharSequence)",", (Iterable)entry.getValue())));
    }

    public static String safeHeadersForLogging(Map<String, List<String>> headers) {
        StringBuilder loggable = new StringBuilder("[");
        if (headers != null) {
            headers.forEach((key, values) -> {
                loggable.append((String)key).append(": ");
                values.forEach(value -> {
                    HttpClientUtils.obfuscate(loggable, value);
                    loggable.append(", ");
                });
            });
        }
        return loggable.append(']').toString();
    }

    private static void obfuscate(StringBuilder stringBuilder, String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (i < 3) {
                stringBuilder.append(value.charAt(i));
                continue;
            }
            stringBuilder.append('*');
        }
    }

    public static List<String> getHeaderTokens(String pairs) {
        if (!pairs.isEmpty()) {
            return Arrays.asList(pairs.split(";"));
        }
        return Collections.emptyList();
    }

    public static Optional<String[]> getFirstHeaderTokenPair(String headerVal) {
        List<String> tokens = HttpClientUtils.getHeaderTokens(headerVal);
        String firstTokenPair = tokens.isEmpty() ? "" : tokens.get(0);
        String[] firstTokenArr = firstTokenPair.split("=");
        if (firstTokenArr.length > 1) {
            return Optional.of(firstTokenArr);
        }
        return Optional.empty();
    }

    public static boolean isDefaultServicePort(BHttpAddress address) {
        return address.getPort() == address.getMode().getDefaultServicePort();
    }

    public static void populateFromUrl(BHttpAddress address, String urlString) {
        try {
            URL url = new URL(urlString);
            String protocol = url.getProtocol();
            try {
                address.setMode(BHttpMode.makeForScheme(protocol));
            }
            catch (InvalidEnumException e) {
                throw new BajaRuntimeException("Unsupported url protocol: " + protocol);
            }
            address.setHostAddress(url.getHost());
            int port = url.getPort();
            if (port == -1) {
                port = address.getMode().getDefaultServicePort();
            }
            address.setPort(port);
            address.setPath(url.getPath());
            HttpClientUtils.populateParameters(address, url.getQuery());
        }
        catch (MalformedURLException e) {
            if (urlString.toLowerCase().startsWith("ws")) {
                HttpClientUtils.populateFromUri(address, urlString);
            }
            throw new BajaRuntimeException(String.format("Invalid url string: %s, error: %s", urlString, e.getMessage()));
        }
    }

    public static void populateFromUri(BHttpAddress address, String uriString) {
        try {
            URI uri = new URI(uriString);
            String scheme = uri.getScheme();
            try {
                address.setMode(BHttpMode.makeForScheme(scheme));
            }
            catch (InvalidEnumException e) {
                throw new BajaRuntimeException("Unsupported uri scheme: " + scheme);
            }
            address.setHostAddress(uri.getHost());
            int port = uri.getPort();
            if (port == -1) {
                port = address.getMode().getDefaultServicePort();
            }
            address.setPort(port);
            address.setPath(uri.getPath());
            HttpClientUtils.populateParameters(address, uri.getQuery());
        }
        catch (URISyntaxException e) {
            throw new BajaRuntimeException(String.format("Invalid uri string: %s, error: %s", uriString, e.getMessage()));
        }
    }

    private static void populateParameters(BHttpAddress address, String query) {
        BIHttpCommClient client;
        if (query != null && !query.isEmpty() && (client = HttpClientUtils.getParent((BComplex)address, BIHttpCommClient.class)) != null) {
            client.getParameters().removeAll();
            Pattern.compile("&").splitAsStream(query).map(paramPair -> Arrays.copyOf(paramPair.split("="), 2)).forEach(paramArray -> client.getParameters().addNewOption(HttpClientUtils.decodeUrl(paramArray[0]), (BValue)BString.make((String)HttpClientUtils.decodeUrl(paramArray[1]))));
        }
    }

    private static String decodeUrl(String encoded) {
        try {
            return encoded == null ? "" : URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BajaRuntimeException("UTF-8 is a required encoding", (Throwable)e);
        }
    }

    public static String deriveTextContentType(InputStream is) throws IOException {
        String contentType = null;
        byte[] data = new byte[16];
        int read = is.read(data);
        if (read != -1) {
            String content = new String(data, 0, read, StandardCharsets.UTF_8);
            if (JSON_PATTERN.matcher(content).matches()) {
                contentType = "application/json";
            } else if (HttpClientUtils.isHtml(content)) {
                contentType = "text/html";
            } else if (TEXT_PATTERN.matcher(content).matches()) {
                contentType = DEFAULT_MIME_TYPE;
            }
        }
        contentType = contentType != null ? contentType + "; charset=UTF-8" : "";
        return contentType;
    }

    public static String updateFaultWithException(String fault, Exception exception) {
        if (exception != null && exception.getMessage() != null) {
            StringBuilder faultBuilder = new StringBuilder(fault);
            if (faultBuilder.length() > 0) {
                faultBuilder.append(", ");
            }
            Throwable cause = exception;
            while (cause instanceof HttpCommException || cause instanceof HttpCommRuntimeException) {
                faultBuilder.append(cause.getMessage()).append(' ');
                cause = cause.getCause();
            }
            if (cause != null) {
                faultBuilder.append(cause.getClass().getSimpleName()).append(" - ").append(cause.getMessage());
            }
            return faultBuilder.toString().trim();
        }
        return fault;
    }

    private static boolean isHtml(String data) {
        int samplelength = Integer.min(15, data.length());
        String sample = data.substring(samplelength).toLowerCase();
        return sample.startsWith("<!doctype html>") || sample.startsWith("<html>");
    }

    public static String getReasonPhrase(int responseCode) {
        if (responseCode < 1000) {
            return Http.getReasonPhrase((int)responseCode);
        }
        if (responseCode == 1000) {
            return LEX.getText("ws.normal.closure");
        }
        return LEX.getText("ws.status", new Object[]{String.valueOf(responseCode)});
    }

    public static Optional<String> readOptionalTokenFromAuthHeader(String authHeaderValue, String token, boolean decode) {
        try {
            return Optional.of(HttpClientUtils.readTokenFromAuthHeader(authHeaderValue, token, decode));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static String readTokenFromAuthHeader(String authHeaderValue, String token, boolean decode) {
        AuthMessage authMessage = AuthMessage.decodeFromString((String)authHeaderValue);
        String val = authMessage.getParameter(token);
        if (val == null) {
            throw new BajaRuntimeException("Missing token: " + token);
        }
        if (decode) {
            val = HttpClientUtils.fromBase64(val);
        }
        return val;
    }

    public static void auditAddressChange(BHttpAddress address, @Nullable Context context) {
        String auditMessage = String.format("The http client address %s has been changed to %s", new Object[]{address.getSlotPath(), address});
        String auditUser = context != null ? context.getUser().toString() : "unknown";
        SecurityAuditor securityAuditor = Nre.getSecurityAuditor();
        if (securityAuditor != null) {
            securityAuditor.audit(new SecurityAuditEvent("Changed", auditUser, auditMessage));
        }
    }

    public static <T> T getParent(BComplex complex, Class<T> parentTypeToSeek) {
        BComplex parent;
        while ((parent = complex.getParent()) != null) {
            if (parentTypeToSeek.isAssignableFrom(parent.getType().getTypeClass())) {
                return (T)parent;
            }
            complex = parent;
        }
        return null;
    }

    public static void updateConsumers(BComponent component, HttpConsumable consumable) {
        BIHttpConsumer[] consumers = (BIHttpConsumer[])((BComponent)component.as(BComponent.class)).getChildren(BIHttpConsumer.class);
        Arrays.stream(consumers).forEach(consumer -> consumer.consume(consumable));
        Arrays.stream(component.getChildComponents()).forEach(child -> HttpClientUtils.updateConsumers(child, consumable));
    }

    public static X509TrustManager getTrustManager() throws IOException {
        CoreCryptoManager coreCryptoManager = CoreCryptoManager.get();
        CertificateChainValidator certificateChainValidator = new CertificateChainValidator();
        certificateChainValidator.rebuildTrustAnchors((ICoreCryptoManager)coreCryptoManager);
        Set trustAnchors = certificateChainValidator.getTrustAnchors();
        TrustManager[] managers = TrustManagerBuilder.getTrustManagers((Set)trustAnchors);
        if (managers.length > 0 && managers[0] instanceof X509TrustManager) {
            return (X509TrustManager)managers[0];
        }
        throw new IOException("Failed to construct trust manager");
    }

    public static String fromBase64(String val) {
        return new String(Base64.getUrlDecoder().decode(val), StandardCharsets.UTF_8);
    }

    public static String toBase64(String val) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(val.getBytes(StandardCharsets.UTF_8));
    }

    public static Map<String, String> findAllClients(Context context) {
        ArrayList clientNames = new ArrayList();
        return HttpClientRegister.getClients().stream().map(client -> (BComponent)client).filter(client -> HttpClientUtils.hasReadPermission(client, context)).collect(Collectors.toMap(comp -> comp.getHandleOrd().toString(), comp -> HttpClientUtils.getUniqueClientDisplayName(comp, clientNames, context)));
    }

    private static String getUniqueClientDisplayName(BComponent component, List<String> clientNames, Context cx) {
        String displayName = component.getDisplayName(cx);
        if (clientNames.contains(displayName)) {
            String slotPath = component.getSlotPath().getBody();
            String hint = slotPath.substring(0, slotPath.lastIndexOf(47));
            hint = (hint = StringUtils.abbreviate((String)hint, (int)hint.length(), (int)40)).isEmpty() ? "/" : hint;
            displayName = displayName + '(' + hint + ')';
        }
        clientNames.add(displayName);
        return displayName;
    }

    private static boolean hasReadPermission(Object obj, Context cx) {
        if (obj instanceof BIProtected) {
            return ((BIProtected)obj).getPermissions(cx).hasOperatorRead();
        }
        return true;
    }

    public static Logger child(String name) {
        return Logger.getLogger("httpClient." + name);
    }
}

