/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.driver.point;

import com.tridium.driver.util.DrUtil;
import com.tridium.httpClient.BHttpClientService;
import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.client.BIHttpCommClientWrite;
import com.tridium.httpClient.comm.client.HttpCommResponse;
import com.tridium.httpClient.datatypes.BHttpAddress;
import com.tridium.httpClient.datatypes.BHttpResponseHealth;
import com.tridium.httpClient.datatypes.BHttpTuningPolicy;
import com.tridium.httpClient.datatypes.options.BHttpHeaders;
import com.tridium.httpClient.datatypes.options.BHttpParameters;
import com.tridium.httpClient.datatypes.options.BMultiAddOptions;
import com.tridium.httpClient.datatypes.payload.BRequestBody;
import com.tridium.httpClient.datatypes.payload.BSlotSource;
import com.tridium.httpClient.driver.BHttpClientDevice;
import com.tridium.httpClient.driver.BHttpClientNetwork;
import com.tridium.httpClient.driver.point.BHttpClientPointDeviceExt;
import com.tridium.httpClient.util.HttpClientRegister;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.httpClient.util.MultiAddUtil;
import com.tridium.httpClient.util.ParentLegal;
import com.tridium.ndriver.point.BNProxyExt;
import com.tridium.ndriver.poll.BINPollable;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.util.PrefixLogUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BStringPoint;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.httpClient.datatypes.BHttpRequestMethod;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="health", type="BHttpResponseHealth", defaultValue="new BHttpResponseHealth()"), @NiagaraProperty(name="address", type="BHttpAddress", defaultValue="new BHttpAddress()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="method", type="BHttpRequestMethod", defaultValue="BHttpRequestMethod.DEFAULT", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="headers", type="BHttpHeaders", defaultValue="new BHttpHeaders()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="parameters", type="BHttpParameters", defaultValue="new BHttpParameters()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="requestBody", type="BRequestBody", defaultValue="new BRequestBody()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="conversion", type="BProxyConversion", defaultValue="BDefaultProxyConversion.DEFAULT", flags=4, override=true), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}, override=true), @NiagaraProperty(name="tuningPolicyName", type="String", defaultValue="defaultPolicy", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)"), @Facet(name="BFacets.FIELD_EDITOR", value="\"driver:TuningPolicyNameFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"driver:TuningPolicyEditor\"")}, override=true), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.DEFAULT", flags=65603, facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")}, override=true)})
@NiagaraActions(value={@NiagaraAction(name="send", flags=16), @NiagaraAction(name="clearLastResult"), @NiagaraAction(name="addMore", parameterType="BMultiAddOptions", defaultValue="new BMultiAddOptions(\"httpClient:HttpProxyExt\")")})
public class BHttpClientProxyExt
extends BNProxyExt
implements BINPollable,
BIHttpCommClient,
BIHttpCommClientWrite {
    @Generated
    public static final Property health = BHttpClientProxyExt.newProperty((int)0, (BValue)new BHttpResponseHealth(), null);
    @Generated
    public static final Property address = BHttpClientProxyExt.newProperty((int)0, (BValue)new BHttpAddress(), (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property method = BHttpClientProxyExt.newProperty((int)0, (BValue)BHttpRequestMethod.DEFAULT, (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property headers = BHttpClientProxyExt.newProperty((int)0, (BValue)new BHttpHeaders(), (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property parameters = BHttpClientProxyExt.newProperty((int)0, (BValue)new BHttpParameters(), (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property requestBody = BHttpClientProxyExt.newProperty((int)0, (BValue)new BRequestBody(), (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property conversion = BHttpClientProxyExt.newProperty((int)4, (BValue)BDefaultProxyConversion.DEFAULT, null);
    @Generated
    public static final Property enabled = BHttpClientProxyExt.newProperty((int)0, (boolean)true, (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property tuningPolicyName = BHttpClientProxyExt.newProperty((int)0, (String)"defaultPolicy", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)BFacets.make((String)"fieldEditor", (String)"driver:TuningPolicyNameFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"driver:TuningPolicyEditor")));
    @Generated
    public static final Property pollFrequency = BHttpClientProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property status = BHttpClientProxyExt.newProperty((int)65603, (BValue)BStatus.DEFAULT, (BFacets)SfUtil.incl((String)"un"));
    @Generated
    public static final Action send = BHttpClientProxyExt.newAction((int)16, null);
    @Generated
    public static final Action clearLastResult = BHttpClientProxyExt.newAction((int)0, null);
    @Generated
    public static final Action addMore = BHttpClientProxyExt.newAction((int)0, (BValue)new BMultiAddOptions("httpClient:HttpProxyExt"), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHttpClientProxyExt.class);
    private final Object subscribeLock = new Object();

    @Override
    @Generated
    public BHttpResponseHealth getHealth() {
        return (BHttpResponseHealth)this.get(health);
    }

    @Override
    @Generated
    public void setHealth(BHttpResponseHealth v) {
        this.set(health, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpAddress getAddress() {
        return (BHttpAddress)this.get(address);
    }

    @Override
    @Generated
    public void setAddress(BHttpAddress v) {
        this.set(address, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpRequestMethod getMethod() {
        return (BHttpRequestMethod)this.get(method);
    }

    @Override
    @Generated
    public void setMethod(BHttpRequestMethod v) {
        this.set(method, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpHeaders getHeaders() {
        return (BHttpHeaders)this.get(headers);
    }

    @Override
    @Generated
    public void setHeaders(BHttpHeaders v) {
        this.set(headers, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpParameters getParameters() {
        return (BHttpParameters)this.get(parameters);
    }

    @Override
    @Generated
    public void setParameters(BHttpParameters v) {
        this.set(parameters, (BValue)v, null);
    }

    @Override
    @Generated
    public BRequestBody getRequestBody() {
        return (BRequestBody)this.get(requestBody);
    }

    @Generated
    public void setRequestBody(BRequestBody v) {
        this.set(requestBody, (BValue)v, null);
    }

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Override
    @Generated
    public void send() {
        this.invoke(send, null, null);
    }

    @Generated
    public void clearLastResult() {
        this.invoke(clearLastResult, null, null);
    }

    @Generated
    public void addMore(BMultiAddOptions parameter) {
        this.invoke(addMore, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BHttpClientNetwork getHttpNetwork() {
        return (BHttpClientNetwork)this.getNetwork();
    }

    public final BHttpClientDevice getHttpDevice() {
        return (BHttpClientDevice)DrUtil.getParent((BComplex)this, (Type)BHttpClientDevice.TYPE);
    }

    public final BHttpClientPointDeviceExt getHttpPointDeviceExt() {
        return (BHttpClientPointDeviceExt)this.getDeviceExt();
    }

    @Override
    public final BHttpTuningPolicy getHttpTuningPolicy() {
        return (BHttpTuningPolicy)this.getTuningPolicy();
    }

    public Type getDeviceExtType() {
        return BHttpClientPointDeviceExt.TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSubscribed(Context cx) {
        Object object = this.subscribeLock;
        synchronized (object) {
            this.getHttpNetwork().getPollScheduler().subscribe((BIPollable)this);
        }
        this.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readUnsubscribed(Context cx) {
        Object object = this.subscribeLock;
        synchronized (object) {
            this.getHttpNetwork().getPollScheduler().unsubscribe((BIPollable)this);
        }
    }

    public boolean write(Context cx) {
        if (this.getParentPoint().isWritablePoint()) {
            if (!this.getWriteValue().getStatus().isNull()) {
                String writeMe = String.valueOf(this.getWriteValue().getValueValue());
                if (this.getPayloadSource() instanceof BSlotSource) {
                    ((BSlotSource)this.getPayloadSource().as(BSlotSource.class)).setData(writeMe);
                    this.writeRequested();
                    return true;
                }
                PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.WARNING, () -> "Payload source not supported for writable point: " + this.getParentPoint().getName(), (Object)this);
            }
        } else {
            PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.WARNING, () -> "Write not possible for point " + this.getParentPoint().getName(), (Object)this);
        }
        return false;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    @Override
    public String sendSync() {
        this.doSend(null);
        return this.getLastResponseBody();
    }

    @Override
    public final boolean isDriverBasedClient() {
        return true;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        return BHttpClientService.post((BComponent)this, action, argument, cx);
    }

    public void doPoll() {
        this.doSend(null);
    }

    public final void doSend(Context cx) {
        if (this.isRunning() && !this.isFatalFault() && BHttpClientService.permittedByService((BIHttpCommClient)this, cx) && this.isReallyEnabled() && !this.isFaultFound()) {
            try {
                BHttpClientDevice parentDevice = this.getHttpDevice();
                if (parentDevice == null) {
                    this.readWriteFail(HttpClientUtils.LEX.get("err.http.no.device"));
                } else {
                    PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, (String)"proxy poll", (Object)this);
                    HttpCommResponse response = parentDevice.send(this, this);
                    if (response.isGood()) {
                        this.readWriteOk(response.getBody());
                    } else {
                        this.readWriteFail(this.getHealth().getFaultCause());
                    }
                }
            }
            catch (Exception e) {
                this.readWriteFail(e.getLocalizedMessage());
            }
        }
    }

    public void doClearLastResult() {
        this.getHealth().reset();
        this.readOk((BStatusValue)new BStatusString());
        this.writeOk((BStatusValue)new BStatusString());
    }

    public void doAddMore(BMultiAddOptions options) {
        MultiAddUtil.addMulti((BComponent)this, options);
    }

    @Override
    public void writeRequested() {
        this.send();
    }

    public void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property.equals(enabled) && this.getTuningPolicy().getWriteOnEnabled() && this.shouldSend()) {
                this.send();
            }
            if (property.equals(address)) {
                HttpClientUtils.auditAddressChange(this.getAddress(), context);
            }
        }
    }

    private boolean shouldSend() {
        return this.isRunning() && this.getEnabled() && this.getAddress().isConfigured();
    }

    public void started() {
        this.readReset();
        if (Sys.isStation()) {
            HttpClientRegister.registerClient(this);
            if (!this.isFatalFault() && this.getTuningPolicy().getWriteOnStart() && this.shouldSend()) {
                this.send();
            }
        }
    }

    public void stopped() {
        if (Sys.isStation()) {
            HttpClientRegister.unregisterClient(this);
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BStringPoint.TYPE);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(addMore)) {
            return new BMultiAddOptions((BComponent)this, true);
        }
        return super.getActionParameterDefault(action);
    }

    private boolean isReallyEnabled() {
        return this.getNetwork().getEnabled() && this.getDevice().getEnabled() && this.getEnabled();
    }

    private boolean isFaultFound() {
        return this.getNetwork().isFatalFault() && this.getDevice().isFatalFault() && this.isFatalFault();
    }

    private void readWriteOk(String responseBody) {
        this.readOk((BStatusValue)new BStatusString(responseBody));
        if (this.getParentPoint().isWritablePoint() && !this.getWriteValue().getStatus().isNull()) {
            this.writeOk((BStatusValue)new BStatusString(responseBody));
        }
    }

    private void readWriteFail(String reason) {
        this.readFail(reason);
        if (this.getParentPoint().isWritablePoint() && !this.getWriteValue().getStatus().isNull()) {
            this.writeFail(reason);
        }
    }

    public String identifierForLogs() {
        return this.getParentPoint().getName();
    }
}

