/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.datatypes.options.autoheaders;

import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.client.BIHttpCommClientWrite;
import com.tridium.httpClient.datatypes.options.autoheaders.BAutoHeader;
import com.tridium.httpClient.datatypes.payload.BAbstractPayloadSource;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.util.PrefixLogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.httpClient.datatypes.BHttpRequestMethod;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="userContentType", type="String", defaultValue="BString.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"httpClient:MediaTypeFieldEditor\"))")})
public class BContentTypeHeader
extends BAutoHeader {
    @Generated
    public static final Property userContentType = BContentTypeHeader.newProperty((int)0, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"httpClient:MediaTypeFieldEditor")));
    @Generated
    public static final Type TYPE = Sys.loadType(BContentTypeHeader.class);

    @Generated
    public String getUserContentType() {
        return this.getString(userContentType);
    }

    @Generated
    public void setUserContentType(String v) {
        this.setString(userContentType, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected String calculateNewValue() {
        String contentType = "";
        String usersContentType = this.getUserContentType();
        if (usersContentType != null && !usersContentType.isEmpty()) {
            return usersContentType;
        }
        BIHttpCommClientWrite write = HttpClientUtils.getParent((BComplex)this, BIHttpCommClientWrite.class);
        BIHttpCommClient client = HttpClientUtils.getParent((BComplex)this, BIHttpCommClient.class);
        if (write != null && client != null && client.getMethod() != BHttpRequestMethod.get) {
            contentType = this.deriveContentType(write.getPayloadSource());
        }
        return contentType;
    }

    private String deriveContentType(BAbstractPayloadSource payloadSource) {
        String contentType = "";
        try (InputStream is = payloadSource.getStream();){
            contentType = URLConnection.guessContentTypeFromStream(is);
            if (contentType == null) {
                contentType = HttpClientUtils.deriveTextContentType(is);
            }
        }
        catch (IOException e) {
            PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.WARNING, (String)"Error guessing content type", (Throwable)e, (Object)this);
        }
        return contentType;
    }
}

