/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.datatypes.enums;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="insecure"), @Range(value="secure")}, defaultValue="secure")
public final class BHttpMode
extends BFrozenEnum {
    @Generated
    public static final int INSECURE = 0;
    @Generated
    public static final int SECURE = 1;
    @Generated
    public static final BHttpMode insecure = new BHttpMode(0);
    @Generated
    public static final BHttpMode secure;
    @Generated
    public static final BHttpMode DEFAULT;
    @Generated
    public static final Type TYPE;

    @Generated
    public static BHttpMode make(int ordinal) {
        return (BHttpMode)insecure.getRange().get(ordinal, false);
    }

    @Generated
    public static BHttpMode make(String tag) {
        return (BHttpMode)insecure.getRange().get(tag);
    }

    @Generated
    private BHttpMode(int ordinal) {
        super(ordinal);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public int getDefaultServicePort() {
        return this.equals((Object)insecure) ? 80 : 443;
    }

    public String getModeString(boolean websocket) {
        return websocket ? (this == insecure ? "ws" : "wss") : (this == insecure ? "http" : "https");
    }

    public static BHttpMode makeForScheme(String scheme) {
        String lowerScheme = scheme.toLowerCase();
        if (lowerScheme.equals("http") || lowerScheme.equals("ws")) {
            return insecure;
        }
        if (lowerScheme.equals("https") || lowerScheme.equals("wss")) {
            return secure;
        }
        throw new BajaRuntimeException("Unsupported url protocol: " + scheme);
    }

    static {
        DEFAULT = secure = new BHttpMode(1);
        TYPE = Sys.loadType(BHttpMode.class);
    }
}

