/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.comm.client;

import com.tridium.httpClient.comm.client.ResponseHeaders;
import com.tridium.httpClient.util.HttpConsumable;
import java.util.Optional;
import javax.baja.httpClient.IHttpResponse;

public class HttpCommResponse
implements HttpConsumable,
IHttpResponse {
    private final String result;
    private ResponseHeaders headers;
    private final int responseCode;
    private final String fault;
    private final Exception exception;
    private long durationMillis;
    public static final int HTTP_SUCCESS_START = 200;
    public static final int HTTP_SUCCESS_END = 299;

    private HttpCommResponse(String result, int responseCode, ResponseHeaders headers, String fault, Exception exception) {
        this.result = result;
        this.responseCode = responseCode;
        this.headers = headers;
        this.exception = exception;
        this.fault = fault;
        if (headers == null) {
            this.headers = ResponseHeaders.EMPTY;
        }
    }

    public static HttpCommResponse makeGood(String result, int responseCode, ResponseHeaders headers) {
        return new HttpCommResponse(result, responseCode, headers, "", null);
    }

    public static HttpCommResponse makeFailed(String result, int responseCode, ResponseHeaders headers, String fault, Exception exception) {
        if (fault == null || fault.isEmpty() && exception != null) {
            fault = "Exception occurred";
        }
        return new HttpCommResponse(result, responseCode, headers, fault, exception);
    }

    public static HttpCommResponse makeFailed(Exception exception) {
        return HttpCommResponse.makeFailed("", -1, ResponseHeaders.EMPTY, "", exception);
    }

    @Override
    public String getBody() {
        return this.result;
    }

    @Override
    public int getResponseCode() {
        return this.responseCode;
    }

    public ResponseHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public Optional<String> getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public String getFault() {
        return this.fault;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isSuccessResponse() {
        return HttpCommResponse.isSuccessResponse(this.responseCode);
    }

    public static boolean isSuccessResponse(int response) {
        return response >= 200 && response <= 299;
    }

    public static boolean isWebSocketUpgrade(int response) {
        return response == 101;
    }

    public boolean isGood() {
        return HttpCommResponse.isSuccessResponse(this.responseCode) && this.fault.isEmpty() && this.exception == null;
    }

    public boolean failed() {
        return this.exception != null || this.responseCode == -1;
    }

    public boolean inRange(int lowerInclusive, int upperInclusive) {
        return this.responseCode >= lowerInclusive && this.responseCode <= upperInclusive;
    }

    public long getDurationMillis() {
        return this.durationMillis;
    }

    public void setDurationMillis(long durationMillis) {
        this.durationMillis = durationMillis;
    }
}

