/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient;

import com.tridium.httpClient.BHttpClientGlobalCapacityExt;
import com.tridium.httpClient.BHttpClientService;
import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.client.BIHttpCommClientTransport;
import com.tridium.httpClient.comm.client.BIHttpCommClientWrite;
import com.tridium.httpClient.comm.client.HttpCommResponse;
import com.tridium.httpClient.comm.transport.BHttpTransport;
import com.tridium.httpClient.datatypes.BHttpAddress;
import com.tridium.httpClient.datatypes.BHttpResponseHealth;
import com.tridium.httpClient.datatypes.BHttpStandaloneTuningPolicy;
import com.tridium.httpClient.datatypes.BHttpTuningPolicy;
import com.tridium.httpClient.datatypes.auth.BHttpAuthenticator;
import com.tridium.httpClient.datatypes.options.BHttpHeaders;
import com.tridium.httpClient.datatypes.options.BHttpParameters;
import com.tridium.httpClient.datatypes.options.BMultiAddOptions;
import com.tridium.httpClient.datatypes.payload.BRequestBody;
import com.tridium.httpClient.driver.point.BHttpClientPointDeviceExt;
import com.tridium.httpClient.driver.point.BHttpClientPointFolder;
import com.tridium.httpClient.util.HttpClientRegister;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.httpClient.util.MultiAddUtil;
import com.tridium.util.PrefixLogUtil;
import java.security.AccessController;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.httpClient.datatypes.BHttpRequestMethod;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true", flags=8), @NiagaraProperty(name="out", type="BString", defaultValue="BString.DEFAULT", flags=65547, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="proxy", type="BHttpClientGlobalCapacityExt", defaultValue="new BHttpClientGlobalCapacityExt()", flags=4), @NiagaraProperty(name="health", type="BHttpResponseHealth", defaultValue="new BHttpResponseHealth()"), @NiagaraProperty(name="address", type="BHttpAddress", defaultValue="new BHttpAddress()"), @NiagaraProperty(name="method", type="BHttpRequestMethod", defaultValue="BHttpRequestMethod.DEFAULT"), @NiagaraProperty(name="headers", type="BHttpHeaders", defaultValue="new BHttpHeaders()"), @NiagaraProperty(name="parameters", type="BHttpParameters", defaultValue="new BHttpParameters()"), @NiagaraProperty(name="httpTuningPolicy", type="BHttpTuningPolicy", defaultValue="new BHttpStandaloneTuningPolicy()"), @NiagaraProperty(name="authenticator", type="BHttpAuthenticator", defaultValue="new BHttpAuthenticator()"), @NiagaraProperty(name="transport", type="BHttpTransport", defaultValue="new BHttpTransport()"), @NiagaraProperty(name="requestBody", type="BRequestBody", defaultValue="new BRequestBody()")})
@NiagaraActions(value={@NiagaraAction(name="send", flags=16), @NiagaraAction(name="clearLastResult"), @NiagaraAction(name="addMore", parameterType="BMultiAddOptions", defaultValue="new BMultiAddOptions(\"httpClient:HttpClient\")")})
public class BHttpClient
extends BComponent
implements BIHttpCommClient,
BIHttpCommClientTransport,
BIHttpCommClientWrite {
    @Generated
    public static final Property enabled = BHttpClient.newProperty((int)8, (boolean)true, null);
    @Generated
    public static final Property out = BHttpClient.newProperty((int)65547, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property proxy = BHttpClient.newProperty((int)4, (BValue)new BHttpClientGlobalCapacityExt(), null);
    @Generated
    public static final Property health = BHttpClient.newProperty((int)0, (BValue)new BHttpResponseHealth(), null);
    @Generated
    public static final Property address = BHttpClient.newProperty((int)0, (BValue)new BHttpAddress(), null);
    @Generated
    public static final Property method = BHttpClient.newProperty((int)0, (BValue)BHttpRequestMethod.DEFAULT, null);
    @Generated
    public static final Property headers = BHttpClient.newProperty((int)0, (BValue)new BHttpHeaders(), null);
    @Generated
    public static final Property parameters = BHttpClient.newProperty((int)0, (BValue)new BHttpParameters(), null);
    @Generated
    public static final Property httpTuningPolicy = BHttpClient.newProperty((int)0, (BValue)new BHttpStandaloneTuningPolicy(), null);
    @Generated
    public static final Property authenticator = BHttpClient.newProperty((int)0, (BValue)new BHttpAuthenticator(), null);
    @Generated
    public static final Property transport = BHttpClient.newProperty((int)0, (BValue)new BHttpTransport(), null);
    @Generated
    public static final Property requestBody = BHttpClient.newProperty((int)0, (BValue)new BRequestBody(), null);
    @Generated
    public static final Action send = BHttpClient.newAction((int)16, null);
    @Generated
    public static final Action clearLastResult = BHttpClient.newAction((int)0, null);
    @Generated
    public static final Action addMore = BHttpClient.newAction((int)0, (BValue)new BMultiAddOptions("httpClient:HttpClient"), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHttpClient.class);
    private Clock.Ticket sendOnStartTicket = Clock.expiredTicket;
    private static final Random random = new Random();
    private static final Logger HTTPCLIENT_LOG = HttpClientUtils.child("httpClient");
    private static final String ADVISORY_MSG = "Standalone Http Client placed beneath an Http Network is not supported and will cause an exception, using legacy behaviour due to system property httpClient.allowHttpClientBeneathHttpClientNetwork=true. The Http Client should be moved outside of the Network.";
    private static Boolean ALLOW_HTTPCLIENT_BENEATH_HTTPCLIENT_NETWORK = AccessController.doPrivileged(() -> Boolean.getBoolean("httpClient.allowHttpClientBeneathHttpClientNetwork"));

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public String getOut() {
        return this.getString(out);
    }

    @Generated
    public void setOut(String v) {
        this.setString(out, v, null);
    }

    @Generated
    public BHttpClientGlobalCapacityExt getProxy() {
        return (BHttpClientGlobalCapacityExt)this.get(proxy);
    }

    @Generated
    public void setProxy(BHttpClientGlobalCapacityExt v) {
        this.set(proxy, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpResponseHealth getHealth() {
        return (BHttpResponseHealth)this.get(health);
    }

    @Override
    @Generated
    public void setHealth(BHttpResponseHealth v) {
        this.set(health, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpAddress getAddress() {
        return (BHttpAddress)this.get(address);
    }

    @Override
    @Generated
    public void setAddress(BHttpAddress v) {
        this.set(address, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpRequestMethod getMethod() {
        return (BHttpRequestMethod)this.get(method);
    }

    @Override
    @Generated
    public void setMethod(BHttpRequestMethod v) {
        this.set(method, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpHeaders getHeaders() {
        return (BHttpHeaders)this.get(headers);
    }

    @Override
    @Generated
    public void setHeaders(BHttpHeaders v) {
        this.set(headers, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpParameters getParameters() {
        return (BHttpParameters)this.get(parameters);
    }

    @Override
    @Generated
    public void setParameters(BHttpParameters v) {
        this.set(parameters, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpTuningPolicy getHttpTuningPolicy() {
        return (BHttpTuningPolicy)this.get(httpTuningPolicy);
    }

    @Generated
    public void setHttpTuningPolicy(BHttpTuningPolicy v) {
        this.set(httpTuningPolicy, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpAuthenticator getAuthenticator() {
        return (BHttpAuthenticator)this.get(authenticator);
    }

    @Override
    @Generated
    public void setAuthenticator(BHttpAuthenticator v) {
        this.set(authenticator, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpTransport getTransport() {
        return (BHttpTransport)this.get(transport);
    }

    @Override
    @Generated
    public void setTransport(BHttpTransport v) {
        this.set(transport, (BValue)v, null);
    }

    @Override
    @Generated
    public BRequestBody getRequestBody() {
        return (BRequestBody)this.get(requestBody);
    }

    @Generated
    public void setRequestBody(BRequestBody v) {
        this.set(requestBody, (BValue)v, null);
    }

    @Override
    @Generated
    public void send() {
        this.invoke(send, null, null);
    }

    @Generated
    public void clearLastResult() {
        this.invoke(clearLastResult, null, null);
    }

    @Generated
    public void addMore(BMultiAddOptions parameter) {
        this.invoke(addMore, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void doSend(Context cx) {
        this.commonPoll(cx);
    }

    public void doAddMore(BMultiAddOptions options) {
        MultiAddUtil.addMulti(this, options);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(addMore)) {
            return new BMultiAddOptions(this, false);
        }
        return super.getActionParameterDefault(action);
    }

    private String commonPoll(Context cx) {
        if (this.getEnabled() && BHttpClientService.permittedByService((BIHttpCommClient)this, cx)) {
            this.cancelSendOnStartTicket();
            PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, (String)"client poll", (Object)this);
            HttpCommResponse response = this.send(this, this);
            this.setOut(response.getBody());
            return response.getBody();
        }
        return "";
    }

    public void doClearLastResult() {
        this.setOut("");
        this.getHealth().reset();
    }

    @Override
    public void writeRequested() {
        this.send();
    }

    @Override
    public final String sendSync() {
        return this.commonPoll(null);
    }

    @Override
    public final boolean isDriverBasedClient() {
        return false;
    }

    public void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property.equals(enabled)) {
                BStatus update = BStatus.makeDisabled((BStatus)this.getHealth().getStatus(), (!this.getEnabled() ? 1 : 0) != 0);
                this.getHealth().setStatus(update);
            }
            if (this.getHttpTuningPolicy().getWriteOnEnabled() && property.equals(enabled) && this.shouldSend()) {
                this.send();
            }
            if (property.equals(address)) {
                HttpClientUtils.auditAddressChange(this.getAddress(), context);
            }
        }
    }

    public void started() {
        if (Sys.isStation()) {
            HttpClientRegister.registerClient(this);
            if (this.getHttpTuningPolicy().getWriteOnStart() && this.shouldSend()) {
                this.sendOnStart();
            }
        }
    }

    public void stopped() {
        if (Sys.isStation()) {
            HttpClientRegister.unregisterClient(this);
            this.cancelSendOnStartTicket();
        }
    }

    private boolean shouldSend() {
        return this.isRunning() && this.getEnabled() && this.getAddress().isConfigured();
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        return BHttpClientService.post(this, action, argument, cx);
    }

    private void sendOnStart() {
        this.cancelSendOnStartTicket();
        long randMillis = ((BHttpStandaloneTuningPolicy)this.getHttpTuningPolicy().as(BHttpStandaloneTuningPolicy.class)).getWriteOnStartRandomization().getMillis();
        if (randMillis > 0L) {
            randMillis = random.nextInt((int)randMillis);
            BAbsTime randTime = BAbsTime.now().add(BRelTime.make((long)randMillis));
            if (randTime.isAfter(BAbsTime.now())) {
                PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINEST, (String)("Scheduled send for " + randTime), (Object)this);
                this.sendOnStartTicket = Clock.schedule((BComponent)this, (BAbsTime)randTime, (Action)send, null);
            } else {
                this.send();
            }
        } else {
            this.send();
        }
    }

    private void cancelSendOnStartTicket() {
        if (!this.sendOnStartTicket.isExpired()) {
            this.sendOnStartTicket.cancel();
            this.sendOnStartTicket = Clock.expiredTicket;
        }
    }

    public boolean isParentLegal(BComponent parent) {
        boolean parentLegal;
        boolean bl = parentLegal = !parent.getType().is(BHttpClientPointDeviceExt.TYPE) && !parent.getType().is(BHttpClientPointFolder.TYPE);
        if (ALLOW_HTTPCLIENT_BENEATH_HTTPCLIENT_NETWORK.booleanValue() && !parentLegal) {
            HTTPCLIENT_LOG.log(Level.INFO, ADVISORY_MSG);
            return true;
        }
        return parentLegal;
    }

    public String identifierForLogs() {
        return this.getName();
    }

    public BIcon getIcon() {
        return HttpClientUtils.HTTP_EXPORT_ICON;
    }
}

