/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platIEEE8021X;

import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.niagarad.servlet.IEEE8021XServlet;
import com.tridium.nre.security.PBEDecryptingInputStream;
import com.tridium.nre.security.PBEEncodingKey;
import com.tridium.platIEEE8021X.BIEEE8021XAdapterSettings;
import com.tridium.platIEEE8021X.BIEEE8021XEAPMethod;
import com.tridium.platIEEE8021X.BIEEE8021XHostSettings;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCachedDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.FileHeaderInfo;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileHeaderMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.GetDirectoryMessage;
import com.tridium.platform.daemon.message.GetIEEE8021XMessage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.SlotCursor;
import javax.baja.util.LexiconModule;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public final class IEEE8021XUtil {
    private static final LexiconModule LEXICON = LexiconModule.make((String)"platIEEE8021X");
    private static final Logger LOG = Logger.getLogger("platIEEE8021X.util");
    public static final String UNLICENSED_LEX_KEY = "unlicensed";
    public static final String DISABLED_LEX_KEY = "disabled";
    public static final String UNKNOWN_LEX_KEY = "unknown";
    public static final String AUTHENTICATED_LEX_KEY = "authenticated";
    public static final String NO_CERTIFICATE = LEXICON.getText("IEEE8021XAdapterSettingsEditor.blankCertificate", null);
    public static final String NO_OPTIONS = LEXICON.getText("IEEE8021XAdapterSettingsEditor.blankOptions", null);
    public static final FilePath CA_CERTS_PATH = new FilePath("ca_certs");
    public static final FilePath PRIVATE_KEYS_PATH = new FilePath("private_keys");
    public static final FilePath CLIENT_CERTS_PATH = new FilePath("client_certs");
    public static final String LICENSE_FEATURE = "ieee8021x";
    public static final String LICENSE_VENDOR = "tridium";
    public static final String DESCRIPTION = "#Niagara IEEE 802.1X wired authentication configuration file";
    public static final String MODIFY_WARNING = "#Do not modify, use the IEEE 802.1X UI to make changes to this file";
    public static final String CREATED = "#Created: ";
    public static final String PRIVATE_KEY_PEM_SUFFIX = "_private_key.pem";
    public static final String CLIENT_CERT_PEM_SUFFIX = "_client_cert.pem";
    public static final String CA_CERT_PEM_SUFFIX = "_ca_cert.pem";
    private static final String INDENT = "        ";
    private static final String NEWLINE = "\n";
    private static final char NEWLINE_CHAR = '\n';
    private static final String BLOCK_START = "{";
    private static final String BLOCK_END = "}";
    public static final String BLANK = "";
    public static final String EQUALS = "=";
    public static final String ZERO = "0";
    public static final String ONE = "1";
    public static final String TWO = "2";
    public static final String THREE = "3";
    public static final String UNDERSCORE = "_";
    public static final String IEEE8021X_LICENSED_PROPERTY_NAME = "isLicensed";
    public static final String CONFIGURATION_FILE_PROPERTY_NAME = "configurationFile";
    public static final String PKI_CERTIFICATES_DIRECTORY_PROPERTY_NAME = "pkiCertificatesDirectory";
    public static final String PKI_CERTIFICATES_DIRECTORY_RESOLVED_PROPERTY_NAME = "pkiCertificatesResolvedDirectory";
    public static final String STATUS_FILE_PROPERTY_NAME = "statusFile";
    public static final String CURRENT_STATUS_PROPERTY_NAME = "currentStatus";
    public static final String ALL_STATUSES_PROPERTY_NAME = "allStatuses";
    public static final String STATUS_BSSID = "bssid";
    public static final String STATUS_FREQ = "freq";
    public static final String STATUS_SSID = "ssid";
    public static final String STATUS_ID = "id";
    public static final String STATUS_MODE = "mode";
    public static final String STATUS_PAIRWISE_CIPHER = "pairwise_cipher";
    public static final String STATUS_GROUP_CIPHER = "group_cipher";
    public static final String STATUS_KEY_MGMT = "key_mgmt";
    public static final String STATUS_STATE = "wpa_state";
    public static final String STATUS_ADDRESS = "address";
    public static final String STATUS_SUPPLICANT_PAE_STATE = "Supplicant PAE state";
    public static final String STATUS_SUPP_PORT_STATUS = "suppPortStatus";
    public static final String STATUS_EAP_STATE = "EAP state";
    public static final String STATUS_SELECTED_METHOD = "selectedMethod";
    public static final String VAR_RUN_WPA_SUPPLICANT = "/var/run/wpa_supplicant";
    public static final String CTRL_INTERFACE = "ctrl_interface";
    public static final String CTRL_INTERFACE_GROUP = "ctrl_interface_group";
    public static final String UPDATE_CONFIG = "update_config";
    public static final String EAPOL_VERSION = "eapol_version";
    public static final String AP_SCAN = "ap_scan";
    public static final String FAST_REAUTH = "fast_reauth";
    public static final String NETWORK = "network";
    public static final String KEY_MGMT = "key_mgmt";
    public static final String IEEE8021X = "IEEE8021X";
    public static final String EAPOL_FLAGS = "eapol_flags";
    public static final String EAP = "eap";
    public static final String IDENTITY = "identity";
    public static final String ANONYMOUS_IDENTITY = "anonymous_identity";
    public static final String PASSPHRASE = "password";
    public static final String CA_CERT = "ca_cert";
    public static final String CLIENT_CERT = "client_cert";
    public static final String PRIVATE_KEY = "private_key";
    public static final String PRIVATE_KEY_PASSPHRASE = "private_key_passwd";
    public static final String PHASE1 = "phase1";
    public static final String PHASE2 = "phase2";
    public static final String CA_CERT2 = "ca_cert2";
    public static final String CLIENT_CERT2 = "client_cert2";
    public static final String PRIVATE_KEY2 = "private_key2";
    public static final String PRIVATE_KEY2_PASSPHRASE = "private_key2_passwd";
    public static final String AUTHEAP = "autheap";
    public static final String AUTH = "auth";
    public static final String INCLUDE_TLS_LENGTH = "include_tls_length";
    public static final String PEAPVER = "peapver";
    public static final String TLS = "TLS";
    public static final String MSCHAPV2 = "MSCHAPV2";
    public static final String PEAPVER_FRIENDLY = "Version";
    public static final String EAPMSCHAPV2_FRIENDLY = "EAP-MSCHAPv2";
    public static final String MSCHAPV2_FRIENDLY = "MSCHAPv2";
    public static final String PEAP_FRIENDLY = "Protected EAP (PEAP)";
    public static final String TTLS_FRIENDLY = "Tunneled TLS";
    public static final String TLS_FRIENDLY = "TLS";
    private static final int IEEE8021X_FILE_BUFFER_SIZE = 2048;

    private IEEE8021XUtil() {
    }

    public static synchronized void loadFromSession(BIEEE8021XHostSettings hostSettings, BDaemonSession daemonSession) throws Exception {
        if (!IEEE8021XUtil.supportsIEEE8021x(daemonSession)) {
            throw new UnsupportedOperationException("IEEE 802.1X is unsupported on platform");
        }
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading IEEE 802.1X settings from daemon session...");
            start = Clock.ticks();
        }
        InputStream stream = daemonSession.getInputStream((DaemonMessage)new GetIEEE8021XMessage());
        XElem servletElement = XParser.make((InputStream)stream).parse();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Using IEEE 802.1X servlet XML:");
            servletElement.dump();
        }
        boolean hostReadonly = servletElement.getb("readonly", false);
        hostSettings.setIeee8021XReadonly(hostReadonly);
        XElem adaptersElement = Optional.ofNullable(servletElement.elem("adapters")).orElse(new XElem("adapters"));
        for (XElem adapterElement : adaptersElement.elems()) {
            String statusString;
            String adapterOsName = adapterElement.get("name");
            boolean adapterReadonly = adapterElement.getb("readonly", true);
            boolean adapterEnabled = adapterElement.getb("enabled", false);
            boolean isLicensed = adapterElement.getb("licensed", false);
            String configurationFile = adapterElement.get("configuration_file");
            String statusFile = adapterElement.get("status_file");
            String pkiCertificatesDirectory = adapterElement.get("pki_certificates_directory");
            Properties wpaSupplicantProperties = null;
            String wpaSupplicantConfigurationContent = null;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Loading IEEE8021X settings for adapter '" + adapterOsName + "'");
            }
            String propName = SlotPath.escape((String)adapterOsName);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Adapter uses slot name '" + propName + "'");
            }
            boolean createdNewSettings = false;
            BIEEE8021XAdapterSettings adapterSettings = (BIEEE8021XAdapterSettings)hostSettings.getAdapterSettings().get(propName);
            if (adapterSettings == null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Adapter '" + propName + "' not found in settings, creating new slot");
                }
                adapterSettings = new BIEEE8021XAdapterSettings();
                createdNewSettings = true;
            }
            IEEE8021XUtil.addOrSetDynamicSlot(adapterOsName, adapterSettings, STATUS_FILE_PROPERTY_NAME, (BValue)BString.make((String)statusFile), 3);
            IEEE8021XUtil.addOrSetDynamicSlot(adapterOsName, adapterSettings, PKI_CERTIFICATES_DIRECTORY_PROPERTY_NAME, (BValue)BString.make((String)pkiCertificatesDirectory), 3);
            IEEE8021XUtil.addOrSetDynamicSlot(adapterOsName, adapterSettings, IEEE8021X_LICENSED_PROPERTY_NAME, (BValue)BBoolean.make((boolean)isLicensed), 3);
            IEEE8021XUtil.addOrSetDynamicSlot(adapterOsName, adapterSettings, CONFIGURATION_FILE_PROPERTY_NAME, (BValue)BString.make((String)configurationFile), 3);
            adapterSettings.setIeee8021XEnabled(adapterEnabled);
            if (adapterEnabled) {
                FilePath wpaSupplicantConfigurationFilePath = new FilePath(configurationFile);
                FilePath statusFilePath = new FilePath(statusFile);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Retrieving IEEE8021X configuration for adapter '" + adapterOsName + "' at '" + wpaSupplicantConfigurationFilePath + "'");
                }
                try (PBEEncodingKey encodingKey = PBEEncodingKey.random();
                     BCachedDaemonFileSpace space = BCachedDaemonFileSpace.make((BDaemonSession)daemonSession, (PBEEncodingKey)encodingKey);){
                    StringBuilder wpaSupplicantConfigurationContentBuilder = new StringBuilder();
                    try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new PBEDecryptingInputStream(space.findFile(wpaSupplicantConfigurationFilePath).getInputStream(), encodingKey), StandardCharsets.UTF_8);){
                        int read;
                        char[] buf = new char[2048];
                        while ((read = inputStreamReader.read(buf)) > 0) {
                            wpaSupplicantConfigurationContentBuilder.append(buf, 0, read);
                        }
                    }
                    wpaSupplicantConfigurationContent = wpaSupplicantConfigurationContentBuilder.toString();
                    wpaSupplicantProperties = new Properties();
                    try {
                        var32_37 = null;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new PBEDecryptingInputStream(space.findFile(statusFilePath).getInputStream(), encodingKey), StandardCharsets.UTF_8));){
                            IEEE8021XUtil.lineReaderToProperties(wpaSupplicantProperties, reader);
                        }
                        catch (Throwable throwable) {
                            var32_37 = throwable;
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("Exception " + exception + " occurred while reading status file, assume file does not exist");
                        }
                    }
                }
            }
            IEEE8021XUtil.stringToIEEE8021XSettings(wpaSupplicantConfigurationContent, adapterSettings);
            if (!isLicensed) {
                statusString = UNLICENSED_LEX_KEY;
            } else if (!adapterEnabled) {
                statusString = DISABLED_LEX_KEY;
            } else {
                if (LOG.isLoggable(Level.FINEST)) {
                    IEEE8021XUtil.dumpWpaSupplicantStatus(wpaSupplicantProperties, statusFile);
                }
                statusString = wpaSupplicantProperties.getProperty(STATUS_SUPPLICANT_PAE_STATE, UNKNOWN_LEX_KEY).toLowerCase(Locale.US);
            }
            IEEE8021XUtil.addOrSetDynamicSlot(adapterOsName, adapterSettings, CURRENT_STATUS_PROPERTY_NAME, (BValue)BString.make((String)statusString), 3);
            StringBuilder allStatuses = new StringBuilder();
            if (adapterEnabled) {
                for (String key : wpaSupplicantProperties.stringPropertyNames()) {
                    allStatuses.append(key).append(EQUALS).append(wpaSupplicantProperties.getProperty(key)).append(NEWLINE);
                }
            }
            IEEE8021XUtil.addOrSetDynamicSlot(adapterOsName, adapterSettings, ALL_STATUSES_PROPERTY_NAME, (BValue)BString.make((String)allStatuses.toString()), 3);
            adapterReadonly |= hostReadonly;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Setting IEEE8021X settings as readonly = " + adapterReadonly);
            }
            adapterSettings.setIeee8021XReadonly(adapterReadonly);
            if (createdNewSettings) {
                int propertyFlags = adapterReadonly ? 3 : 2;
                hostSettings.getAdapterSettings().add(propName, (BValue)adapterSettings, propertyFlags);
            }
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.finest("Load IEEE8021X settings for adapter '" + adapterOsName + "' complete");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Load of IEEE 802.1X settings from daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
    }

    public static synchronized void saveToSession(BIEEE8021XHostSettings hostSettings, BDaemonSession daemonSession, ICoreCryptoManager coreCryptoManager) throws Exception {
        if (daemonSession == null) {
            return;
        }
        if (hostSettings == null) {
            return;
        }
        if (!IEEE8021XUtil.supportsIEEE8021x(daemonSession)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Remote session '" + daemonSession.getHost() + "' does not support the IEEE 802.1X servlet, skipping save");
            }
            return;
        }
        if (daemonSession.getHostProperties().getIsNpsdk()) {
            InputStream stream = daemonSession.getInputStream((DaemonMessage)new GetIEEE8021XMessage());
            XElem servletElement = XParser.make((InputStream)stream).parse();
            XElem adaptersElement = Optional.ofNullable(servletElement.elem("adapters")).orElse(new XElem("adapters"));
            for (XElem adapterElement : adaptersElement.elems("adapter")) {
                if (adapterElement.getb("licensed", false)) continue;
                LOG.log(Level.SEVERE, "IEEE 802.1X configuration is not licensed on remote device, cannot save");
                throw new BajaException(LEXICON.get("IEEE8021XAdapterSettingsEditor.export.licenseFailure.msg", null));
            }
        }
        if (hostSettings.getIeee8021XReadonly()) {
            LOG.finest("Skipping readonly host during 802.1X save");
            return;
        }
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Saving IEEE 802.1X settings to daemon session...");
            start = Clock.ticks();
        }
        SlotCursor c = hostSettings.getAdapterSettings().loadSlots().getProperties();
        while (c.next()) {
            BIEEE8021XAdapterSettings adapterSettings = (BIEEE8021XAdapterSettings)c.get();
            String adapterOsName = SlotPath.unescape((String)c.property().getName());
            if (adapterSettings.getIeee8021XReadonly()) {
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.finest("Skipping readonly adapter '" + adapterOsName + "' during 802.1X save");
                continue;
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Saving 802.1X configuration for adapter '" + adapterOsName + "'");
            }
            if (IEEE8021XUtil.settingsUseCertificates(adapterSettings)) {
                IEEE8021XUtil.checkResolvedPKIDirectoryProperty(adapterSettings, daemonSession);
            }
            try (PBEEncodingKey encodingKey = PBEEncodingKey.random();){
                FileTransferMessage fileTransferMessage = DaemonClientEncodingInfo.makeMessage((BDaemonSession)daemonSession, (PBEEncodingKey)encodingKey);
                String filePathString = ((BString)adapterSettings.get(CONFIGURATION_FILE_PROPERTY_NAME)).getString();
                FilePath wpaSupplicantPath = new FilePath(filePathString);
                if (adapterSettings.getIeee8021XEnabled()) {
                    String settingsAsString;
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Saving adapter '" + adapterOsName + "' 802.1X configuration file to path '" + wpaSupplicantPath + "'");
                    }
                    if (IEEE8021XUtil.settingsUseCertificates(adapterSettings)) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("802.1X configuration for adapter '" + adapterOsName + "' uses certificates, preparing files for export");
                        }
                        IEEE8021XUtil.exportCertificatesToSession(fileTransferMessage, adapterSettings, daemonSession, coreCryptoManager);
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("Certificate export preparation for adapter '" + adapterOsName + "' complete");
                        }
                    } else if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("802.1X configuration for adapter '" + adapterOsName + "' does not use certificates");
                    }
                    if ((settingsAsString = IEEE8021XUtil.ieee8021XSettingsToString(adapterSettings, adapterOsName, true)) != null) {
                        try (ByteArrayInputStream supplicantInputStream = new ByteArrayInputStream(settingsAsString.getBytes(StandardCharsets.UTF_8));){
                            fileTransferMessage.addPBEEncryptedElement((InputStream)supplicantInputStream, wpaSupplicantPath);
                        }
                    }
                } else {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Deleting adapter '" + adapterOsName + "' 802.1X configuration file at path '" + wpaSupplicantPath + "'");
                    }
                    fileTransferMessage.addDelete(wpaSupplicantPath);
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Starting file transfer for adapter '" + adapterOsName + "'...");
                }
                if (!DaemonFileUtil.transfer((BDaemonSession)daemonSession, (FileTransferMessage)fileTransferMessage, null)) {
                    LOG.log(Level.SEVERE, "Failed to transfer configuration file to remote platform, cannot continue");
                    throw new BajaException(LEXICON.get("IEEE8021XAdapterSettingsEditor.export.confTransferFailure.msg", null));
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("File transfer for adapter '" + adapterOsName + "' complete");
                }
            }
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.finest("Save operation for adapter '" + adapterOsName + "' 802.1X configuration complete");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Save of IEEE 802.1X settings to daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
    }

    public static synchronized Properties updateAdapterStatusFromSession(BIEEE8021XAdapterSettings settings, BDaemonSession daemonSession) {
        String statusFilePathProperty;
        Properties currentWpaStateProperties;
        block42: {
            currentWpaStateProperties = new Properties();
            if (settings.getIeee8021XEnabled()) {
                return currentWpaStateProperties;
            }
            statusFilePathProperty = ((BString)settings.get(STATUS_FILE_PROPERTY_NAME)).getString();
            if (statusFilePathProperty == null) {
                return currentWpaStateProperties;
            }
            FilePath statusFilePath = new FilePath(statusFilePathProperty);
            try (PBEEncodingKey encodingKey = PBEEncodingKey.random();
                 BCachedDaemonFileSpace space = BCachedDaemonFileSpace.make((BDaemonSession)daemonSession, (PBEEncodingKey)encodingKey);
                 BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new PBEDecryptingInputStream(space.findFile(statusFilePath).getInputStream(), encodingKey), StandardCharsets.UTF_8));){
                IEEE8021XUtil.lineReaderToProperties(currentWpaStateProperties, reader);
            }
            catch (IOException ioException) {
                if (currentWpaStateProperties.isEmpty()) {
                    return currentWpaStateProperties;
                }
                LOG.log(Level.WARNING, "Exception occurred while loading IEEE 802.1X status file (" + ioException.getLocalizedMessage() + ")");
                if (!LOG.isLoggable(Level.FINEST)) break block42;
                LOG.log(Level.FINEST, "Exception stack trace", ioException);
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            IEEE8021XUtil.dumpWpaSupplicantStatus(currentWpaStateProperties, statusFilePathProperty);
        }
        return currentWpaStateProperties;
    }

    public static boolean supportsIEEE8021x(BDaemonSession daemonSession) {
        return daemonSession.getHostProperties().isNiagara4() && daemonSession.getHostProperties().supportsServlet(LICENSE_FEATURE);
    }

    public static String ieee8021XSettingsToString(BIEEE8021XAdapterSettings adapterSettings, String adapterOsName, boolean preamble) {
        if (!adapterSettings.getIeee8021XEnabled()) {
            return null;
        }
        StringBuilder settingsToReturn = new StringBuilder();
        if (preamble) {
            settingsToReturn.append(DESCRIPTION).append(NEWLINE);
            settingsToReturn.append(MODIFY_WARNING).append(NEWLINE);
            settingsToReturn.append(CREATED).append(BAbsTime.now()).append(NEWLINE);
            settingsToReturn.append(NEWLINE);
        }
        settingsToReturn.append(CTRL_INTERFACE).append(EQUALS).append(VAR_RUN_WPA_SUPPLICANT).append(UNDERSCORE).append(adapterOsName).append(NEWLINE);
        settingsToReturn.append(CTRL_INTERFACE_GROUP).append(EQUALS).append(ZERO).append(NEWLINE);
        settingsToReturn.append(UPDATE_CONFIG).append(EQUALS).append(ZERO).append(NEWLINE);
        settingsToReturn.append(EAPOL_VERSION).append(EQUALS).append(TWO).append(NEWLINE);
        settingsToReturn.append(AP_SCAN).append(EQUALS).append(ZERO).append(NEWLINE);
        settingsToReturn.append(FAST_REAUTH).append(EQUALS).append(adapterSettings.getUseFastReauthentication() ? ONE : ZERO).append(NEWLINE);
        settingsToReturn.append(NEWLINE);
        settingsToReturn.append(NETWORK).append(EQUALS).append(BLOCK_START).append(NEWLINE);
        settingsToReturn.append(INDENT).append("key_mgmt").append(EQUALS).append(IEEE8021X).append(NEWLINE);
        settingsToReturn.append(INDENT).append(EAPOL_FLAGS).append(EQUALS).append(ZERO).append(NEWLINE);
        settingsToReturn.append(INDENT).append(EAP).append(EQUALS).append(adapterSettings.getEapMethod().getTag().toUpperCase(Locale.US)).append(NEWLINE);
        String value = adapterSettings.getIdentity();
        if (value != null && !value.isEmpty()) {
            settingsToReturn.append(INDENT).append(IDENTITY).append(EQUALS).append(IEEE8021XUtil.quote(value)).append(NEWLINE);
        }
        if ((value = adapterSettings.getAnonymousIdentity()) != null && !value.isEmpty()) {
            settingsToReturn.append(INDENT).append(ANONYMOUS_IDENTITY).append(EQUALS).append(IEEE8021XUtil.quote(value)).append(NEWLINE);
        }
        if ((value = IEEE8021XUtil.passphraseToString(adapterSettings.getPassphrase())) != null && !value.isEmpty()) {
            settingsToReturn.append(INDENT).append(PASSPHRASE).append(EQUALS).append(IEEE8021XUtil.quote(value)).append(NEWLINE);
        }
        if ((value = adapterSettings.getTunnelPhase1()) != null && !value.isEmpty()) {
            settingsToReturn.append(INDENT).append(PHASE1).append(EQUALS).append(IEEE8021XUtil.quote(value)).append(NEWLINE);
        }
        if ((value = adapterSettings.getTunnelPhase2()) != null && !value.isEmpty()) {
            settingsToReturn.append(INDENT).append(PHASE2).append(EQUALS).append(IEEE8021XUtil.quote(value)).append(NEWLINE);
        }
        if (IEEE8021XUtil.settingsUseCertificates(adapterSettings)) {
            String exportValue;
            StringBuilder destCaCertsDirPathBuilder = new StringBuilder();
            StringBuilder destClientCertsDirPathBuilder = new StringBuilder();
            StringBuilder destPrivateKeysDirPathBuilder = new StringBuilder();
            IEEE8021XUtil.buildAdapterExportPaths(adapterSettings, destCaCertsDirPathBuilder, destClientCertsDirPathBuilder, destPrivateKeysDirPathBuilder, LOG);
            value = adapterSettings.getCaCertificate();
            if (value != null && !value.isEmpty()) {
                exportValue = IEEE8021XUtil.aliasToFilePath(destCaCertsDirPathBuilder.toString(), value, CA_CERT_PEM_SUFFIX);
                settingsToReturn.append(INDENT).append(CA_CERT).append(EQUALS).append(IEEE8021XUtil.quote(exportValue)).append(NEWLINE);
            }
            if ((value = adapterSettings.getClientCertificate()) != null && !value.isEmpty()) {
                exportValue = IEEE8021XUtil.aliasToFilePath(destClientCertsDirPathBuilder.toString(), value, CLIENT_CERT_PEM_SUFFIX);
                settingsToReturn.append(INDENT).append(CLIENT_CERT).append(EQUALS).append(IEEE8021XUtil.quote(exportValue)).append(NEWLINE);
                exportValue = IEEE8021XUtil.aliasToFilePath(destPrivateKeysDirPathBuilder.toString(), value, PRIVATE_KEY_PEM_SUFFIX);
                settingsToReturn.append(INDENT).append(PRIVATE_KEY).append(EQUALS).append(IEEE8021XUtil.quote(exportValue)).append(NEWLINE);
            }
            if ((value = IEEE8021XUtil.passphraseToString(adapterSettings.getPrivateKeyPassphrase())) != null && !value.isEmpty()) {
                settingsToReturn.append(INDENT).append(PRIVATE_KEY_PASSPHRASE).append(EQUALS).append(IEEE8021XUtil.quote(value)).append(NEWLINE);
            }
            if ((value = adapterSettings.getCaCertificate2()) != null && !value.isEmpty()) {
                exportValue = IEEE8021XUtil.aliasToFilePath(destCaCertsDirPathBuilder.toString(), value, CA_CERT_PEM_SUFFIX);
                settingsToReturn.append(INDENT).append(CA_CERT2).append(EQUALS).append(IEEE8021XUtil.quote(exportValue)).append(NEWLINE);
            }
            if ((value = adapterSettings.getClientCertificate2()) != null && !value.isEmpty()) {
                exportValue = IEEE8021XUtil.aliasToFilePath(destClientCertsDirPathBuilder.toString(), value, CLIENT_CERT_PEM_SUFFIX);
                settingsToReturn.append(INDENT).append(CLIENT_CERT2).append(EQUALS).append(IEEE8021XUtil.quote(exportValue)).append(NEWLINE);
                exportValue = IEEE8021XUtil.aliasToFilePath(destPrivateKeysDirPathBuilder.toString(), value, PRIVATE_KEY_PEM_SUFFIX);
                settingsToReturn.append(INDENT).append(PRIVATE_KEY2).append(EQUALS).append(IEEE8021XUtil.quote(exportValue)).append(NEWLINE);
            }
            if ((value = IEEE8021XUtil.passphraseToString(adapterSettings.getPrivateKey2Passphrase())) != null && !value.isEmpty()) {
                settingsToReturn.append(INDENT).append(PRIVATE_KEY2_PASSPHRASE).append(EQUALS).append(IEEE8021XUtil.quote(value)).append(NEWLINE);
            }
        }
        settingsToReturn.append(BLOCK_END).append(NEWLINE);
        if (LOG.isLoggable(Level.FINEST)) {
            String[] settingsToLog = TextUtil.split((String)settingsToReturn.toString(), (char)'\n');
            StringBuilder obscuredSettingsBuilder = new StringBuilder();
            for (String settingToLog : settingsToLog) {
                if (settingToLog.contains("private_key_passwd=\"")) {
                    obscuredSettingsBuilder.append("        private_key_passwd=\"[obscured]\"\n");
                    continue;
                }
                if (settingToLog.contains("private_key2_passwd=\"")) {
                    obscuredSettingsBuilder.append("        private_key2_passwd=\"[obscured]\"\n");
                    continue;
                }
                if (settingToLog.contains("password=\"")) {
                    obscuredSettingsBuilder.append("        password=\"[obscured]\"\n");
                    continue;
                }
                obscuredSettingsBuilder.append(settingToLog).append(NEWLINE);
            }
            LOG.finest("ieee8021XSettingsToString created 8021X configuration string:\n" + obscuredSettingsBuilder);
        }
        return settingsToReturn.toString();
    }

    public static void stringToIEEE8021XSettings(String settingsAsString, BIEEE8021XAdapterSettings settingsToReturn) {
        if (settingsAsString == null) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            String[] settingsToLog = TextUtil.split((String)settingsAsString, (char)'\n');
            StringBuilder obscuredSettingsBuilder = new StringBuilder();
            for (String settingToLog : settingsToLog) {
                if (settingToLog.contains("private_key_passwd=\"")) {
                    obscuredSettingsBuilder.append("        private_key_passwd=\"[obscured]\"\n");
                    continue;
                }
                if (settingToLog.contains("private_key2_passwd=\"")) {
                    obscuredSettingsBuilder.append("        private_key2_passwd=\"[obscured]\"\n");
                    continue;
                }
                if (settingToLog.contains("password=\"")) {
                    obscuredSettingsBuilder.append("        password=\"[obscured]\"\n");
                    continue;
                }
                obscuredSettingsBuilder.append(settingToLog).append(NEWLINE);
            }
            LOG.finest("stringToIEEE8021XSettings creating 8021X settings from string:\n" + obscuredSettingsBuilder);
        }
        String[] lines = TextUtil.split((String)settingsAsString, (char)'\n');
        Properties networkProperties = new Properties();
        for (String line : lines) {
            String current = line.trim();
            if (current.startsWith(NETWORK) || !current.contains(EQUALS) || current.endsWith(EQUALS)) continue;
            int equalsIndex = current.indexOf(EQUALS);
            if (LOG.isLoggable(Level.FINEST)) {
                String value = PRIVATE_KEY_PASSPHRASE.equals(current.substring(0, equalsIndex)) || PRIVATE_KEY2_PASSPHRASE.equals(current.substring(0, equalsIndex)) || PASSPHRASE.equals(current.substring(0, equalsIndex)) ? "\"[obscured]\"" : current.substring(equalsIndex + 1);
                LOG.finest("stringToIEEE8021XSettings Adding property " + current.substring(0, equalsIndex) + " -> " + value);
            }
            networkProperties.setProperty(current.substring(0, equalsIndex), current.substring(equalsIndex + 1));
        }
        String value = networkProperties.getProperty(EAP);
        settingsToReturn.setEapMethod(value != null ? BIEEE8021XEAPMethod.make(value.toLowerCase(Locale.US)) : BIEEE8021XEAPMethod.tls);
        value = networkProperties.getProperty(FAST_REAUTH);
        settingsToReturn.setUseFastReauthentication(value != null ? !value.equals(ZERO) : true);
        value = networkProperties.getProperty(IDENTITY);
        settingsToReturn.setIdentity(value != null ? IEEE8021XUtil.unquote(value) : BLANK);
        value = networkProperties.getProperty(ANONYMOUS_IDENTITY);
        settingsToReturn.setAnonymousIdentity(value != null ? IEEE8021XUtil.unquote(value) : BLANK);
        value = networkProperties.getProperty(PASSPHRASE);
        settingsToReturn.setPassphrase(IEEE8021XUtil.stringToPassphrase(IEEE8021XUtil.unquote(value)));
        value = networkProperties.getProperty(CA_CERT);
        settingsToReturn.setCaCertificate(value != null ? IEEE8021XUtil.filePathToAlias(IEEE8021XUtil.unquote(value), CA_CERT_PEM_SUFFIX) : BLANK);
        value = networkProperties.getProperty(CLIENT_CERT);
        settingsToReturn.setClientCertificate(value != null ? IEEE8021XUtil.filePathToAlias(IEEE8021XUtil.unquote(value), CLIENT_CERT_PEM_SUFFIX) : BLANK);
        value = networkProperties.getProperty(PRIVATE_KEY_PASSPHRASE);
        settingsToReturn.setPrivateKeyPassphrase(IEEE8021XUtil.stringToPassphrase(IEEE8021XUtil.unquote(value)));
        value = networkProperties.getProperty(PHASE1);
        settingsToReturn.setTunnelPhase1(value != null ? IEEE8021XUtil.unquote(value) : BLANK);
        value = networkProperties.getProperty(PHASE2);
        settingsToReturn.setTunnelPhase2(value != null ? IEEE8021XUtil.unquote(value) : BLANK);
        value = networkProperties.getProperty(CA_CERT2);
        settingsToReturn.setCaCertificate2(value != null ? IEEE8021XUtil.filePathToAlias(IEEE8021XUtil.unquote(value), CA_CERT_PEM_SUFFIX) : BLANK);
        value = networkProperties.getProperty(CLIENT_CERT2);
        settingsToReturn.setClientCertificate2(value != null ? IEEE8021XUtil.filePathToAlias(IEEE8021XUtil.unquote(value), CLIENT_CERT_PEM_SUFFIX) : BLANK);
        value = networkProperties.getProperty(PRIVATE_KEY2_PASSPHRASE);
        settingsToReturn.setPrivateKey2Passphrase(IEEE8021XUtil.stringToPassphrase(IEEE8021XUtil.unquote(value)));
    }

    public static void exportCertificatesToSession(FileTransferMessage fileTransferMessage, BIEEE8021XAdapterSettings adapterSettings, BDaemonSession daemonSession, ICoreCryptoManager cryptoManager) throws Exception {
        Throwable throwable;
        if (!IEEE8021XUtil.settingsUseCertificates(adapterSettings)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Skipping certificate export, adapter does not use any certificates");
            }
            return;
        }
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Preparing IEEE 802.1X certificates for export to daemon session...");
            start = Clock.ticks();
        }
        ArrayList<CertInfo> certsToExport = new ArrayList<CertInfo>();
        String passphrase = null;
        StringBuilder destCaCertsDirPathBuilder = new StringBuilder();
        StringBuilder destClientCertsDirPathBuilder = new StringBuilder();
        StringBuilder destPrivateKeysDirPathBuilder = new StringBuilder();
        IEEE8021XUtil.buildAdapterExportPaths(adapterSettings, destCaCertsDirPathBuilder, destClientCertsDirPathBuilder, destPrivateKeysDirPathBuilder, LOG);
        String alias = adapterSettings.getCaCertificate();
        if (alias != null && !alias.isEmpty()) {
            certsToExport.add(new CertInfo(null, null, destCaCertsDirPathBuilder.toString(), CA_CERT_PEM_SUFFIX, alias, false, null));
        }
        if ((alias = adapterSettings.getClientCertificate()) != null && !alias.isEmpty()) {
            passphrase = !IEEE8021XUtil.passphraseToString(adapterSettings.getPrivateKeyPassphrase()).isEmpty() ? adapterSettings.getPrivateKeyPassphrase().getValue() : null;
            certsToExport.add(new CertInfo(destPrivateKeysDirPathBuilder.toString(), PRIVATE_KEY_PEM_SUFFIX, destClientCertsDirPathBuilder.toString(), CLIENT_CERT_PEM_SUFFIX, alias, true, passphrase));
        }
        if ((alias = adapterSettings.getCaCertificate2()) != null && !alias.isEmpty()) {
            certsToExport.add(new CertInfo(null, null, destCaCertsDirPathBuilder.toString(), CA_CERT_PEM_SUFFIX, alias, false, null));
        }
        if ((alias = adapterSettings.getClientCertificate2()) != null && !alias.isEmpty()) {
            passphrase = !IEEE8021XUtil.passphraseToString(adapterSettings.getPrivateKey2Passphrase()).isEmpty() ? adapterSettings.getPrivateKey2Passphrase().getValue() : null;
            certsToExport.add(new CertInfo(destPrivateKeysDirPathBuilder.toString(), PRIVATE_KEY_PEM_SUFFIX, destClientCertsDirPathBuilder.toString(), CLIENT_CERT_PEM_SUFFIX, alias, true, passphrase));
        }
        ICoreKeyStore providedKeyStore = null;
        ICoreKeyStore providedTrustStore = null;
        for (CertInfo current : certsToExport) {
            OutputStream keyOutput;
            X509Certificate[] certificateChain;
            ICoreKeyStore targetStore;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Preparing export of CertInfo entry '" + current.alias + "'...");
                if (current.absoluteCertDirDestination != null) {
                    LOG.finest("Entry uses absolute certificate directory destination '" + current.absoluteCertDirDestination + "'");
                }
                if (current.absoluteKeyDirDestination != null) {
                    LOG.finest("Entry uses absolute key directory destination '" + current.absoluteKeyDirDestination + "'");
                }
            }
            try {
                if (current.isKeyFile) {
                    if (providedKeyStore == null) {
                        providedKeyStore = cryptoManager.getKeyStore();
                    }
                    targetStore = providedKeyStore;
                } else {
                    if (providedTrustStore == null) {
                        providedTrustStore = cryptoManager.getUserTrustStore();
                    }
                    targetStore = providedTrustStore;
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to retrieve remote certificate stores, can not export certificates", e);
                throw new BajaException(LEXICON.getText("IEEE8021XAdapterSettingsEditor.export.generalError.msg", null), (Throwable)e);
            }
            try {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Retrieving certificate chain for alias '" + current.alias + "'...");
                }
                if ((certificateChain = targetStore.getCertificateChain(current.alias)) == null || certificateChain.length == 0) {
                    X509Certificate certificate;
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Certificate chain for alias '" + current.alias + "' unavailable, retrieving single certificate...");
                    }
                    if ((certificate = targetStore.getCertificate(current.alias)) != null) {
                        certificateChain = new X509Certificate[]{certificate};
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to retrieve the remote certificate for alias '" + current.alias + "', can not export certificate", e);
                throw new BajaException(LEXICON.getText("IEEE8021XAdapterSettingsEditor.export.certificateError.msg", null), (Throwable)e);
            }
            PrivateKey certificatePrivateKey = null;
            if (current.isKeyFile) {
                block98: {
                    try {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("Retrieving private key for alias '" + current.alias + "'...");
                        }
                        certificatePrivateKey = (PrivateKey)targetStore.getKey(current.alias, null);
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINEST)) break block98;
                        LOG.finest("Private key for alias '" + current.alias + "' unavailable (" + e.getMessage() + "), retrying with private key passphrase");
                    }
                }
                if (certificatePrivateKey == null) {
                    if (passphrase == null) {
                        LOG.log(Level.SEVERE, "Failed to retrieve the remote key for alias '" + current.alias + "' (missing passphrase), can not export key");
                        throw new BajaException(LEXICON.getText("IEEE8021XAdapterSettingsEditor.export.missingPassphrase.msg", null));
                    }
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Retrieving private key for alias '" + current.alias + "' with passphrase...");
                    }
                    try {
                        certificatePrivateKey = (PrivateKey)targetStore.getKey(current.alias, current.passphrase.toCharArray());
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Failed to retrieve the remote key for alias '" + current.alias + "' (incorrect passphrase), can not export key", e);
                        throw new BajaException(LEXICON.getText("IEEE8021XAdapterSettingsEditor.export.invalidPassphrase.msg", null), (Throwable)e);
                    }
                }
            }
            ByteBuffer certBuffer = new ByteBuffer();
            OutputStream certOutput = certBuffer.getOutputStream();
            try {
                throwable = null;
                try (JcaPEMWriter pem = new JcaPEMWriter((Writer)new OutputStreamWriter(certOutput, StandardCharsets.UTF_8));){
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Converting '" + current.alias + "' certificate to PEM encoding...");
                    }
                    if (certificateChain != null) {
                        for (X509Certificate certificateLink : certificateChain) {
                            pem.writeObject((Object)certificateLink);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to encode the certificate file for alias '" + current.alias + "', can not export certificate", e);
                throw new BajaException(LEXICON.getText("IEEE8021XAdapterSettingsEditor.export.pemFailure.msg", null), (Throwable)e);
            }
            ByteBuffer keyBuffer = new ByteBuffer();
            OutputStream outputStream = keyOutput = certificatePrivateKey == null ? null : keyBuffer.getOutputStream();
            if (certificatePrivateKey != null) {
                try (JcaPEMWriter pem = new JcaPEMWriter((Writer)new OutputStreamWriter(keyOutput, StandardCharsets.UTF_8));){
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Converting '" + current.alias + "' key to PEM encoding...");
                    }
                    pem.writeObject((Object)certificatePrivateKey);
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Failed to encode the key file for alias '" + current.alias + "', can not export key", e);
                    throw new BajaException(LEXICON.getText("IEEE8021XAdapterSettingsEditor.export.pemFailure.msg", null), (Throwable)e);
                }
            }
            if (keyBuffer.getLength() > 0) {
                current.keyBuffer = keyBuffer;
            }
            if (certBuffer.getLength() > 0) {
                current.certBuffer = certBuffer;
            }
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.finest("Export preparation of CertInfo entry '" + current.alias + "' complete");
        }
        BString pkiCertificatesRelativePathProperty = (BString)adapterSettings.get(PKI_CERTIFICATES_DIRECTORY_PROPERTY_NAME);
        BString pkiCertificatesAbsolutePathProperty = (BString)adapterSettings.get(PKI_CERTIFICATES_DIRECTORY_RESOLVED_PROPERTY_NAME);
        if (pkiCertificatesRelativePathProperty == null || pkiCertificatesAbsolutePathProperty == null) {
            LOG.log(Level.SEVERE, "Necessary PKI certificate file paths are missing from adapter properties, can not export certificate");
            throw new BajaException(LEXICON.getText("IEEE8021XAdapterSettingsEditor.export.translationFailureNoProperties.msg", null));
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Using relative file path '" + pkiCertificatesRelativePathProperty + "' as alternate for '" + pkiCertificatesAbsolutePathProperty + "' during transfer");
        }
        for (CertInfo current : certsToExport) {
            FileHeaderInfo info;
            if (current.certBuffer != null) {
                String certDestinationFilePathString = IEEE8021XUtil.aliasToFilePath(current.absoluteCertDirDestination, current.alias, current.certSuffix);
                FilePath certDestinationFilePath = new FilePath(TextUtil.replace((String)certDestinationFilePathString, (String)pkiCertificatesAbsolutePathProperty.getString(), (String)pkiCertificatesRelativePathProperty.getString()));
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Entry uses certificate destination file transfer path '" + certDestinationFilePath + "'");
                }
                if ((info = DaemonFileUtil.getFileHeaderInfo((BDaemonSession)daemonSession, (FileHeaderMessage)new FileHeaderMessage(certDestinationFilePath.getParent(), (BDaemonFileSpace)daemonSession.getFileSpace()))) == null) {
                    fileTransferMessage.addMkDir(certDestinationFilePath.getParent());
                }
                throwable = null;
                try (ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(current.certBuffer.getBytes());){
                    fileTransferMessage.addPBEEncryptedElement((InputStream)certificateInputStream, certDestinationFilePath);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            if (current.keyBuffer == null) continue;
            String keyDestinationFilePathString = IEEE8021XUtil.aliasToFilePath(current.absoluteKeyDirDestination, current.alias, current.keySuffix);
            FilePath keyDestinationFilePath = new FilePath(TextUtil.replace((String)keyDestinationFilePathString, (String)pkiCertificatesAbsolutePathProperty.getString(), (String)pkiCertificatesRelativePathProperty.getString()));
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Entry uses key destination file transfer path '" + keyDestinationFilePath + "'");
            }
            if ((info = DaemonFileUtil.getFileHeaderInfo((BDaemonSession)daemonSession, (FileHeaderMessage)new FileHeaderMessage(keyDestinationFilePath.getParent(), (BDaemonFileSpace)daemonSession.getFileSpace()))) == null) {
                fileTransferMessage.addMkDir(keyDestinationFilePath.getParent());
            }
            ByteArrayInputStream keyInputStream = new ByteArrayInputStream(current.keyBuffer.getBytes());
            throwable = null;
            try {
                fileTransferMessage.addPBEEncryptedElement((InputStream)keyInputStream, keyDestinationFilePath);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (keyInputStream == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)keyInputStream).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                ((InputStream)keyInputStream).close();
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Export preparation of IEEE 802.1X certificates to daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
    }

    private static void checkResolvedPKIDirectoryProperty(BIEEE8021XAdapterSettings adapterSettings, BDaemonSession daemonSession) throws Exception {
        XElem configurationFileDirectory;
        String tempPkiCertificatesResolvedDirectory;
        FilePath pkiCertificatesDirectoryFilePath;
        FileHeaderInfo info;
        BString resolvedPath = (BString)adapterSettings.get(PKI_CERTIFICATES_DIRECTORY_RESOLVED_PROPERTY_NAME);
        if (resolvedPath != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Skipping absolute resolution of PKI directory, adapter settings already have resolved path '" + resolvedPath.getString() + "'");
            }
            return;
        }
        String pkiCertificatesDirectory = ((BString)adapterSettings.get(PKI_CERTIFICATES_DIRECTORY_PROPERTY_NAME)).getString();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Using remote session to resolve absolute location of PKI directory '" + pkiCertificatesDirectory + "'...");
        }
        if ((info = DaemonFileUtil.getFileHeaderInfo((BDaemonSession)daemonSession, (FileHeaderMessage)new FileHeaderMessage(pkiCertificatesDirectoryFilePath = new FilePath(pkiCertificatesDirectory), (BDaemonFileSpace)daemonSession.getFileSpace()))) == null) {
            DaemonFileUtil.transfer((BDaemonSession)daemonSession, (FileTransferMessage)FileTransferMessage.makeMkDir((FilePath)pkiCertificatesDirectoryFilePath, (BDaemonFileSpace)daemonSession.getFileSpace()), null);
        }
        if ((tempPkiCertificatesResolvedDirectory = (configurationFileDirectory = XParser.make((InputStream)daemonSession.getInputStream((DaemonMessage)new GetDirectoryMessage(pkiCertificatesDirectoryFilePath, false, false, true, (BDaemonFileSpace)daemonSession.getFileSpace()))).parse()).get("path", null)) == null) {
            LOG.log(Level.SEVERE, "Unable to convert adapter pki path directory '" + pkiCertificatesDirectory + "' to local absolute, path not defined in XML");
            throw new BajaException("Unable to convert adapter pki path directory '" + pkiCertificatesDirectory + "' to local absolute, path not defined in XML");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Absolute path of '" + pkiCertificatesDirectory + "' determined to be '" + tempPkiCertificatesResolvedDirectory + "', converting to local absolute");
        }
        if (tempPkiCertificatesResolvedDirectory.contains("\\")) {
            tempPkiCertificatesResolvedDirectory = "/" + TextUtil.replace((String)tempPkiCertificatesResolvedDirectory, (String)"\\", (String)"/");
        }
        String translatedPkiCertificatesResolvedDirectory = tempPkiCertificatesResolvedDirectory;
        try {
            if (!new FilePath(translatedPkiCertificatesResolvedDirectory).isLocalAbsolute()) {
                LOG.log(Level.SEVERE, "Unable to convert adapter pki path directory '" + pkiCertificatesDirectory + "' to local absolute, got '" + translatedPkiCertificatesResolvedDirectory + "'");
                throw new BajaException("Unable to convert adapter pki path directory '" + pkiCertificatesDirectory + "' to local absolute, got '" + translatedPkiCertificatesResolvedDirectory + "'");
            }
        }
        catch (SyntaxException se) {
            LOG.log(Level.SEVERE, "Unable to convert adapter pki path directory '" + pkiCertificatesDirectory + "' to local absolute, invalid syntax in response '" + translatedPkiCertificatesResolvedDirectory + "'", se);
            throw new BajaException("Unable to convert adapter pki path directory '" + pkiCertificatesDirectory + "' to local absolute, invalid syntax in response", (Throwable)se);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("PKI directory path '" + pkiCertificatesDirectory + "' resolved to absolute location '" + translatedPkiCertificatesResolvedDirectory + "'");
            LOG.finest("Adding dynamic file path property with values 'pkiCertificatesResolvedDirectory=" + translatedPkiCertificatesResolvedDirectory + "'");
        }
        adapterSettings.add(PKI_CERTIFICATES_DIRECTORY_RESOLVED_PROPERTY_NAME, (BValue)BString.make((String)translatedPkiCertificatesResolvedDirectory));
    }

    private static boolean settingsUseCertificates(BIEEE8021XAdapterSettings adapterSettings) {
        if (!adapterSettings.getIeee8021XEnabled()) {
            return false;
        }
        HashSet<String> aliasesToExport = new HashSet<String>();
        aliasesToExport.add(adapterSettings.getCaCertificate() == null ? BLANK : adapterSettings.getCaCertificate());
        aliasesToExport.add(adapterSettings.getClientCertificate() == null ? BLANK : adapterSettings.getClientCertificate());
        aliasesToExport.add(adapterSettings.getCaCertificate2() == null ? BLANK : adapterSettings.getCaCertificate2());
        aliasesToExport.add(adapterSettings.getClientCertificate2() == null ? BLANK : adapterSettings.getClientCertificate2());
        aliasesToExport.remove(BLANK);
        return !aliasesToExport.isEmpty();
    }

    private static void buildAdapterExportPaths(BIEEE8021XAdapterSettings adapterSettings, StringBuilder destCaCertsDirectory, StringBuilder destClientCertsDirectory, StringBuilder destPrivateKeysDirectory, Logger log) {
        try {
            FilePath pkiRootDirectory = new FilePath(((BString)adapterSettings.get(PKI_CERTIFICATES_DIRECTORY_RESOLVED_PROPERTY_NAME)).getString());
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Building certificate export paths with resolved root director '" + pkiRootDirectory.getBody() + "'");
            }
            destCaCertsDirectory.append(pkiRootDirectory.merge(CA_CERTS_PATH).getBody());
            destClientCertsDirectory.append(pkiRootDirectory.merge(CLIENT_CERTS_PATH).getBody());
            destPrivateKeysDirectory.append(pkiRootDirectory.merge(PRIVATE_KEYS_PATH).getBody());
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Created CA Certificate export path '" + destCaCertsDirectory + "'");
                log.finest("Created Client Certificate export path '" + destClientCertsDirectory + "'");
                log.finest("Created Private Key export path '" + destPrivateKeysDirectory + "'");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to build the certificate export paths for adapter settings", e);
            throw new BajaRuntimeException("Can not convert provided adapter settings to string, missing PKI directory properties", (Throwable)e);
        }
    }

    private static void addOrSetDynamicSlot(String adapterOsName, BIEEE8021XAdapterSettings adapterSettings, String property, BValue propertyValue, int addFlags) {
        if (adapterSettings.get(property) == null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Adding dynamic property for adapter '" + adapterOsName + "' with values '" + property + EQUALS + propertyValue + "'");
            }
            adapterSettings.add(property, propertyValue, addFlags);
        } else {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Setting dynamic property for adapter '" + adapterOsName + "' with values '" + property + EQUALS + propertyValue + "'");
            }
            adapterSettings.set(property, propertyValue);
        }
    }

    private static String aliasToFilePath(String filePath, String alias, String suffix) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Converting certificate alias '" + alias + "' to filepath, using partial filepath: '" + filePath + "', using export suffix: '" + suffix + "'");
        }
        return filePath + '/' + alias + suffix;
    }

    private static String filePathToAlias(String filePath, String suffix) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Converting filepath '" + filePath + "' to certificate alias, using export suffix: '" + suffix + "'");
        }
        try {
            return filePath.substring(filePath.lastIndexOf(47) + 1, filePath.lastIndexOf(suffix));
        }
        catch (Exception exception) {
            LOG.warning("Failed to parse provided string '" + filePath + "' as a filepath, returning empty alias");
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "Parse failure exception", exception);
            }
            return BLANK;
        }
    }

    private static String unquote(String toUnquote) {
        if (toUnquote != null && (toUnquote.startsWith("\"") && toUnquote.endsWith("\"") || toUnquote.startsWith("'") && toUnquote.endsWith("'"))) {
            return toUnquote.substring(1, toUnquote.length() - 1);
        }
        return toUnquote;
    }

    private static String quote(String toQuote) {
        if (toQuote != null && (!toQuote.startsWith("\"") && !toQuote.endsWith("\"") || !toQuote.startsWith("'") && !toQuote.endsWith("'"))) {
            return "\"" + toQuote + "\"";
        }
        return toQuote;
    }

    static BPassword stringToPassphrase(String passphraseString) {
        if (passphraseString == null || passphraseString.isEmpty()) {
            return BPassword.DEFAULT;
        }
        return BPassword.make((String)passphraseString);
    }

    static String passphraseToString(BPassword passphraseValue) {
        if (passphraseValue == null || passphraseValue == BPassword.DEFAULT || passphraseValue.isDefault() || passphraseValue.equals((Object)BPassword.DEFAULT) || passphraseValue.getValue().isEmpty()) {
            return BLANK;
        }
        return passphraseValue.getValue();
    }

    private static void lineReaderToProperties(Properties properties, BufferedReader reader) throws IOException {
        String currentLine = reader.readLine();
        while (currentLine != null) {
            String[] keyValue = TextUtil.split((String)currentLine, (char)'=');
            properties.setProperty(keyValue[0], keyValue[1]);
            currentLine = reader.readLine();
        }
    }

    private static void dumpWpaSupplicantStatus(Properties currentWpaStateProperties, String statusFilePathProperty) {
        StringBuilder builder = new StringBuilder();
        int keyCount = currentWpaStateProperties.keySet().size();
        for (String key : currentWpaStateProperties.stringPropertyNames()) {
            builder.append(key).append(EQUALS).append(currentWpaStateProperties.getProperty(key)).append(NEWLINE);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Read status file at '" + statusFilePathProperty + "', contains " + keyCount + " values" + (keyCount > 0 ? NEWLINE + builder : BLANK));
        }
    }

    public static String getAdapterIdFromOsName(String supportedOsAdapter, boolean isTridiumQNX) {
        return IEEE8021XServlet.getAdapterIdFromOsName((String)supportedOsAdapter, (boolean)isTridiumQNX);
    }

    private static class CertInfo {
        String absoluteKeyDirDestination;
        String keySuffix;
        String absoluteCertDirDestination;
        String certSuffix;
        String alias;
        boolean isKeyFile;
        String passphrase;
        ByteBuffer certBuffer;
        ByteBuffer keyBuffer;

        CertInfo(String absoluteKeyDestination, String keySuffix, String absoluteCertDestination, String certSuffix, String alias, boolean isKeyFile, String passphrase) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Adding a certificate to export with key dir dest '" + absoluteKeyDestination + "' key suffix '" + keySuffix + "' cert dir dest '" + absoluteCertDestination + "' cert suffix '" + certSuffix + "' alias '" + alias + "' isKeyFile '" + isKeyFile + "' passphrase '[obscured]'");
            }
            this.absoluteKeyDirDestination = absoluteKeyDestination;
            this.keySuffix = keySuffix;
            this.absoluteCertDirDestination = absoluteCertDestination;
            this.certSuffix = certSuffix;
            this.alias = alias;
            this.isKeyFile = isKeyFile;
            this.passphrase = passphrase;
        }
    }
}

