/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth.web;

import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.LoginFailureCause;
import com.tridium.clientCertAuth.BClientCertAuthScheme;
import com.tridium.clientCertAuth.BClientCertAuthenticator;
import com.tridium.clientCertAuth.ClientCertAuthException;
import com.tridium.clientCertAuth.ClientCertAuthUtils;
import com.tridium.clientCertAuth.ClientCertAuthenticationInfo;
import com.tridium.clientCertAuth.pki.BCaConfiguration;
import com.tridium.clientCertAuth.pki.BPKIAuthenticationScheme;
import com.tridium.clientCertAuth.web.ClientCertAuthInfoHandler;
import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.TridiumCertValidator;
import com.tridium.crypto.core.cert.ValidationException;
import com.tridium.web.CookieUtil;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.baja.clientCertAuth.pki.BICertValidationRule;
import javax.baja.clientCertAuth.pki.BIUsernameExtractor;
import javax.baja.sys.BComplex;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;
import javax.baja.web.servlets.UnauthenticatedServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class ClientCertAuthServlet
extends UnauthenticatedServlet {
    private static final LexiconModule lex = LexiconModule.make(ClientCertAuthServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Locale locale = request.getLocale();
        BasicContext context = new BasicContext(null, locale != null ? locale.toLanguageTag() : Sys.getLanguage());
        try {
            if (!request.isSecure()) {
                throw new ClientCertAuthException("Cannot perform client certificate authentication over non-TLS", lex.get("clientCertAuth.exception.noTLS", (Context)context));
            }
            X509Certificate[] clientCertChain = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            if (clientCertChain == null) {
                throw new ClientCertAuthException("No client certificate provided", lex.getText("clientCertAuth.exception.noCert", (Context)context));
            }
            String requestURI = request.getRequestURI();
            if (requestURI != null && requestURI.endsWith("pki")) {
                ClientCertAuthServlet.handlePkiAuthScheme(request, response, clientCertChain, (Context)context);
            } else {
                X509Certificate clientCertificate = clientCertChain[0];
                ClientCertAuthServlet.handleClientCertAuthScheme(request, response, clientCertificate, (Context)context);
            }
        }
        catch (ClientCertAuthException e) {
            ClientCertAuthUtils.log(Level.WARNING, e.getDetailedErrorMessage(), (Throwable)e);
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)LoginFailureCause.CLIENT_CERT_FAILURE.name(), (int)-1));
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_info", (String)Base64.getEncoder().encodeToString(e.getUserErrorMessage((Context)context).getBytes(StandardCharsets.UTF_8)), (int)-1));
            response.sendRedirect("/login?auth=fail");
        }
        catch (Exception e) {
            ClientCertAuthUtils.log(Level.WARNING, e.getMessage(), (Throwable)e);
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)LoginFailureCause.CLIENT_CERT_FAILURE.name(), (int)-1));
            response.sendRedirect("/login?auth=fail");
        }
    }

    private static void handleClientCertAuthScheme(HttpServletRequest request, HttpServletResponse response, X509Certificate clientCertificate, Context context) throws ClientCertAuthException, IOException {
        String username = ClientCertAuthServlet.findUserFromCertificate(clientCertificate, context);
        NiagaraWebSession session = WebSessionUtil.getSession((HttpServletRequest)request, (boolean)true);
        ClientCertAuthenticationInfo authenticationInfo = AccessController.doPrivileged(() -> ClientCertAuthenticationInfo.make(username, clientCertificate));
        ClientCertAuthInfoHandler.addAuthenticationInfo(session.getId(), authenticationInfo);
        session.setAttribute("username", (Object)authenticationInfo.getUsername());
        response.sendRedirect("/j_security_check");
    }

    private static void handlePkiAuthScheme(HttpServletRequest request, HttpServletResponse response, X509Certificate[] clientCertChain, Context context) throws ClientCertAuthException, IOException {
        BUuid schemeId;
        try {
            schemeId = BUuid.make((String)request.getParameter("schemeId"));
        }
        catch (Exception e) {
            throw new ClientCertAuthException("Invalid schemeId parameter format: " + request.getParameter("schemeId"), lex.getText("pki.clientCertAuth.exception.badSchemeId", context));
        }
        BPKIAuthenticationScheme pkiScheme = ClientCertAuthServlet.getSelectedPkiScheme(schemeId);
        BCaConfiguration configuration = ClientCertAuthServlet.validateCertificateSignature(clientCertChain, pkiScheme);
        if (configuration == null) {
            throw new ClientCertAuthException(lex.getText("pki.clientCertAuth.certValidator.issuerCAMismatch", context, new Object[]{schemeId}));
        }
        X509Certificate clientCertificate = clientCertChain[0];
        String username = ClientCertAuthServlet.findPKIUsernameFromCertificate(clientCertificate, configuration, context);
        if (username == null) {
            throw new ClientCertAuthException(lex.getText("pki.clientCertAuth.certValidator.userNameNotFoundInCertificate", context));
        }
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUser user = userService.getUser(username);
        if (user != null && user.getAuthenticationScheme() instanceof BPKIAuthenticationScheme && user.getAuthenticationScheme().equals((Object)pkiScheme)) {
            ClientCertAuthServlet.validateCertificate(clientCertificate, configuration);
            NiagaraWebSession session = WebSessionUtil.getSession((HttpServletRequest)request, (boolean)true);
            ClientCertAuthenticationInfo authenticationInfo = AccessController.doPrivileged(() -> ClientCertAuthenticationInfo.make(username, clientCertificate));
            ClientCertAuthInfoHandler.addAuthenticationInfo(session.getId(), authenticationInfo);
            session.setAttribute("username", (Object)authenticationInfo.getUsername());
            response.sendRedirect("/j_security_check");
        } else {
            if (user == null) {
                throw new ClientCertAuthException(lex.getText("pki.clientCertAuth.certValidator.userNameNotFoundInUserService", context, new Object[]{username}));
            }
            if (!(user.getAuthenticationScheme() instanceof BPKIAuthenticationScheme)) {
                throw new ClientCertAuthException(lex.getText("pki.clientCertAuth.invalidAuthenticationScheme", context, new Object[]{username, pkiScheme.getDisplayName(context)}));
            }
        }
    }

    private static BCaConfiguration validateCertificateSignature(X509Certificate[] clientCertificateChain, BPKIAuthenticationScheme pkiScheme) throws ClientCertAuthException {
        List sortedChain = CertUtils.sortCertChain(Arrays.asList(clientCertificateChain));
        try {
            for (BCaConfiguration configuration : pkiScheme.getCaConfigurations()) {
                if (configuration.getCa().isNull()) {
                    if (!ClientCertAuthUtils.log.isLoggable(Level.FINE)) continue;
                    ClientCertAuthUtils.log(Level.FINE, "No certificate configured for: " + configuration.getName() + ". Skipping.");
                    continue;
                }
                PKIXCertPathBuilderResult result = TridiumCertValidator.validateCertChain(Collections.singleton(new TrustAnchor(configuration.getCa().getX509Certificate(), null)), (List)sortedChain);
                if (result != null) {
                    if (ClientCertAuthUtils.log.isLoggable(Level.FINE)) {
                        ClientCertAuthUtils.log(Level.FINE, "Validation succeeded for: " + configuration.getName());
                    }
                    return configuration;
                }
                if (!ClientCertAuthUtils.log.isLoggable(Level.FINE)) continue;
                ClientCertAuthUtils.log(Level.FINE, "Validation failed for: " + configuration.getName());
            }
        }
        catch (ValidationException e) {
            ClientCertAuthUtils.log(Level.WARNING, "Could not perform certificate validation: " + e.getMessage(), (Throwable)e);
            throw new ClientCertAuthException("Could not perform certificate validation", e);
        }
        throw new ClientCertAuthException(lex.getText("pki.clientCertAuth.certValidator.issuerCAMismatch", null, new Object[]{pkiScheme.getName()}));
    }

    private static void validateCertificate(X509Certificate clientCertificate, BCaConfiguration caConfiguration) throws ClientCertAuthException {
        BICertValidationRule[] validationRules;
        for (BICertValidationRule validationRule : validationRules = caConfiguration.getCertValidationRules()) {
            if (validationRule.validateCertificate(clientCertificate)) continue;
            throw new ClientCertAuthException("Validation failed for rule: " + ((BComplex)validationRule.as(BComplex.class)).getName());
        }
    }

    private static String findPKIUsernameFromCertificate(X509Certificate clientCertificate, BCaConfiguration configuration, Context context) throws ClientCertAuthException {
        BTypeSpec usernameExtractorType = configuration.getUsernameExtractorTypeSelection();
        BIUsernameExtractor obj = (BIUsernameExtractor)usernameExtractorType.getInstance();
        return obj.extractUsernameFromCertificate(clientCertificate, context);
    }

    private static String findUserFromCertificate(X509Certificate clientCertificate, Context context) throws ClientCertAuthException {
        RDN[] rdns;
        HashSet<String> usernames = new HashSet<String>();
        for (RDN rdn : rdns = NX509Certificate.make((X509Certificate)clientCertificate).getSubjectDN().getRDNs(BCStyle.CN)) {
            usernames.add(IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue()));
        }
        try {
            Collection<List<?>> sans = clientCertificate.getSubjectAlternativeNames();
            if (sans != null) {
                for (List<?> san : sans) {
                    int generalNameType = (Integer)san.get(0);
                    if (generalNameType != 1) continue;
                    usernames.add((String)san.get(1));
                }
            }
        }
        catch (CertificateParsingException e) {
            ClientCertAuthUtils.log(Level.WARNING, () -> Lexicon.make((String)"clientCertAuth", (Context)context).getText("clientCertAuth.exception.parsingSAN"), (Throwable)e);
        }
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        for (String username : usernames) {
            BUser user = userService.getUser(username);
            if (user == null || !(user.getAuthenticationScheme() instanceof BClientCertAuthScheme) || !clientCertificate.equals(((BClientCertAuthenticator)user.getAuthenticator()).getCertificate().getX509Certificate())) continue;
            return username;
        }
        for (BUser user : userService.getUsers()) {
            if (!(user.getAuthenticationScheme() instanceof BClientCertAuthScheme) || !clientCertificate.equals(((BClientCertAuthenticator)user.getAuthenticator()).getCertificate().getX509Certificate())) continue;
            return user.getUsername();
        }
        Lexicon lex = Lexicon.make((String)"clientCertAuth", (Context)context);
        String detailedMessage = lex.getText("clientCertAuth.servlet.exception.noUserFound");
        ClientCertAuthUtils.log(Level.FINE, () -> lex.getText("clientCertAuth.servlet.noUserFoundForCert", new Object[]{clientCertificate.toString()}));
        throw new ClientCertAuthException(detailedMessage);
    }

    private static BPKIAuthenticationScheme getSelectedPkiScheme(BUuid schemeId) throws ClientCertAuthException {
        BPKIAuthenticationScheme[] pkiSchemes;
        BAuthenticationService authServ = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
        for (BPKIAuthenticationScheme pkiScheme : pkiSchemes = (BPKIAuthenticationScheme[])authServ.getAuthenticationSchemes().getChildren(BPKIAuthenticationScheme.class)) {
            if (!pkiScheme.getSchemeId().equals((Object)schemeId)) continue;
            return pkiScheme;
        }
        throw new ClientCertAuthException("Could not find PKI Authentication Scheme");
    }
}

