/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth.web;

import com.tridium.authn.LoginFailureCause;
import com.tridium.clientCertAuth.ClientCertAuthUtils;
import com.tridium.clientCertAuth.ClientCertAuthenticationInfo;
import com.tridium.clientCertAuth.ClientCertCallback;
import com.tridium.clientCertAuth.web.ClientCertAuthInfoHandler;
import com.tridium.web.CookieUtil;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.authn.BWebCallbackHandler;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType(agent={@AgentOn(types={"clientCertAuth:ClientCertAuthScheme", "clientCertAuth:PKIAuthenticationScheme"})})
public class BWebClientCertCallbackHandler
extends BWebCallbackHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BWebClientCertCallbackHandler.class);
    private String username = null;
    private ClientCertAuthenticationInfo authenticationInfo;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String getUsername() {
        return this.username;
    }

    public int handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!request.isSecure()) {
            return 3;
        }
        String sessionId = WebSessionUtil.getId((String)request.getRequestedSessionId());
        ClientCertAuthenticationInfo authenticationInfo = ClientCertAuthInfoHandler.getAuthenticationInfo(sessionId);
        if (authenticationInfo != null) {
            this.authenticationInfo = authenticationInfo;
            this.username = authenticationInfo.getUsername();
            ClientCertAuthInfoHandler.removeAuthenticationInfo(sessionId);
            return 0;
        }
        ClientCertAuthUtils.log(Level.WARNING, "Could not find client certificate authentication info");
        response.addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)LoginFailureCause.CLIENT_CERT_FAILURE.name(), (int)-1, (boolean)true, (boolean)request.isSecure()));
        return 3;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            throw new IOException("invalid callback array provided");
        }
        for (Callback callback : callbacks) {
            if (!(callback instanceof ClientCertCallback)) {
                throw new UnsupportedCallbackException(callback, "Callback " + callback.getClass().getName() + " is not supported.");
            }
            ((ClientCertCallback)callback).setAuthenticationInfo(this.authenticationInfo);
        }
    }
}

