/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth.pki;

import com.tridium.authn.NiagaraFailedLoginException;
import com.tridium.authn.NiagaraLoginModule;
import com.tridium.clientCertAuth.ClientCertCallback;
import com.tridium.clientCertAuth.pki.BPKIAuthenticationScheme;
import java.util.logging.Level;
import javax.baja.authn.AuthenticationUtil;
import javax.baja.user.BUserService;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public class PKILoginModule
extends NiagaraLoginModule {
    public boolean login() throws LoginException {
        FailedLoginException e;
        String username;
        if (this.callbackHandler == null) {
            throw new LoginException("CallbackHandler cannot be null for PKI login");
        }
        Callback[] callbacks = new Callback[]{new ClientCertCallback()};
        try {
            this.callbackHandler.handle(callbacks);
            username = ((ClientCertCallback)callbacks[0]).getAuthenticationInfo().getUsername();
        }
        catch (UnsupportedCallbackException e2) {
            String msg = "Provided callback handler could not handle: " + e2.getCallback().toString();
            AuthenticationUtil.debug((Level)Level.SEVERE, (String)msg, (Throwable)e2);
            throw new LoginException(msg);
        }
        catch (Exception e3) {
            String msg = "Error handling callbacks:" + e3;
            AuthenticationUtil.debug((Level)Level.SEVERE, (String)msg, (Throwable)e3);
            throw new LoginException(msg);
        }
        if (username != null) {
            try {
                BUserService userService = this.getUserService();
                this.user = userService.getUser(username);
                if (this.user != null && userService.canLogin(this.user) && this.user.getAuthenticationScheme() instanceof BPKIAuthenticationScheme) {
                    this.succeeded = true;
                    return true;
                }
            }
            catch (Exception userService) {
                // empty catch block
            }
        }
        if (this.user != null) {
            e = new NiagaraFailedLoginException(this.user.getName(), "Login failed: Invalid username or password.");
            this.user = null;
        } else {
            e = new FailedLoginException("Login failed: Invalid username or password.");
        }
        throw e;
    }
}

