/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth.pki;

import com.tridium.clientCertAuth.ClientCertAuthException;
import com.tridium.clientCertAuth.ClientCertAuthUtils;
import com.tridium.crypto.core.cert.ASN1UPN;
import java.io.IOException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.baja.clientCertAuth.pki.BIUsernameExtractor;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DLTaggedObject;

@NiagaraType
public class BUsernameExtractorUPNSan
extends BObject
implements BIUsernameExtractor {
    @Generated
    public static final Type TYPE = Sys.loadType(BUsernameExtractorUPNSan.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public String extractUsernameFromCertificate(X509Certificate cert, Context context) throws ClientCertAuthException {
        try {
            Collection<List<?>> sans = cert.getSubjectAlternativeNames();
            if (sans != null) {
                boolean isFailed = false;
                for (List<?> san : sans) {
                    int generalNameType = (Integer)san.get(0);
                    if (generalNameType != 0) continue;
                    isFailed = false;
                    try {
                        byte[] asn1Data = (byte[])san.get(1);
                        ASN1Sequence outerSequence = this.getOuterDLSequence(asn1Data);
                        ASN1UPN decodedUPN = ASN1UPN.getInstance((Object)outerSequence);
                        return decodedUPN.getUPN();
                    }
                    catch (Exception e) {
                        ClientCertAuthUtils.log(Level.WARNING, "Error parsing certificate UPN SANs while looking for user name. Ignoring SANs.");
                        isFailed = true;
                    }
                }
                if (isFailed) {
                    Lexicon lex = Lexicon.make((String)"clientCertAuth", (Context)context);
                    throw new ClientCertAuthException(lex.getText("pki.clientCertAuth.exception.parsingSAN", new Object[]{lex.getText("pki.clientCertAuth.upn")}));
                }
            }
        }
        catch (CertificateParsingException e) {
            ClientCertAuthUtils.log(Level.WARNING, "Error parsing certificate UPN SANs while looking for user name. Ignoring SANs.");
            Lexicon lex = Lexicon.make((String)"clientCertAuth", (Context)context);
            throw new ClientCertAuthException(lex.getText("pki.clientCertAuth.exception.parsingSAN", new Object[]{lex.getText("pki.clientCertAuth.upn")}));
        }
        return null;
    }

    private ASN1Sequence getOuterDLSequence(byte[] asn1Data) throws IOException, ClientCertAuthException {
        Throwable throwable = null;
        try (ASN1InputStream asn1InputStream = new ASN1InputStream(asn1Data);){
            DLTaggedObject outerTaggedObject;
            ASN1Primitive outerPrimitive = asn1InputStream.readObject();
            if (outerPrimitive instanceof DLTaggedObject && (outerTaggedObject = (DLTaggedObject)outerPrimitive).getTagNo() == 0) {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((ASN1TaggedObject)outerTaggedObject, (boolean)false);
                return aSN1Sequence;
            }
            try {
                throw new ClientCertAuthException("Error Parsing OuterDL Sequence");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

