/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth.pki;

import com.tridium.clientCertAuth.ClientCertAuthException;
import com.tridium.clientCertAuth.ClientCertAuthUtils;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.baja.clientCertAuth.pki.BIUsernameExtractor;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BUsernameExtractorEmailUserSan
extends BObject
implements BIUsernameExtractor {
    @Generated
    public static final Type TYPE = Sys.loadType(BUsernameExtractorEmailUserSan.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public String extractUsernameFromCertificate(X509Certificate cert, Context context) throws ClientCertAuthException {
        try {
            Collection<List<?>> sans = cert.getSubjectAlternativeNames();
            if (sans != null) {
                boolean isFailed = false;
                for (List<?> san : sans) {
                    int generalNameType = (Integer)san.get(0);
                    if (generalNameType != 1) continue;
                    isFailed = false;
                    String fullEmail = (String)san.get(1);
                    if (ClientCertAuthUtils.isValidEmail(fullEmail)) {
                        return fullEmail.substring(0, fullEmail.indexOf("@"));
                    }
                    ClientCertAuthUtils.log(Level.WARNING, "Invalid Email Address: " + fullEmail);
                    isFailed = true;
                }
                if (isFailed) {
                    Lexicon lex = Lexicon.make((String)"clientCertAuth", (Context)context);
                    throw new ClientCertAuthException(lex.getText("pki.clientCertAuth.exception.parsingSAN", new Object[]{lex.getText("pki.clientCertAuth.emailUser")}));
                }
            }
        }
        catch (CertificateParsingException e) {
            ClientCertAuthUtils.log(Level.WARNING, "Error parsing certificate email user SANs while looking for user name. Ignoring SANs.");
            Lexicon lex = Lexicon.make((String)"clientCertAuth", (Context)context);
            throw new ClientCertAuthException(lex.getText("pki.clientCertAuth.exception.parsingSAN", new Object[]{lex.getText("pki.clientCertAuth.emailUser")}));
        }
        return null;
    }
}

