/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth.pki;

import com.tridium.clientCertAuth.ClientCertAuthException;
import com.tridium.clientCertAuth.ClientCertAuthUtils;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.baja.clientCertAuth.pki.BIUsernameExtractor;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

@NiagaraType
public class BUsernameExtractorCNFromDirectoryNameSan
extends BObject
implements BIUsernameExtractor {
    @Generated
    public static final Type TYPE = Sys.loadType(BUsernameExtractorCNFromDirectoryNameSan.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public String extractUsernameFromCertificate(X509Certificate cert, Context context) throws ClientCertAuthException {
        try {
            Collection<List<?>> sans = cert.getSubjectAlternativeNames();
            if (sans != null) {
                for (List<?> san : sans) {
                    int generalNameType = (Integer)san.get(0);
                    if (generalNameType != 4) continue;
                    X500Name x500Name = new X500Name((String)san.get(1));
                    RDN[] rdns = x500Name.getRDNs(BCStyle.CN);
                    boolean isFailed = false;
                    for (RDN rdn : rdns) {
                        isFailed = false;
                        try {
                            return IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
                        }
                        catch (Exception e) {
                            ClientCertAuthUtils.log(Level.WARNING, "Error parsing certificate directory name SANs while looking for user name.");
                            isFailed = true;
                        }
                    }
                    if (!isFailed) continue;
                    Lexicon lex = Lexicon.make((String)"clientCertAuth", (Context)context);
                    throw new ClientCertAuthException(lex.getText("pki.clientCertAuth.exception.parsingSAN", new Object[]{lex.getText("pki.clientCertAuth.directoryName")}));
                }
            }
        }
        catch (CertificateParsingException e) {
            ClientCertAuthUtils.log(Level.WARNING, "Error parsing certificate directory name SANs while looking for user name. Ignoring SANs.");
            Lexicon lex = Lexicon.make((String)"clientCertAuth", (Context)context);
            throw new ClientCertAuthException(lex.getText("pki.clientCertAuth.exception.parsingSAN", new Object[]{lex.getText("pki.clientCertAuth.directoryName")}));
        }
        return null;
    }
}

