/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth.pki;

import com.tridium.authn.BAuthenticationSchemeFolder;
import com.tridium.authn.NiagaraLoginConfiguration;
import com.tridium.clientCertAuth.pki.BCaConfiguration;
import com.tridium.clientCertAuth.pki.BCaConfigurationFolder;
import com.tridium.clientCertAuth.pki.PKILoginModule;
import com.tridium.crypto.core.io.CRLProvider;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.TrustAnchorProvider;
import java.security.AccessController;
import java.security.cert.CRLException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.baja.authn.BSSOAuthenticationScheme;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BBlankAuthenticator;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="schemeId", type="BUuid", defaultValue="BUuid.make()", flags=69), @NiagaraProperty(name="caCertificates", type="BCaConfigurationFolder", defaultValue="new BCaConfigurationFolder()")})
public final class BPKIAuthenticationScheme
extends BSSOAuthenticationScheme
implements TrustAnchorProvider,
CRLProvider {
    @Generated
    public static final Property schemeId = BPKIAuthenticationScheme.newProperty((int)69, (BValue)BUuid.make(), null);
    @Generated
    public static final Property caCertificates = BPKIAuthenticationScheme.newProperty((int)0, (BValue)new BCaConfigurationFolder(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPKIAuthenticationScheme.class);
    public static final String SCHEME_NAME = "pkiAuth";
    public static final String REDIRECT_URL_BASE = "/clientCertAuth/clientCertAuth/pki?schemeId=";
    private Configuration configuration;
    private String trustAnchorProviderId;
    private String crlProviderId;

    @Generated
    public BUuid getSchemeId() {
        return (BUuid)this.get(schemeId);
    }

    @Generated
    public void setSchemeId(BUuid v) {
        this.set(schemeId, (BValue)v, null);
    }

    @Generated
    public BCaConfigurationFolder getCaCertificates() {
        return (BCaConfigurationFolder)this.get(caCertificates);
    }

    @Generated
    public void setCaCertificates(BCaConfigurationFolder v) {
        this.set(caCertificates, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPKIAuthenticationScheme() {
        this.setSchemeId(BUuid.make());
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BAuthenticationSchemeFolder.TYPE);
    }

    public void started() throws Exception {
        super.started();
        if (this.isMounted()) {
            AccessController.doPrivileged(() -> {
                this.trustAnchorProviderId = CoreCryptoManager.get().registerTrustAnchorProvider((TrustAnchorProvider)this);
                this.crlProviderId = CoreCryptoManager.get().registerCRLProvider((CRLProvider)this);
                return null;
            });
        }
    }

    public void stopped() throws Exception {
        AccessController.doPrivileged(() -> {
            CoreCryptoManager.get().unregisterTrustAnchorProvider(this.trustAnchorProviderId);
            CoreCryptoManager.get().unregisterCRLProvider(this.crlProviderId);
            return null;
        });
        super.stopped();
    }

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    public Configuration getLoginConfiguration() {
        if (this.configuration == null) {
            this.configuration = new NiagaraLoginConfiguration(PKILoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap());
        }
        return this.configuration;
    }

    public BAbstractAuthenticator getDefaultAuthenticator() {
        return new BBlankAuthenticator();
    }

    public String getLoginRedirectURL() {
        return REDIRECT_URL_BASE + this.getSchemeId();
    }

    public boolean supportsRemoteUsers() {
        return false;
    }

    public Set<TrustAnchor> getTrustAnchors() {
        BCaConfiguration[] caConfigurations;
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (BCaConfiguration caConfiguration : caConfigurations = (BCaConfiguration[])this.getCaCertificates().getChildren(BCaConfiguration.class)) {
            BX509Certificate caCertificate = caConfiguration.getCa();
            if (caCertificate.isNull()) continue;
            trustAnchors.add(new TrustAnchor(caCertificate.getX509Certificate(), null));
        }
        return trustAnchors;
    }

    public void trustAnchorsUpdated() {
        AccessController.doPrivileged(() -> {
            CoreCryptoManager.get().trustAnchorsUpdated(this.trustAnchorProviderId);
            return null;
        });
    }

    public Set<X509CRL> getCRLs() throws CRLException {
        BCaConfiguration[] caConfigurations;
        HashSet<X509CRL> crls = new HashSet<X509CRL>();
        for (BCaConfiguration caConfiguration : caConfigurations = (BCaConfiguration[])this.getCaCertificates().getChildren(BCaConfiguration.class)) {
            Optional crl = caConfiguration.getCaCertAndCrl().getCrl();
            crl.ifPresent(crls::add);
        }
        return crls;
    }

    public void crlsUpdated() {
        AccessController.doPrivileged(() -> {
            CoreCryptoManager.get().crlsUpdated(this.crlProviderId);
            return null;
        });
    }

    public BCaConfiguration[] getCaConfigurations() {
        return (BCaConfiguration[])this.getCaCertificates().getChildren(BCaConfiguration.class);
    }
}

