/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth.pki;

import com.tridium.clientCertAuth.ClientCertAuthUtils;
import com.tridium.clientCertAuth.pki.BKeySizeComparisonMode;
import com.tridium.crypto.core.cert.NX509Certificate;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.baja.clientCertAuth.pki.BICertValidationRule;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="keySize", type="int", defaultValue="2048"), @NiagaraProperty(name="comparisonMode", type="BKeySizeComparisonMode", defaultValue="BKeySizeComparisonMode.minimum")})
public class BKeySizeValidationRule
extends BComponent
implements BICertValidationRule {
    @Generated
    public static final Property keySize = BKeySizeValidationRule.newProperty((int)0, (int)2048, null);
    @Generated
    public static final Property comparisonMode = BKeySizeValidationRule.newProperty((int)0, (BValue)BKeySizeComparisonMode.minimum, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BKeySizeValidationRule.class);

    @Generated
    public int getKeySize() {
        return this.getInt(keySize);
    }

    @Generated
    public void setKeySize(int v) {
        this.setInt(keySize, v, null);
    }

    @Generated
    public BKeySizeComparisonMode getComparisonMode() {
        return (BKeySizeComparisonMode)this.get(comparisonMode);
    }

    @Generated
    public void setComparisonMode(BKeySizeComparisonMode v) {
        this.set(comparisonMode, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean validateCertificate(X509Certificate certificate) {
        NX509Certificate nx509Certificate = NX509Certificate.make((X509Certificate)certificate);
        int keySize = nx509Certificate.getKeySize();
        if (keySize == -1) {
            ClientCertAuthUtils.log(Level.WARNING, "Could not extract key size from certificate");
            return false;
        }
        switch (this.getComparisonMode().getOrdinal()) {
            case 0: {
                return keySize >= this.getKeySize();
            }
            case 1: {
                return keySize == this.getKeySize();
            }
        }
        ClientCertAuthUtils.log(Level.WARNING, "Unrecognized key size comparison mode");
        return false;
    }
}

