/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth.pki;

import com.tridium.clientCertAuth.ClientCertAuthUtils;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.baja.clientCertAuth.pki.BICertValidationRule;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="allowedAlgorithms", type="String", defaultValue="RSA;EC")
public class BKeyAlgorithmValidationRule
extends BComponent
implements BICertValidationRule {
    @Generated
    public static final Property allowedAlgorithms = BKeyAlgorithmValidationRule.newProperty((int)0, (String)"RSA;EC", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BKeyAlgorithmValidationRule.class);

    @Generated
    public String getAllowedAlgorithms() {
        return this.getString(allowedAlgorithms);
    }

    @Generated
    public void setAllowedAlgorithms(String v) {
        this.setString(allowedAlgorithms, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean validateCertificate(X509Certificate certificate) {
        String[] allowedAlgorithms;
        if (this.getAllowedAlgorithms().isEmpty()) {
            ClientCertAuthUtils.log(Level.WARNING, String.format("No key algorithms are allowed by rule '%s'", this.getName()));
            return false;
        }
        String keyAlgorithm = certificate.getPublicKey().getAlgorithm().trim();
        for (String algorithm : allowedAlgorithms = this.getAllowedAlgorithms().split(";")) {
            if (!keyAlgorithm.equalsIgnoreCase(algorithm.trim())) continue;
            ClientCertAuthUtils.log(Level.FINE, "Key algorithm successfully validated.");
            return true;
        }
        ClientCertAuthUtils.log(Level.WARNING, String.format("Key algorithm '%s' not allowed by rule '%s'", keyAlgorithm, this.getName()));
        return false;
    }
}

