/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth.pki;

import com.tridium.clientCertAuth.ClientCertAuthException;
import com.tridium.clientCertAuth.ClientCertAuthUtils;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.baja.clientCertAuth.pki.BICertValidationRule;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import org.bouncycastle.asn1.x509.KeyPurposeId;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="requireSmartcardLogonExtension", type="boolean", defaultValue="BBoolean.TRUE"), @NiagaraProperty(name="requireTlsWebClientAuthenticationExtension", type="boolean", defaultValue="BBoolean.TRUE"), @NiagaraProperty(name="requiredCustomExtensions", type="String", defaultValue="BString.DEFAULT")})
public class BExtendedKeyUsageValidationRule
extends BComponent
implements BICertValidationRule,
IPropertyValidator {
    @Generated
    public static final Property requireSmartcardLogonExtension = BExtendedKeyUsageValidationRule.newProperty((int)0, (BValue)BBoolean.TRUE, null);
    @Generated
    public static final Property requireTlsWebClientAuthenticationExtension = BExtendedKeyUsageValidationRule.newProperty((int)0, (BValue)BBoolean.TRUE, null);
    @Generated
    public static final Property requiredCustomExtensions = BExtendedKeyUsageValidationRule.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BExtendedKeyUsageValidationRule.class);
    private static final Pattern OID_REGEX = Pattern.compile("([0-2])((\\.0)|(\\.[1-9][0-9]*))*");

    @Generated
    public boolean getRequireSmartcardLogonExtension() {
        return this.getBoolean(requireSmartcardLogonExtension);
    }

    @Generated
    public void setRequireSmartcardLogonExtension(boolean v) {
        this.setBoolean(requireSmartcardLogonExtension, v, null);
    }

    @Generated
    public boolean getRequireTlsWebClientAuthenticationExtension() {
        return this.getBoolean(requireTlsWebClientAuthenticationExtension);
    }

    @Generated
    public void setRequireTlsWebClientAuthenticationExtension(boolean v) {
        this.setBoolean(requireTlsWebClientAuthenticationExtension, v, null);
    }

    @Generated
    public String getRequiredCustomExtensions() {
        return this.getString(requiredCustomExtensions);
    }

    @Generated
    public void setRequiredCustomExtensions(String v) {
        this.setString(requiredCustomExtensions, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean validateCertificate(X509Certificate certificate) {
        try {
            List<String> extendedKeyUsages = certificate.getExtendedKeyUsage();
            Set<String> requiredOids = this.getRequiredOidsSet();
            if (extendedKeyUsages == null && !requiredOids.isEmpty()) {
                ClientCertAuthUtils.log.warning("Extended Key Usages are required but certificate has none");
                return false;
            }
            for (String requiredOid : requiredOids) {
                if (extendedKeyUsages.contains(requiredOid)) continue;
                ClientCertAuthUtils.log.warning("Missing extended key usage: " + requiredOid);
                return false;
            }
            return true;
        }
        catch (CertificateParsingException e) {
            ClientCertAuthUtils.log.log(Level.WARNING, "Could not parse Extended Key Usages for certificate. Certificate validation failed.", e);
            return false;
        }
        catch (ClientCertAuthException e) {
            return false;
        }
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public void validateSet(Validatable validatable, Context context) {
        for (Property property : validatable.getModifiedProperties()) {
            String proposedCustomOids;
            if (!property.equals(requiredCustomExtensions) || (proposedCustomOids = ((BString)validatable.getProposedValue(requiredCustomExtensions)).getString()).isEmpty()) continue;
            BExtendedKeyUsageValidationRule.validateCustomOids(proposedCustomOids);
        }
    }

    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        String proposedCustomOids;
        if (property.equals(requiredCustomExtensions) && !(proposedCustomOids = ((BString)newValue).getString()).isEmpty()) {
            BExtendedKeyUsageValidationRule.validateCustomOids(proposedCustomOids);
        }
    }

    private static void validateCustomOids(String customOids) {
        String[] oids;
        for (String oid : oids = customOids.split(";")) {
            if (OID_REGEX.matcher(oid).matches()) continue;
            throw new LocalizableRuntimeException("clientCertAuth", "pki.clientCertAuth.certValidator.eku.badOid", new Object[]{oid});
        }
    }

    private Set<String> getRequiredOidsSet() throws ClientCertAuthException {
        HashSet<String> requiredOids = new HashSet<String>();
        if (this.getRequireSmartcardLogonExtension()) {
            requiredOids.add(KeyPurposeId.id_kp_smartcardlogon.getId());
        }
        if (this.getRequireTlsWebClientAuthenticationExtension()) {
            requiredOids.add(KeyPurposeId.id_kp_clientAuth.getId());
        }
        this.addCustomOids(requiredOids);
        return requiredOids;
    }

    private void addCustomOids(Set<String> requiredOids) throws ClientCertAuthException {
        String[] oids;
        String customOids = this.getRequiredCustomExtensions();
        if (customOids.isEmpty()) {
            return;
        }
        for (String oid : oids = customOids.split(";")) {
            if (!OID_REGEX.matcher(oid).matches()) {
                ClientCertAuthUtils.log(Level.WARNING, "Invalid oid found in '" + this.getName() + "' Extended Key Usage validation rule: " + oid);
                throw new ClientCertAuthException("invalid oid");
            }
            requiredOids.add(oid);
        }
    }
}

