/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxSecureRequiredException;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxClientWebsocketBehavior;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.FoxHttpsSocket;
import java.net.Socket;
import javax.baja.fox.authn.BFoxClientAuthnHandler;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BCertificateAliasCredential;
import javax.baja.security.BICredentials;
import javax.baja.security.BIPreconnectCredentials;
import javax.baja.security.BUsernameCredential;
import javax.baja.sys.BIObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

@NiagaraType(agent={@AgentOn(types={"clientCertAuth:ClientCertAuthScheme"})})
public class BFoxClientCertAuthnHandler
extends BFoxClientAuthnHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxClientCertAuthnHandler.class);
    private BCertificateAliasCredential certAliasCredential = new BCertificateAliasCredential();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void handleAuthentication(FoxSession session, AuthenticationClient authenticationClient) throws Exception {
        BFoxClientConnection foxClientConnection = (BFoxClientConnection)session.conn();
        if (!foxClientConnection.getUseFoxs() && !foxClientConnection.getFoxOverWebsocket().equals((Object)BFoxClientWebsocketBehavior.useWebsocketOnly)) {
            throw new FoxSecureRequiredException(session);
        }
        BFoxSession realm = foxClientConnection.getFoxSession();
        Socket socket = session.getSocket();
        SSLSession sslSession = null;
        if (socket instanceof SSLSocket) {
            sslSession = ((SSLSocket)socket).getSession();
        } else if (socket instanceof FoxHttpsSocket) {
            sslSession = ((FoxHttpsSocket)socket).getSSLSession();
        }
        if (sslSession != null && sslSession.getLocalCertificates() != null) {
            FoxMessage login = new FoxMessage();
            login.add("username", this.certAliasCredential.getUsername());
            session.setState("client.tune ClientCertAuthnHandler send login");
            session.sendTuning("login", login);
            authenticationClient.setPreconnectCredentials(null);
        } else {
            String scheme = foxClientConnection.getAuthenticationScheme();
            BICredentials credentials = authenticationClient.requestInformation((AuthenticationRealm)realm, scheme, 0, (BIObject)this.certAliasCredential);
            if (credentials == null) {
                throw new FoxAuthenticationException("Cancelled", scheme, null, session);
            }
            if (!(credentials instanceof BCertificateAliasCredential)) {
                throw new FoxAuthenticationException(Lexicon.make((String)"clientCertAuth").getText("authnHandler.unsupportedCredentials", new Object[]{credentials.getType()}), scheme, null, session);
            }
            this.certAliasCredential = (BCertificateAliasCredential)credentials;
            authenticationClient.setPreconnectCredentials((BIPreconnectCredentials)this.certAliasCredential);
        }
    }

    public void setData(BIObject data) {
        if (data instanceof BUsernameCredential) {
            this.certAliasCredential.setUsername(((BUsernameCredential)data).getUsername());
        } else if (data instanceof BCertificateAliasCredential) {
            this.certAliasCredential = (BCertificateAliasCredential)data;
        } else {
            throw new UnsupportedOperationException("Data type not supported.");
        }
    }
}

