/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BLiqSenAlmEntry;
import com.tridium.tls.datatypes.BLiqSenAlmHistoryRecord;
import com.tridium.tls.datatypes.BLiqSenAlmTable;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.Tls350LiqSenAlmHisReport;
import com.tridium.tls.messages.Tls350LiqSenAlmHisReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350ConsoleDevicePointDeviceExt;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350LsaDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="sensorNumber", type="int", defaultValue="0", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")}), @NiagaraProperty(name="minimumPollInterval", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)"), @NiagaraProperty(name="liqSenAlmTable", type="BLiqSenAlmTable", defaultValue="new BLiqSenAlmTable()"), @NiagaraProperty(name="maxOldEntriesSaved", type="int", defaultValue="8", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")})})
@NiagaraAction(name="purgeHashtable", flags=4)
public class BTls350LiqSenAlmHisProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    @Generated
    public static final Property sensorNumber = BTls350LiqSenAlmHisProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property minimumPollInterval = BTls350LiqSenAlmHisProxyExt.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), null);
    @Generated
    public static final Property liqSenAlmTable = BTls350LiqSenAlmHisProxyExt.newProperty((int)0, (BValue)new BLiqSenAlmTable(), null);
    @Generated
    public static final Property maxOldEntriesSaved = BTls350LiqSenAlmHisProxyExt.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Action purgeHashtable = BTls350LiqSenAlmHisProxyExt.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTls350LiqSenAlmHisProxyExt.class);
    private Vector<BLiqSenAlmEntry> lSAEntriesVector;
    private Hashtable<Long, BLiqSenAlmEntry> lSAHashtable;
    private Clock.Ticket purgeHashtableValuesTicket;
    private boolean purgeHashtableValuesFlag;

    @Generated
    public int getSensorNumber() {
        return this.getInt(sensorNumber);
    }

    @Generated
    public void setSensorNumber(int v) {
        this.setInt(sensorNumber, v, null);
    }

    @Generated
    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    @Generated
    public void setMinimumPollInterval(BRelTime v) {
        this.set(minimumPollInterval, (BValue)v, null);
    }

    @Generated
    public BLiqSenAlmTable getLiqSenAlmTable() {
        return (BLiqSenAlmTable)this.get(liqSenAlmTable);
    }

    @Generated
    public void setLiqSenAlmTable(BLiqSenAlmTable v) {
        this.set(liqSenAlmTable, (BValue)v, null);
    }

    @Generated
    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    @Generated
    public void setMaxOldEntriesSaved(int v) {
        this.setInt(maxOldEntriesSaved, v, null);
    }

    @Generated
    public void purgeHashtable() {
        this.invoke(purgeHashtable, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getDeviceExtType() {
        return BTls350ConsoleDevicePointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BLiqSenAlmEntry[] saved = this.getLiqSenAlmTable().getEntries();
            this.lSAHashtable = new Hashtable(saved.length * 2);
            for (int i = 0; i < saved.length; ++i) {
                Long key = saved[i].getValueHashCode();
                this.lSAHashtable.put(key, saved[i]);
            }
            TlsHistoryHelper.initHistory(BLiqSenAlmHistoryRecord.TYPE);
            this.reschedPurgeHashtable();
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        this.lSAHashtable = null;
        super.stopped();
    }

    @Override
    public void poll() {
        if (!(this.getDevice().getEnabled() && this.getEnabled() && this.pollIntervalCheck(this.getMinimumPollInterval().getMillis()))) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        boolean pollDebug = this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1;
        boolean pollDebugSkip = this.isTraceOn() && this.device().getUserData().indexOf("skip") != -1;
        int sensorNumber = this.getSensorNumber();
        Tls350LiqSenAlmHisReport req = new Tls350LiqSenAlmHisReport(sensorNumber, this);
        Tls350LiqSenAlmHisReportResponse rsp = (Tls350LiqSenAlmHisReportResponse)this.network().sendSync(req);
        if (rsp != null) {
            if (rsp.getSuccessfulResponse()) {
                this.device().setPollSinceLastPingFlag();
                if (sensorNumber == 0) {
                    System.out.println(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! sensor number not initialized... initialize sensor number to valid sensor\n\n");
                    return;
                }
                if (sensorNumber != rsp.getSensorNumber()) {
                    System.out.println(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! sensor number does no match response sensor number " + sensorNumber + "!=" + rsp.getSensorNumber() + "\n\n");
                    this.readFail("Error Response... Sensor number mismatch");
                    return;
                }
                BAbsTime rt = rsp.getReadTime();
                if (rt == null) {
                    rt = BAbsTime.make();
                }
                int[] alarmTypes = rsp.getAlarmTypes();
                BAbsTime[] alarmDTs = rsp.getAlarmDateTimes();
                if (alarmTypes.length == 0) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... poll response contains no alarm entries... nothing to record sensorNumber=" + rsp.getSensorNumber() + " alarmTypes.length=" + alarmTypes.length);
                    }
                    return;
                }
                this.lSAEntriesVector = new Vector();
                boolean newEntryDetected = false;
                String stationName = Sys.getStation().getStationName();
                for (int i = alarmTypes.length - 1; i > -1; --i) {
                    BLiqSenAlmEntry newLSAEntry = new BLiqSenAlmEntry(stationName, sensorNumber, alarmDTs[i], alarmTypes[i]);
                    BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
                    if (newLSAEntry.getReadTime().isBefore(previousTime)) {
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newLSAEntry.createCommaDelimitedString() + " for " + this.getName());
                        continue;
                    }
                    if (!alarmDTs[i].isBefore(rt)) {
                        if (!pollDebugSkip) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... potential incomplete entry = " + newLSAEntry.createCommaDelimitedString() + " for " + this.getName());
                        continue;
                    }
                    Long newHtKey = newLSAEntry.getValueHashCode();
                    if (this.lSAHashtable == null || this.lSAHashtable.get(newHtKey) == null || newEntryDetected) {
                        this.lSAHashtable.put(newHtKey, newLSAEntry);
                        this.lSAEntriesVector.addElement(newLSAEntry);
                        newEntryDetected = true;
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow add... new entry = " + newLSAEntry.createCommaDelimitedString());
                        continue;
                    }
                    if (!pollDebug) continue;
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newLSAEntry.createCommaDelimitedString());
                }
                if (this.lSAEntriesVector.size() > 0) {
                    this.setValue(this.lSAEntriesVector);
                    return;
                }
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)sv);
                this.updateDemuxedProxyPoints();
            } else {
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response... Unsuccessful response");
            }
        } else {
            if (pollDebug) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("Error Response... Null Response");
            this.device().ping();
        }
        if (this.purgeHashtableValuesFlag) {
            this.purgeOldHashtableValues();
        }
    }

    public void setValue(Vector<BLiqSenAlmEntry> values) {
        BLiqSenAlmEntry[] valuesCopy = new BLiqSenAlmEntry[values.size()];
        values.copyInto((Object[])valuesCopy);
        BLiqSenAlmTable sendToCsMgrCopy = new BLiqSenAlmTable();
        for (int i = 0; i < valuesCopy.length; ++i) {
            try {
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                String newValue = valuesCopy[i].createCommaDelimitedString();
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + newValue);
                }
                sv.setValue(newValue);
                this.readOk((BStatusValue)sv);
                this.getLiqSenAlmTable().add("liqSenAlmEntry?", (BValue)valuesCopy[i]);
                sendToCsMgrCopy.add("liqSenAlmEntry?", (BValue)((BLiqSenAlmEntry)valuesCopy[i].newCopy()));
                BLiqSenAlmHistoryRecord newrec = new BLiqSenAlmHistoryRecord(BAbsTime.make((long)System.currentTimeMillis()), valuesCopy[i]);
                TlsHistoryHelper.appendTlsHistory((BStruct)newrec);
                continue;
            }
            catch (Exception e) {
                this.readFail(e.toString());
            }
        }
        this.updateDemuxedProxyPoints();
        BLiqSenAlmEntry[] sortedValues = this.getLiqSenAlmTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        int numRemoveEntries = sortedValues.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350LiqSenAlmHisProxyExt setValue sortedValues.length=" + sortedValues.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (numRemoveEntries > 0) {
            Vector<BLiqSenAlmEntry> removeEntries = new Vector<BLiqSenAlmEntry>();
            for (int i = 0; i < numRemoveEntries; ++i) {
                removeEntries.addElement(sortedValues[i]);
            }
            Enumeration re = removeEntries.elements();
            while (re.hasMoreElements()) {
                BLiqSenAlmEntry oldestEntryCopy = (BLiqSenAlmEntry)((Object)re.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350LiqSenAlmHisProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + oldestEntryCopy.createCommaDelimitedString());
                }
                this.getLiqSenAlmTable().remove((BComplex)oldestEntryCopy);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, sendToCsMgrCopy));
    }

    private void updateDemuxedProxyPoints() {
        BLiqSenAlmEntry[] sortedValues = this.getLiqSenAlmTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        BLiqSenAlmEntry mostRecentValue = sortedValues[sortedValues.length - 1];
        String[] demuxedValueStrings = CsMgrBaseUtil.createStringArrayOfAllNames((String)mostRecentValue.createCommaDelimitedString());
        if (demuxedValueStrings != null && demuxedValueStrings.length > 0) {
            BControlPoint[] dCPA;
            BTls350LsaDemuxedPointDeviceExt lsaExt = null;
            BDeviceExt[] exts = this.getDevice().getDeviceExts();
            for (int k = 0; k < exts.length; ++k) {
                if (!(exts[k] instanceof BTls350LsaDemuxedPointDeviceExt)) continue;
                lsaExt = (BTls350LsaDemuxedPointDeviceExt)exts[k];
                break;
            }
            if (lsaExt != null && (dCPA = lsaExt.getPoints()) != null && dCPA.length > 0) {
                for (int k = 0; k < dCPA.length; ++k) {
                    if (dCPA[k].getProxyExt().getType() != BTls350DemuxedProxyExt.TYPE) continue;
                    ((BTls350DemuxedProxyExt)dCPA[k].getProxyExt()).updateValueFrom(demuxedValueStrings);
                }
            }
        }
    }

    @Override
    public void readDataNow() {
        this.pollForDataNow();
    }

    @Override
    public void clearDataNow() {
        this.getLiqSenAlmTable().lease(2);
        BLiqSenAlmEntry[] itse = (BLiqSenAlmEntry[])this.getLiqSenAlmTable().getChildren(BLiqSenAlmEntry.class);
        if (itse != null && itse.length > 0) {
            for (int i = 0; i < itse.length; ++i) {
                this.getLiqSenAlmTable().remove((BComplex)itse[i]);
            }
        }
        this.lSAHashtable = new Hashtable(20);
    }

    public void doPurgeHashtable(Context cx) throws Exception {
        this.purgeHashtableValuesFlag = true;
    }

    public void purgeOldHashtableValues() {
        Enumeration<Long> lSAkeys = this.lSAHashtable.keys();
        while (lSAkeys.hasMoreElements()) {
            Long nextKey = lSAkeys.nextElement();
            BLiqSenAlmEntry nextEntry = this.lSAHashtable.get(nextKey);
            BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
            if (!nextEntry.getReadTime().isBefore(previousTime)) continue;
            this.lSAHashtable.remove(nextKey);
        }
        this.reschedPurgeHashtable();
    }

    private void reschedPurgeHashtable() {
        this.purgeHashtableValuesFlag = false;
        if (this.purgeHashtableValuesTicket != null) {
            this.purgeHashtableValuesTicket.cancel();
        }
        BAbsTime nextChangeOfDay = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.MIDNIGHT);
        this.purgeHashtableValuesTicket = Clock.schedule((BComponent)this, (BAbsTime)nextChangeOfDay, (Action)purgeHashtable, null);
    }
}

