/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BFuelManagementEntry;
import com.tridium.tls.datatypes.BFuelManagementTable;
import com.tridium.tls.datatypes.BFuelMgmtHistoryRecord;
import com.tridium.tls.devices.BTls350FuelTankDevice;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.Tls350FuelManagementReport;
import com.tridium.tls.messages.Tls350FuelManagementReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350FmDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350FuelTankPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="minimumPollInterval", type="BRelTime", defaultValue="BRelTime.makeMinutes(30)"), @NiagaraProperty(name="fuelManagementTable", type="BFuelManagementTable", defaultValue="new BFuelManagementTable()"), @NiagaraProperty(name="maxOldEntriesSaved", type="int", defaultValue="8", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")})})
@NiagaraAction(name="purgeHashtable", flags=4)
public class BTls350FuelMgmtProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    @Generated
    public static final Property minimumPollInterval = BTls350FuelMgmtProxyExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)30), null);
    @Generated
    public static final Property fuelManagementTable = BTls350FuelMgmtProxyExt.newProperty((int)0, (BValue)new BFuelManagementTable(), null);
    @Generated
    public static final Property maxOldEntriesSaved = BTls350FuelMgmtProxyExt.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Action purgeHashtable = BTls350FuelMgmtProxyExt.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTls350FuelMgmtProxyExt.class);
    private Vector<BFuelManagementEntry> fMEntriesVector;
    private Hashtable<Long, BFuelManagementEntry> fMHashtable;
    private Clock.Ticket purgeHashtableValuesTicket;
    private boolean purgeHashtableValuesFlag;

    @Generated
    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    @Generated
    public void setMinimumPollInterval(BRelTime v) {
        this.set(minimumPollInterval, (BValue)v, null);
    }

    @Generated
    public BFuelManagementTable getFuelManagementTable() {
        return (BFuelManagementTable)this.get(fuelManagementTable);
    }

    @Generated
    public void setFuelManagementTable(BFuelManagementTable v) {
        this.set(fuelManagementTable, (BValue)v, null);
    }

    @Generated
    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    @Generated
    public void setMaxOldEntriesSaved(int v) {
        this.setInt(maxOldEntriesSaved, v, null);
    }

    @Generated
    public void purgeHashtable() {
        this.invoke(purgeHashtable, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getDeviceExtType() {
        return BTls350FuelTankPointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BFuelManagementEntry[] saved = this.getFuelManagementTable().getEntries();
            this.fMHashtable = new Hashtable(saved.length * 2);
            for (int i = 0; i < saved.length; ++i) {
                Long key = saved[i].getHTKey();
                this.fMHashtable.put(key, saved[i]);
            }
            TlsHistoryHelper.initHistory(BFuelMgmtHistoryRecord.TYPE);
            this.reschedPurgeHashtable();
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        this.fMHashtable = null;
        super.stopped();
    }

    @Override
    public void poll() {
        if (!(this.getDevice().getEnabled() && this.getEnabled() && this.pollIntervalCheck(this.getMinimumPollInterval().getMillis()))) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        boolean pollDebug = this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1;
        int tankNumber = ((BTls350FuelTankDevice)this.device()).getTankNumber();
        Tls350FuelManagementReport req = new Tls350FuelManagementReport(tankNumber, this);
        Tls350FuelManagementReportResponse rsp = (Tls350FuelManagementReportResponse)this.network().sendSync(req);
        if (rsp != null) {
            if (rsp.getSuccessfulResponse()) {
                this.device().setPollSinceLastPingFlag();
                Tls350FuelManagementReportResponse.FuelManagement[] entries = rsp.getFuelManagementEntries();
                if (entries == null || entries.length <= 0) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit... response has no entries");
                    }
                    return;
                }
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow continue... process " + entries.length + " entries");
                }
                if (tankNumber == 0) {
                    System.out.println(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! proxy point's tank number not initialized... initialize tank number to valid tank\n\n");
                    return;
                }
                if (tankNumber != entries[0].getTankNumber()) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! poll response with entries has wrong tank number... entry for tankNumber=" + entries[0].getTankNumber() + " may be lost\n\n");
                    }
                    return;
                }
                this.fMEntriesVector = new Vector();
                boolean newEntryDetected = false;
                for (int i = entries.length - 1; i > -1; --i) {
                    BFuelManagementEntry newFmEntry = new BFuelManagementEntry();
                    newFmEntry.setStore(Sys.getStation().getStationName());
                    newFmEntry.setTank(tankNumber);
                    newFmEntry.setCurrentDateTime(entries[i].getCurrentDateTime());
                    newFmEntry.setProductCode(entries[i].getProductCode());
                    newFmEntry.setDaysRemaining(entries[i].getDaysRemaining());
                    newFmEntry.setPresentInventory(entries[i].getPresentInventory());
                    newFmEntry.setPresentUllage(entries[i].getPresentUllage());
                    newFmEntry.setSundaySales(entries[i].getSundaySales());
                    newFmEntry.setMondaySales(entries[i].getMondaySales());
                    newFmEntry.setTuesdaySales(entries[i].getTuesdaySales());
                    newFmEntry.setWednesdaySales(entries[i].getWednesdaySales());
                    newFmEntry.setThursdaySales(entries[i].getThursdaySales());
                    newFmEntry.setFridaySales(entries[i].getFridaySales());
                    newFmEntry.setSaturdaySales(entries[i].getSaturdaySales());
                    BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
                    if (newFmEntry.getCurrentDateTime().isBefore(previousTime)) {
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newFmEntry.createCommaDelimitedString() + " for " + this.getName());
                        continue;
                    }
                    Long newHtKey = newFmEntry.getHTKey();
                    if (this.fMHashtable == null || this.fMHashtable.get(newHtKey) == null || newEntryDetected) {
                        this.fMHashtable.put(newHtKey, newFmEntry);
                        this.fMEntriesVector.addElement(newFmEntry);
                        newEntryDetected = true;
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow add... new entry = " + newFmEntry.createCommaDelimitedString() + " for " + this.getName());
                        continue;
                    }
                    if (!pollDebug) continue;
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newFmEntry.createCommaDelimitedString() + " for " + this.getName());
                }
                if (this.fMEntriesVector.size() > 0) {
                    this.setValue(this.fMEntriesVector);
                    return;
                }
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)sv);
                this.updateDemuxedProxyPoints();
            } else {
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response");
            }
        } else {
            if (pollDebug) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("No Response");
            this.device().ping();
        }
        if (this.purgeHashtableValuesFlag) {
            this.purgeOldHashtableValues();
        }
    }

    public void setValue(Vector<BFuelManagementEntry> values) {
        BFuelManagementEntry[] valuesCopy = new BFuelManagementEntry[values.size()];
        values.copyInto((Object[])valuesCopy);
        BFuelManagementTable sendToCsMgrCopy = new BFuelManagementTable();
        for (int i = 0; i < valuesCopy.length; ++i) {
            try {
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                String newValue = valuesCopy[i].createCommaDelimitedString();
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + newValue);
                }
                sv.setValue(newValue);
                this.readOk((BStatusValue)sv);
                this.getFuelManagementTable().add("fuelManagementEntry?", (BValue)valuesCopy[i]);
                sendToCsMgrCopy.add("fuelManagementEntry?", (BValue)((BFuelManagementEntry)valuesCopy[i].newCopy()));
                BFuelMgmtHistoryRecord newrec = new BFuelMgmtHistoryRecord(BAbsTime.make((long)System.currentTimeMillis()), valuesCopy[i]);
                TlsHistoryHelper.appendTlsHistory((BStruct)newrec);
                continue;
            }
            catch (Exception e) {
                this.readFail(e.toString());
            }
        }
        this.updateDemuxedProxyPoints();
        BFuelManagementEntry[] sortedValues = this.getFuelManagementTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        int numRemoveEntries = sortedValues.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350FuelMgmtProxyExt setValue sortedValues.length=" + sortedValues.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (numRemoveEntries > 0) {
            Vector<BFuelManagementEntry> removeEntries = new Vector<BFuelManagementEntry>();
            for (int i = 0; i < numRemoveEntries; ++i) {
                removeEntries.addElement(sortedValues[i]);
            }
            Enumeration re = removeEntries.elements();
            while (re.hasMoreElements()) {
                BFuelManagementEntry oldestEntryCopy = (BFuelManagementEntry)((Object)re.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350FuelMgmtProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + oldestEntryCopy.createCommaDelimitedString());
                }
                this.getFuelManagementTable().remove((BComplex)oldestEntryCopy);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, sendToCsMgrCopy));
    }

    private void updateDemuxedProxyPoints() {
        BFuelManagementEntry[] sortedValues = this.getFuelManagementTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        BFuelManagementEntry mostRecentValue = sortedValues[sortedValues.length - 1];
        String[] demuxedValueStrings = CsMgrBaseUtil.createStringArrayOfAllNames((String)mostRecentValue.createCommaDelimitedString());
        if (demuxedValueStrings != null && demuxedValueStrings.length > 0) {
            BControlPoint[] dCPA;
            BTls350FmDemuxedPointDeviceExt fmdExt = null;
            BDeviceExt[] exts = this.getDevice().getDeviceExts();
            for (int k = 0; k < exts.length; ++k) {
                if (!(exts[k] instanceof BTls350FmDemuxedPointDeviceExt)) continue;
                fmdExt = (BTls350FmDemuxedPointDeviceExt)exts[k];
                break;
            }
            if (fmdExt != null && (dCPA = fmdExt.getPoints()) != null && dCPA.length > 0) {
                for (int k = 0; k < dCPA.length; ++k) {
                    if (dCPA[k].getProxyExt().getType() != BTls350DemuxedProxyExt.TYPE) continue;
                    ((BTls350DemuxedProxyExt)dCPA[k].getProxyExt()).updateValueFrom(demuxedValueStrings);
                }
            }
        }
    }

    @Override
    public void readDataNow() {
        this.pollForDataNow();
    }

    @Override
    public void clearDataNow() {
        this.getFuelManagementTable().lease(2);
        BFuelManagementEntry[] fme = (BFuelManagementEntry[])this.getFuelManagementTable().getChildren(BFuelManagementEntry.class);
        if (fme != null && fme.length > 0) {
            for (int i = 0; i < fme.length; ++i) {
                this.getFuelManagementTable().remove((BComplex)fme[i]);
            }
        }
        this.fMHashtable = new Hashtable(20);
    }

    public void doPurgeHashtable(Context cx) throws Exception {
        this.purgeHashtableValuesFlag = true;
    }

    public void purgeOldHashtableValues() {
        Enumeration<Long> fMkeys = this.fMHashtable.keys();
        while (fMkeys.hasMoreElements()) {
            Long nextKey = fMkeys.nextElement();
            BFuelManagementEntry nextEntry = this.fMHashtable.get(nextKey);
            BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
            if (!nextEntry.getCurrentDateTime().isBefore(previousTime)) continue;
            this.fMHashtable.remove(nextKey);
        }
        this.reschedPurgeHashtable();
    }

    private void reschedPurgeHashtable() {
        this.purgeHashtableValuesFlag = false;
        if (this.purgeHashtableValuesTicket != null) {
            this.purgeHashtableValuesTicket.cancel();
        }
        BAbsTime nextChangeOfDay = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.MIDNIGHT);
        this.purgeHashtableValuesTicket = Clock.schedule((BComponent)this, (BAbsTime)nextChangeOfDay, (Action)purgeHashtable, null);
    }
}

