/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.TlsMessageConst;
import java.io.ByteArrayOutputStream;

public class TlsOutputStream
extends ByteArrayOutputStream
implements TlsMessageConst {
    public void writeFloat(float fValue) {
        int nValue = Float.floatToIntBits(fValue);
        this.write((byte)(nValue & 0xFF));
        this.write((byte)(nValue >> 8 & 0xFF));
        this.write((byte)(nValue >> 16 & 0xFF));
        this.write((byte)(nValue >> 24 & 0xFF));
    }

    public void writeInt(int i) {
        this.write(i & 0xFF);
        this.write(i >> 8 & 0xFF);
    }

    public void writeInt(int i, int size) {
        switch (size) {
            case 4: {
                this.write(i & 0xFF);
                this.write(i >> 8 & 0xFF);
                this.write(i >> 16 & 0xFF);
                this.write(i >> 24 & 0xFF);
                break;
            }
            case 3: {
                this.write(i & 0xFF);
                this.write(i >> 8 & 0xFF);
                this.write(i >> 16 & 0xFF);
                break;
            }
            case 2: {
                this.write(i & 0xFF);
                this.write(i >> 8 & 0xFF);
            }
        }
    }

    public void writeInt(byte i) {
        this.write(i);
    }

    @Override
    public void write(byte[] byteArray) {
        this.write(byteArray, 0, byteArray.length);
    }

    public void write(byte[] byteArray, int count) {
        int copyCnt;
        this.write(byteArray, 0, copyCnt);
        for (copyCnt = byteArray.length > count ? count : byteArray.length; copyCnt < count; ++copyCnt) {
            this.write(0);
        }
    }

    public void writeString(String s, int maxLen) {
        byte[] a = s.getBytes();
        int len = a.length > --maxLen ? maxLen : a.length;
        this.write(a, len);
        if (maxLen > len) {
            this.pad(maxLen - len);
        }
        this.write(0);
    }

    public void pad(int len) {
        for (int i = 0; i < len; ++i) {
            this.write(0);
        }
    }

    public int getCount() {
        return this.count;
    }

    public int writeCrc() {
        int checksum = 0;
        this.write(checksum & 0xFF);
        this.write((checksum & 0xFF00) >> 8);
        return checksum;
    }

    public void writeCksum() {
    }

    public void writeAsciiInt(int value, int size) {
        String vs = "0000000000" + value;
        for (int i = vs.length() - size; i < vs.length(); ++i) {
            this.write(vs.charAt(i) & 0xFF);
        }
    }

    public void writeString(String s) {
        this.write(s.getBytes());
    }
}

