/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.job;

import com.tridium.tls.BTlsConsole;
import com.tridium.tls.BTlsDevice;
import com.tridium.tls.TlsConstants;
import com.tridium.tls.datatypes.BFuelDataUpdateParams;
import com.tridium.tls.point.BTls350StringProxyExt;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BTlsReportToCsMgrJob
extends BJob
implements TlsConstants,
Runnable {
    @Generated
    public static final Type TYPE = Sys.loadType(BTlsReportToCsMgrJob.class);
    private BTls350StringProxyExt proxy;
    private BTlsDevice device;
    private BTlsConsole network;
    private BComponent component;
    private boolean debug;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTlsReportToCsMgrJob() {
    }

    public BTlsReportToCsMgrJob(BTls350StringProxyExt prx, BComponent comp) {
        this.proxy = prx;
        this.component = comp;
        this.device = this.proxy.device();
        this.network = this.device.network();
        this.debug = this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("csmgr") != -1;
    }

    public void doRun(Context cx) {
        this.network.dispatch(this);
    }

    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    @Override
    public void run() {
        if (this.debug) {
            this.network.getLog().trace("TlsReportToCsMgrJob... run... entry point");
        }
        BFuelDataUpdateParams eUpdate = new BFuelDataUpdateParams();
        eUpdate.setStationName(Sys.getStation().getStationName());
        eUpdate.setUpdateList(this.component);
        try {
            this.network.sendFuelDataUpdate(eUpdate);
        }
        catch (Throwable t) {
            this.network.getLog().error("TlsReportToCsMgrJob exiting... exception=" + t);
            t.printStackTrace();
        }
    }
}

