/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.point;

import com.tridium.ndio.BNdioBoard;
import com.tridium.ndio.BNdioNetwork;
import com.tridium.ndio.NdioConstants;
import com.tridium.ndio.enums.BNdioIoTypeEnum;
import com.tridium.ndio.enums.BNdioPointTypeEnum;
import com.tridium.ndio.point.BNdioPointDeviceExt;
import com.tridium.platNdio.NdioPlatformServiceConstants;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="conversion", type="BProxyConversion", defaultValue="BDefaultProxyConversion.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"ndio:NdioProxyConversionFE\"))")}, override=true), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="pointType", type="BNdioPointTypeEnum", defaultValue="BNdioPointTypeEnum.counterInput"), @NiagaraProperty(name="address", type="int", defaultValue="0"), @NiagaraProperty(name="previousAddress", type="int", defaultValue="0", flags=71), @NiagaraProperty(name="synced", type="boolean", defaultValue="false", flags=67), @NiagaraProperty(name="raw", type="long", defaultValue="0", flags=67)})
public abstract class BNdioProxyExt
extends BProxyExt
implements BIPollable,
NdioConstants,
NdioPlatformServiceConstants {
    @Generated
    public static final Property conversion = BNdioProxyExt.newProperty((int)0, (BValue)BDefaultProxyConversion.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"ndio:NdioProxyConversionFE")));
    @Generated
    public static final Property pollFrequency = BNdioProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property pointType = BNdioProxyExt.newProperty((int)0, (BValue)BNdioPointTypeEnum.counterInput, null);
    @Generated
    public static final Property address = BNdioProxyExt.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property previousAddress = BNdioProxyExt.newProperty((int)71, (int)0, null);
    @Generated
    public static final Property synced = BNdioProxyExt.newProperty((int)67, (boolean)false, null);
    @Generated
    public static final Property raw = BNdioProxyExt.newProperty((int)67, (int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNdioProxyExt.class);
    protected static final Log log = Log.getLog((String)"ndio");
    private boolean configFault = true;

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public BNdioPointTypeEnum getPointType() {
        return (BNdioPointTypeEnum)this.get(pointType);
    }

    @Generated
    public void setPointType(BNdioPointTypeEnum v) {
        this.set(pointType, (BValue)v, null);
    }

    @Generated
    public int getAddress() {
        return this.getInt(address);
    }

    @Generated
    public void setAddress(int v) {
        this.setInt(address, v, null);
    }

    @Generated
    public int getPreviousAddress() {
        return this.getInt(previousAddress);
    }

    @Generated
    public void setPreviousAddress(int v) {
        this.setInt(previousAddress, v, null);
    }

    @Generated
    public boolean getSynced() {
        return this.getBoolean(synced);
    }

    @Generated
    public void setSynced(boolean v) {
        this.setBoolean(synced, v, null);
    }

    @Generated
    public long getRaw() {
        return this.getLong(raw);
    }

    @Generated
    public void setRaw(long v) {
        this.setLong(raw, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getParentPoint() != null) {
            this.getNdioPointDeviceExt().handlePointChanged(this.getParentPoint());
        }
        this.setPreviousAddress(this.getAddress());
    }

    public void readSubscribed(Context cx) throws Exception {
        BNdioNetwork network = this.getNdioNetwork();
        network.getPollScheduler().subscribe(this);
    }

    public void readUnsubscribed(Context cx) throws Exception {
        BNdioNetwork network = this.getNdioNetwork();
        network.getPollScheduler().unsubscribe(this);
    }

    public boolean isParentLegal(BComponent parent) {
        if (parent instanceof BControlPoint) {
            return parent.getParent() instanceof BNdioPointDeviceExt;
        }
        return false;
    }

    public Type getDeviceExtType() {
        return BNdioPointDeviceExt.TYPE;
    }

    protected BNdioBoard getBoard() {
        return (BNdioBoard)this.getDevice();
    }

    protected BNdioNetwork getNdioNetwork() {
        return (BNdioNetwork)this.getNetwork();
    }

    protected BNdioPointDeviceExt getNdioPointDeviceExt() {
        return (BNdioPointDeviceExt)this.getDeviceExt();
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.isRunning() && prop.equals(address) && this.getParentPoint() != null) {
            this.getNdioPointDeviceExt().handlePointChanged(this.getParentPoint());
            this.setPreviousAddress(this.getAddress());
            if (!this.isConfigFault()) {
                this.read();
            }
        }
    }

    public abstract void read();

    public boolean write(Context cx) {
        return false;
    }

    public void configFail(String cause) {
        this.setSynced(false);
        this.configFault = true;
        this.readFail(cause);
    }

    public void configOk() {
        this.configFault = false;
        this.readReset();
    }

    public boolean isConfigFault() {
        return this.configFault;
    }

    public abstract BNdioIoTypeEnum getIoType();

    protected boolean pointSynchronized() {
        if (!this.getNdioNetwork().isKeepAliveStarted()) {
            return false;
        }
        if (this.getBoard().isDown()) {
            return false;
        }
        if (this.getBoard().isFault()) {
            return false;
        }
        if (this.isFatalFault()) {
            return false;
        }
        if (this.isConfigFault()) {
            return false;
        }
        if (this.getSynced()) {
            return true;
        }
        this.setSynced(true);
        return true;
    }
}

