/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.point;

import com.tridium.ndio.point.BNdioOutputProxyExt;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="overridden", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="faultEnable", type="boolean", defaultValue="true"), @NiagaraProperty(name="alarmEnable", type="boolean", defaultValue="false"), @NiagaraProperty(name="alarmClass", type="String", defaultValue="defaultAlarmClass", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"alarm:AlarmClassFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"alarm:AlarmClassEditor\"))")})})
@NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)
public class BNdioHardwareOverride
extends BComponent
implements BIAlarmSource {
    @Generated
    public static final Property overridden = BNdioHardwareOverride.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property faultEnable = BNdioHardwareOverride.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property alarmEnable = BNdioHardwareOverride.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property alarmClass = BNdioHardwareOverride.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor")));
    @Generated
    public static final Action ackAlarm = BNdioHardwareOverride.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNdioHardwareOverride.class);
    protected static final Log log = Log.getLog((String)"ndio");
    private AlarmSupport alarmSupport;
    private boolean inAlarm = false;
    private boolean haveUnackedAlarm = false;

    @Generated
    public boolean getOverridden() {
        return this.getBoolean(overridden);
    }

    @Generated
    public void setOverridden(boolean v) {
        this.setBoolean(overridden, v, null);
    }

    @Generated
    public boolean getFaultEnable() {
        return this.getBoolean(faultEnable);
    }

    @Generated
    public void setFaultEnable(boolean v) {
        this.setBoolean(faultEnable, v, null);
    }

    @Generated
    public boolean getAlarmEnable() {
        return this.getBoolean(alarmEnable);
    }

    @Generated
    public void setAlarmEnable(boolean v) {
        this.setBoolean(alarmEnable, v, null);
    }

    @Generated
    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    @Generated
    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmClass());
    }

    public void stopped() {
        this.alarmSupport = null;
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.isRunning()) {
            if (prop.equals(alarmClass)) {
                this.alarmSupport.setAlarmClass(this.getAlarmClass());
            }
            if (prop.equals(alarmEnable)) {
                BNdioOutputProxyExt ext;
                if (this.inAlarm) {
                    try {
                        this.alarmSupport.toNormal(null);
                        this.inAlarm = false;
                    }
                    catch (Exception e) {
                        log.error("Unable to clear alarm", (Throwable)e);
                    }
                }
                if ((ext = (BNdioOutputProxyExt)this.getParent()) != null) {
                    ext.checkPointSubscription();
                }
            }
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return super.isParentLegal(parent) && parent instanceof BNdioOutputProxyExt;
    }

    public synchronized void evaluate(BStatusValue out, boolean overridden) {
        if (!this.haveUnackedAlarm) {
            out.setStatusUnackedAlarm(false);
        }
        this.setOverridden(overridden);
        boolean isWorkingVariableOverridden = out.getStatus().isOverridden();
        boolean isWorkingVariableFault = out.getStatus().isFault();
        boolean isWorkingVariableAlarm = out.getStatus().isAlarm();
        boolean isWorkingVariableUnackedAlarm = out.getStatus().isUnackedAlarm();
        if (overridden) {
            out.setStatusOverridden(true);
            if (this.getFaultEnable()) {
                out.setStatusFault(true);
            }
            if (this.getAlarmEnable()) {
                out.setStatusInAlarm(true);
                if (!this.inAlarm) {
                    try {
                        BFacets facets = BFacets.make((String)"msgText", (BIDataValue)BString.make((String)"ndio hardware override activated"), (String)"sourceName", (BIDataValue)BString.make((String)this.getParent().getParent().getName()));
                        if (this.getFaultEnable()) {
                            this.alarmSupport.newFaultAlarm(facets);
                            if (this.alarmSupport.isAckRequired(BSourceState.fault)) {
                                this.haveUnackedAlarm = true;
                            }
                        } else {
                            this.alarmSupport.newOffnormalAlarm(facets);
                            if (this.alarmSupport.isAckRequired(BSourceState.offnormal)) {
                                this.haveUnackedAlarm = true;
                            }
                        }
                        this.inAlarm = true;
                    }
                    catch (Exception e) {
                        log.error("Unable to generate alarm", (Throwable)e);
                    }
                }
            }
        } else {
            out.setStatusFault(isWorkingVariableFault);
            out.setStatusInAlarm(isWorkingVariableAlarm);
            out.setStatusOverridden(isWorkingVariableOverridden);
            out.setStatusUnackedAlarm(isWorkingVariableUnackedAlarm);
            if (this.inAlarm) {
                try {
                    this.alarmSupport.toNormal(null);
                    this.inAlarm = false;
                }
                catch (Exception e) {
                    log.error("Unable to clear alarm", (Throwable)e);
                }
            }
        }
        if (this.haveUnackedAlarm) {
            out.setStatusUnackedAlarm(true);
        }
    }

    public synchronized BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        try {
            boolean val = this.alarmSupport.ackAlarm(ackRequest);
            if (val) {
                this.haveUnackedAlarm = false;
            }
            return BBoolean.make((boolean)val);
        }
        catch (Exception e) {
            return BBoolean.FALSE;
        }
    }
}

