/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.util;

import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.OrionInput;
import com.tridium.orion.priv.fox.OrionOutput;
import com.tridium.orion.priv.model.DynamicOrionProperty;
import com.tridium.orion.priv.model.DynamicOrionType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BOrionTypeDef
extends BSimple {
    public static final BOrionTypeDef NULL;
    public static final BOrionTypeDef DEFAULT;
    public static final Type TYPE;
    private BOrionTypeId typeId = BOrionTypeId.NULL;
    private DynamicOrionType dtype = null;

    private BOrionTypeDef() {
        this.typeId = BOrionTypeId.NULL;
    }

    private BOrionTypeDef(BOrionTypeId typeId) {
        this.typeId = typeId;
    }

    private BOrionTypeDef(DynamicOrionType type) {
        this.typeId = type.getOrionTypeId();
        this.dtype = type;
    }

    public static BOrionTypeDef make(BOrionTypeId typeId) {
        if (typeId == null || typeId.isNull()) {
            return NULL;
        }
        return new BOrionTypeDef(typeId);
    }

    public static BOrionTypeDef make(OrionType type) {
        if (type instanceof DynamicOrionType) {
            return new BOrionTypeDef((DynamicOrionType)type);
        }
        return BOrionTypeDef.make(type.getOrionTypeId());
    }

    public BOrionTypeId getOrionTypeId() {
        return this.typeId;
    }

    public OrionType getDynamicType() {
        return this.dtype;
    }

    public void encode(DataOutput out) throws IOException {
        this.typeId.encode(out);
        if (this.typeId.isDynamic()) {
            out.writeUTF(this.encodeTypeToString(this.dtype));
        }
    }

    public BObject decode(DataInput in) throws IOException {
        try {
            BOrionTypeId typeId = (BOrionTypeId)BOrionTypeId.DEFAULT.decode(in);
            if (!typeId.isDynamic()) {
                return BOrionTypeDef.make(typeId);
            }
            OrionType type = this.decodeTypeFromString(in.readUTF());
            return BOrionTypeDef.make(type);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new OrionException("Encoding failed.", ex);
        }
    }

    public String encodeToString() throws IOException {
        StringBuilder s = new StringBuilder(256);
        s.append(this.typeId.encodeToString());
        if (this.typeId.isDynamic()) {
            s.append(';');
            s.append(this.encodeTypeToString(this.dtype));
        }
        return s.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        int semi = s.indexOf(59);
        if (semi == -1) {
            return BOrionTypeDef.make((BOrionTypeId)BOrionTypeId.DEFAULT.decodeFromString(s));
        }
        BOrionTypeId typeId = (BOrionTypeId)BOrionTypeId.DEFAULT.decodeFromString(s.substring(0, semi));
        OrionType type = this.decodeTypeFromString(s.substring(semi + 1));
        return BOrionTypeDef.make(type);
    }

    public String encodeTypeToString(OrionType type) throws IOException {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(512);
            OrionOutput out = new OrionOutput(bOut, null);
            out.writeType(type);
            out.flush();
            return new String(bOut.toByteArray());
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new OrionException("Encoding failed.", ex);
        }
    }

    public OrionType decodeTypeFromString(String s) throws IOException {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(s.getBytes("utf-8"));
            OrionInput in = new OrionInput(bIn, null);
            OrionType type = in.readType();
            return type;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new OrionException("Encoding failed.", ex);
        }
    }

    public boolean equals(Object o) {
        return this.typeId.equals(o);
    }

    public int hashCode() {
        return this.typeId.hashCode();
    }

    public static Builder makeTypeBuilder(BOrionTypeId typeId) {
        if (!typeId.isDynamic()) {
            throw new OrionException("Cannot build a static type.");
        }
        return new Builder(typeId);
    }

    public Type getType() {
        return TYPE;
    }

    public static void main(String[] args) {
        try {
            Builder b = BOrionTypeDef.makeTypeBuilder(BOrionTypeId.TEMPORARY);
            b.addProperty("a", BInteger.TYPE, (BValue)BInteger.DEFAULT);
            b.addProperty("b", BInteger.TYPE, (BValue)BInteger.DEFAULT);
            b.addProperty("c", BInteger.TYPE, (BValue)BInteger.DEFAULT);
            BOrionTypeDef td = b.makeTypeDef();
            System.out.println("1 " + (Object)((Object)td));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(1024);
            DataOutputStream dOut = new DataOutputStream(bOut);
            td.encode(dOut);
            ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
            DataInputStream dIn = new DataInputStream(bIn);
            BOrionTypeDef td2 = (BOrionTypeDef)DEFAULT.decode(dIn);
            System.out.println("2 " + (Object)((Object)td2));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        DEFAULT = NULL = new BOrionTypeDef();
        TYPE = Sys.loadType(BOrionTypeDef.class);
    }

    public static class Builder {
        private BOrionTypeId typeId;
        private Array<Property> props = new Array(Property.class);

        public Builder(BOrionTypeId typeId) {
            this.typeId = typeId;
        }

        public BOrionTypeId getTypeId() {
            return this.typeId;
        }

        public void addProperty(Property newProp) {
            this.props.add((Object)new DynamicOrionProperty(newProp));
        }

        public void addProperty(String name, Type type, BValue def) {
            this.addProperty(name, type, def, BFacets.NULL, 0);
        }

        public void addProperty(String name, Type type, BValue def, BFacets facets, int flags) {
            this.props.add((Object)new DynamicOrionProperty(name, type, def, facets, flags));
        }

        public BOrionTypeDef makeTypeDef() {
            return BOrionTypeDef.make(new DynamicOrionType(this.typeId, BOrionTypeId.NULL, 2, (Property[])this.props.trim()));
        }
    }
}

