/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.securityAudit;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.BSecurityAuditMode;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridium.orion.priv.audit.BOrionAuditType;
import com.tridium.sys.Nre;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.SecurityAuditEvent;
import javax.baja.security.SecurityAuditor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraOrionType
@NiagaraProperties(value={@NiagaraProperty(name="id", type="int", defaultValue="0", facets={@Facet(value="ID_KEY")}), @NiagaraProperty(name="timestamp", type="BAbsTime", defaultValue="BAbsTime.NULL"), @NiagaraProperty(name="userName", type="String", defaultValue="", facets={@Facet(name="INDEXED", value="true"), @Facet(name="WIDTH", value="64")}), @NiagaraProperty(name="objectTypeSpec", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT", facets={@Facet(name="WIDTH", value="64")}), @NiagaraProperty(name="objectDisplay", type="String", defaultValue="", facets={@Facet(name="WIDTH", value="512")}), @NiagaraProperty(name="auditType", type="BOrionAuditType", defaultValue="BOrionAuditType.unspecified"), @NiagaraProperty(name="message", type="String", defaultValue="", facets={@Facet(name="WIDTH", value="512")})})
public class BOrionSecurityAudit
extends BOrionObject {
    @Generated
    public static final Property id = BOrionSecurityAudit.newProperty((int)0, (int)0, (BFacets)ID_KEY);
    @Generated
    public static final Property timestamp = BOrionSecurityAudit.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property userName = BOrionSecurityAudit.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"indexed", (boolean)true), (BFacets)BFacets.make((String)"width", (int)64)));
    @Generated
    public static final Property objectTypeSpec = BOrionSecurityAudit.newProperty((int)0, (BValue)BTypeSpec.DEFAULT, (BFacets)BFacets.make((String)"width", (int)64));
    @Generated
    public static final Property objectDisplay = BOrionSecurityAudit.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)512));
    @Generated
    public static final Property auditType = BOrionSecurityAudit.newProperty((int)0, (BValue)BOrionAuditType.unspecified, null);
    @Generated
    public static final Property message = BOrionSecurityAudit.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)512));
    @Generated
    public static final Type TYPE = Sys.loadType(BOrionSecurityAudit.class);
    @Generated
    public static final OrionType ORION_TYPE = (OrionType)TYPE;

    @Generated
    public int getId() {
        return this.getInt(id);
    }

    @Generated
    public void setId(int v) {
        this.setInt(id, v, null);
    }

    @Generated
    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    @Generated
    public void setTimestamp(BAbsTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    @Generated
    public String getUserName() {
        return this.getString(userName);
    }

    @Generated
    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    @Generated
    public BTypeSpec getObjectTypeSpec() {
        return (BTypeSpec)this.get(objectTypeSpec);
    }

    @Generated
    public void setObjectTypeSpec(BTypeSpec v) {
        this.set(objectTypeSpec, (BValue)v, null);
    }

    @Generated
    public String getObjectDisplay() {
        return this.getString(objectDisplay);
    }

    @Generated
    public void setObjectDisplay(String v) {
        this.setString(objectDisplay, v, null);
    }

    @Generated
    public BOrionAuditType getAuditType() {
        return (BOrionAuditType)this.get(auditType);
    }

    @Generated
    public void setAuditType(BOrionAuditType v) {
        this.set(auditType, (BValue)v, null);
    }

    @Generated
    public String getMessage() {
        return this.getString(message);
    }

    @Generated
    public void setMessage(String v) {
        this.setString(message, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public static void securityAuditCreated(BIOrionObject obj, String username, BSecurityAuditMode mode, OrionSession session) {
        SecurityAuditor securityAuditor;
        String message = BOrionSecurityAudit.makeAuditMessage(obj, null, BOrionAuditType.created, session);
        if (mode.equals((Object)BSecurityAuditMode.securityEventAndDatabaseRecord) || mode.equals((Object)BSecurityAuditMode.databaseRecord)) {
            BOrionSecurityAudit secRec = BOrionSecurityAudit.makeSecurityAuditRecord(username, obj, session);
            secRec.setAuditType(BOrionAuditType.created);
            secRec.setMessage(message);
            session.insert(secRec);
        }
        if ((mode.equals((Object)BSecurityAuditMode.securityEventAndDatabaseRecord) || mode.equals((Object)BSecurityAuditMode.securityEvent)) && (securityAuditor = Nre.getSecurityAuditor()) != null) {
            securityAuditor.audit(BOrionSecurityAudit.makeSecurityAuditEvent("Added".toString(), username, message));
        }
    }

    public static void securityAuditDeleted(BIOrionObject obj, String username, BSecurityAuditMode mode, OrionSession session) {
        SecurityAuditor securityAuditor;
        String message = BOrionSecurityAudit.makeAuditMessage(obj, null, BOrionAuditType.deleted, session);
        if (mode.equals((Object)BSecurityAuditMode.securityEventAndDatabaseRecord) || mode.equals((Object)BSecurityAuditMode.databaseRecord)) {
            BOrionSecurityAudit secRec = BOrionSecurityAudit.makeSecurityAuditRecord(username, obj, session);
            secRec.setAuditType(BOrionAuditType.deleted);
            secRec.setMessage(message);
            session.insert(secRec);
        }
        if ((mode.equals((Object)BSecurityAuditMode.securityEventAndDatabaseRecord) || mode.equals((Object)BSecurityAuditMode.securityEvent)) && (securityAuditor = Nre.getSecurityAuditor()) != null) {
            securityAuditor.audit(BOrionSecurityAudit.makeSecurityAuditEvent("Removed".toString(), username, message));
        }
    }

    public static void securityAuditModified(BIOrionObject obj, Property property, String username, BSecurityAuditMode mode, OrionSession session) {
        SecurityAuditor securityAuditor;
        String message = BOrionSecurityAudit.makeAuditMessage(obj, property, BOrionAuditType.modified, session);
        if (mode.equals((Object)BSecurityAuditMode.securityEventAndDatabaseRecord) || mode.equals((Object)BSecurityAuditMode.databaseRecord)) {
            BOrionSecurityAudit secRec = BOrionSecurityAudit.makeSecurityAuditRecord(username, obj, session);
            secRec.setAuditType(BOrionAuditType.modified);
            secRec.setMessage(message);
            session.insert(secRec);
        }
        if ((mode.equals((Object)BSecurityAuditMode.securityEventAndDatabaseRecord) || mode.equals((Object)BSecurityAuditMode.securityEvent)) && (securityAuditor = Nre.getSecurityAuditor()) != null) {
            securityAuditor.audit(BOrionSecurityAudit.makeSecurityAuditEvent("Changed".toString(), username, message));
        }
    }

    private static String makeRefString(BRef ref, OrionSession session) {
        BIOrionObject target = ref.getTarget(session);
        return target == null ? "null" : target.toDisplayString(session);
    }

    private static String makeAuditMessage(BIOrionObject obj, Property property, BOrionAuditType auditType, OrionSession session) {
        StringBuilder message = new StringBuilder();
        message.append("Orion ").append(obj.getOrionType().getDisplayName(null)).append("|").append(obj.toDisplayString(session));
        if (auditType.equals((Object)BOrionAuditType.modified)) {
            if (!BOrionObject.isSensitiveProperty(property)) {
                BValue oldValue = (BValue)((BObject)obj).fw(703, (Object)property, null, null, null);
                BValue newValue = obj.get(property);
                if (property.getType().equals(BRef.TYPE)) {
                    String msg = String.format("| Property %s changed from %s to %s", property.getName(), BOrionSecurityAudit.makeRefString((BRef)oldValue, session), BOrionSecurityAudit.makeRefString((BRef)newValue, session));
                    message.append(msg);
                } else {
                    String msg = String.format("| Property %s changed from %s to %s", property.getName(), oldValue.toString((Context)session), newValue.toString((Context)session));
                    message.append(msg);
                }
            } else {
                String msg = String.format("| Property %s has been changed", property.getName());
                message.append(msg);
            }
        }
        return message.toString();
    }

    private static BOrionSecurityAudit makeSecurityAuditRecord(String username, BIOrionObject obj, OrionSession session) {
        BOrionSecurityAudit rec = new BOrionSecurityAudit();
        rec.setTimestamp(BAbsTime.now());
        rec.setUserName(username);
        rec.setObjectTypeSpec(obj.getOrionType().getTypeSpec());
        rec.setObjectDisplay(obj.toDisplayString(session));
        return rec;
    }

    private static SecurityAuditEvent makeSecurityAuditEvent(String operation, String userName, String message) {
        SecurityAuditEvent event = new SecurityAuditEvent(operation, userName, message);
        return event;
    }

    @Override
    public final boolean isAuditable() {
        return false;
    }

    @Override
    public final boolean isSecurityAuditable() {
        return false;
    }
}

