/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.audit.BOrionAuditWorker;
import com.tridium.orion.priv.db.ColumnDefinition;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.SessionHelper;
import com.tridium.orion.priv.db.sql.SqlHelper;
import com.tridium.orion.priv.db.sql.SqlVisitor;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlUpdate;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.query.util.Exprs;
import javax.baja.sys.BComplex;
import javax.baja.sys.BSimple;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.util.BTypeSpec;

public class Update
extends SessionHelper {
    public Update(DbOrionSession session) {
        super(session);
    }

    public int update(BSqlUpdate update) {
        UpdateVisitor uv = new UpdateVisitor(this.db);
        uv.visit(update);
        this.logBQuery(uv);
        return this.updateOrDelete("UPDATE", uv.getQueryString(), uv.getParameters());
    }

    public void update(BIOrionObject obj) {
        this.update(obj, false);
    }

    public void update(BIOrionObject obj, boolean forceUpdate) {
        if (!this.canWrite(obj)) {
            return;
        }
        if (forceUpdate || this.needsUpdate(obj)) {
            if (obj.beforeUpdate(this.session)) {
                this.doUpdate(obj, forceUpdate);
                if (obj.isSecurityAuditable() && this.session.getUser() != null) {
                    Property[] props = obj.getOrionType().getProperties();
                    for (int i = 0; i < props.length; ++i) {
                        if (BOrionObject.isKey(props[i]) || !forceUpdate && !obj.isModified(props[i]) || Flags.isNoAudit((BComplex)((BComplex)obj), (Slot)props[i])) continue;
                        BOrionAuditWorker.securityAuditModified(obj, props[i], this.session);
                    }
                } else if (obj.isAuditable() && this.session.getUser() != null) {
                    Property[] props = obj.getOrionType().getProperties();
                    for (int i = 0; i < props.length; ++i) {
                        if (BOrionObject.isKey(props[i]) || !forceUpdate && !obj.isModified(props[i]) || Flags.isNoAudit((BComplex)((BComplex)obj), (Slot)props[i])) continue;
                        if (props[i].getFacets().getb("security", false)) {
                            BOrionAuditWorker.securityAuditModified(obj, props[i], this.session);
                            continue;
                        }
                        BOrionAuditWorker.auditModified(obj, props[i], this.session);
                    }
                }
                obj.clearAllModified();
                obj.afterUpdate(this.session);
            } else if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "VETOED UPDATE: " + obj);
            }
        }
    }

    private boolean needsUpdate(BIOrionObject obj) {
        OrionType type = obj.getOrionType();
        Property[] props = type.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (BOrionObject.isKey(props[i])) {
                if (!obj.isModified(props[i])) continue;
                throw new OrionException("Keys cannot be modified");
            }
            if (!obj.isModified(props[i])) continue;
            return true;
        }
        return false;
    }

    private int doUpdate(BIOrionObject obj, boolean forceUpdate) {
        OrionType type = obj.getOrionType();
        TableDefinition tableDef = TableDefinition.get(this.db, type);
        Property[] props = type.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (!BOrionObject.isKey(props[i]) || !obj.isModified(props[i])) continue;
            throw new OrionException("Keys cannot be modified");
        }
        String sql = Update.buildUpdateSql(tableDef, type, forceUpdate, obj);
        try {
            RdbmsPreparedStatement prep = this.session.makeStatement(this.db, this.dmlConnection, sql);
            Update.loadUpdateStatement(prep, tableDef, type, forceUpdate, obj);
            int rowCount = prep.executeUpdate();
            if (rowCount != 1) {
                throw new OrionException("Unexpected row count during update: " + rowCount);
            }
            return rowCount;
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }

    public static String buildUpdateSql(TableDefinition tableDef, OrionType type, boolean forceUpdate, BIOrionObject obj) {
        int i;
        Property[] props = type.getProperties();
        Property[] keys = type.getKey();
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tableDef.getTableName()).append(" SET ");
        int n = 0;
        for (i = 0; i < props.length; ++i) {
            if (BOrionObject.isKey(props[i]) || !forceUpdate && !obj.isModified(props[i])) continue;
            if (n++ > 0) {
                sql.append(", ");
            }
            sql.append(props[i].getName()).append(" = ?");
        }
        sql.append(" WHERE ");
        for (i = 0; i < keys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append("(");
            sql.append(keys[i].getName());
            sql.append(" = ?)");
        }
        return sql.toString();
    }

    public static void loadUpdateStatement(RdbmsPreparedStatement prep, TableDefinition tableDef, OrionType type, boolean forceUpdate, BIOrionObject obj) {
        Property[] props = type.getProperties();
        Property[] keys = type.getKey();
        int n = 1;
        ColumnDefinition[] columns = tableDef.getColumns();
        for (int i = 0; i < props.length; ++i) {
            if (BOrionObject.isKey(props[i]) || !forceUpdate && !obj.isModified(props[i])) continue;
            columns[i].getTranslator().setPreparedStatementValue(prep, n++, obj.get(props[i]), (Context)props[i].getFacets());
        }
        ColumnDefinition[] keyColumns = tableDef.getKeyColumns();
        for (int i = 0; i < keyColumns.length; ++i) {
            keyColumns[i].getTranslator().setPreparedStatementValue(prep, n++, obj.get(keys[i]), (Context)keyColumns[i].getProperty().getFacets());
        }
    }

    public static class UpdateVisitor
    extends SqlVisitor {
        public UpdateVisitor(BLocalOrionDatabase db) {
            super(db);
        }

        public void visit(BSqlUpdate node) {
            this.initialize();
            this.helper = new SqlHelper(this.db, null);
            if (node.getUpdateTable().equals((Object)BTypeSpec.DEFAULT)) {
                throw new OrionException("Cannot update. updateTable is not set.");
            }
            this.queryText.append("UPDATE ");
            this.visit(new BSqlExtent(node.getUpdateTable()));
            this.queryText.append("SET ");
            try {
                this.setUseParameterSubstitution(true);
                this.visit(node.getUpdateMap());
                if (node.hasCondition()) {
                    this.queryText.append("WHERE ");
                    this.visit(node.getCondition());
                }
            }
            finally {
                this.setUseParameterSubstitution(false);
            }
        }

        @Override
        public void visit(BFieldExpression node) {
            this.queryText.append(this.resolveFieldName(node));
        }

        private String resolveFieldName(BFieldExpression expr) {
            return expr instanceof BSqlField ? ((BSqlField)expr).getAliasedField(this.db) : expr.getField();
        }

        protected void visit(BVector updateMap) {
            SlotCursor cursor = updateMap.getSlots();
            int i = 0;
            while (cursor.next(BSimple.class)) {
                if (i > 0) {
                    this.queryText.append(", ");
                }
                this.queryText.append(cursor.property().getName()).append(" = ");
                this.visit(Exprs.simple((BSimple)cursor.get().asSimple()));
                ++i;
            }
            this.queryText.append(' ');
        }
    }
}

