/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.sql.SqlHelper;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.query.QueryIdioms;
import com.tridium.query.QueryStringVisitor;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BExtent;
import javax.baja.query.BNull;
import javax.baja.query.BTypedExtent;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.query.expression.BListExpression;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.sys.BSimple;
import javax.baja.sys.Type;

public abstract class SqlVisitor
extends QueryStringVisitor {
    private QueryIdioms idioms_ = new OqlIdioms();
    protected BLocalOrionDatabase db;
    protected SqlHelper helper;
    protected Array<BSimple> parameters;
    private boolean useParameterSubstitution = false;

    public SqlVisitor(BLocalOrionDatabase db) {
        this.db = db;
    }

    protected void initialize() {
        super.initialize();
        this.helper = null;
        this.parameters = new Array(BSimple.class);
    }

    public QueryIdioms idioms() {
        return this.idioms_;
    }

    public final void setUseParameterSubstitution(boolean enabled) {
        this.useParameterSubstitution = enabled;
    }

    public final BSimple[] getParameters() {
        return (BSimple[])this.parameters.trim();
    }

    public void visit(BExtent extent) {
        if (extent.list().length == 0) {
            return;
        }
        if (extent instanceof BSqlExtent) {
            this.visit((BSqlExtent)extent);
        } else {
            BTypedExtent typedExtent = (BTypedExtent)extent;
            Type[] extents = typedExtent.listTypes();
            for (int i = 0; i < extents.length; ++i) {
                if (i > 0) {
                    this.queryText.append(", ");
                }
                this.queryText.append(this.db.getTableName((OrionType)extents[i]));
            }
            this.queryText.append(' ');
        }
    }

    protected void visit(BSqlExtent extent) {
        this.queryText.append(this.db.getTableName((OrionType)extent.listTypes()[0]));
        if (extent.isExtentAliased()) {
            this.queryText.append(' ').append(extent.getExtentAlias());
        }
        this.queryText.append(' ');
    }

    public void visit(BFieldExpression node) {
        this.queryText.append(this.helper.resolveField(node));
    }

    public void visit(BListExpression node) {
        this.queryText.append('(');
        BExpression[] exprs = node.getExpressions();
        for (int i = 0; i < exprs.length; ++i) {
            if (i > 0) {
                this.queryText.append(", ");
            }
            this.visit(exprs[i]);
        }
        this.queryText.append(')');
    }

    public void visit(BSimpleExpression node) {
        BSimple s = node.getSimpleValue();
        if (!BNull.NULL.equals((Object)s) && (this.inPredicate || this.useParameterSubstitution)) {
            this.queryText.append('?');
            this.parameters.add((Object)s);
        } else {
            try {
                this.queryText.append(s.encodeToString());
            }
            catch (Exception x) {
                throw new OrionException("Failed to convert BSimpleExpression.", x);
            }
        }
    }

    public class OqlIdioms
    extends QueryStringVisitor.DefaultIdioms {
        public OqlIdioms() {
            super((QueryStringVisitor)SqlVisitor.this);
        }

        public String toAliasString(String alias) {
            return " AS " + alias;
        }
    }
}

