/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.Fetch;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.baja.query.BQuery;
import javax.baja.security.BPermissions;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;

public class Read
extends Fetch {
    public Read(DbOrionSession session) {
        super(session);
    }

    public BIOrionObject read(BQuery query) {
        BPermissions permissions = this.getPermissionsForQuery(query);
        if (!permissions.hasOperatorRead()) {
            return null;
        }
        BIOrionObject[] res = this.session.select(query).toArray();
        BIOrionObject o = null;
        switch (res.length) {
            case 0: {
                o = null;
                break;
            }
            case 1: {
                o = res[0];
                break;
            }
            default: {
                throw new OrionException("More than one object found");
            }
        }
        if (this.canRead(o)) {
            return o;
        }
        return null;
    }

    public BIOrionObject read(BIOrionObject obj) {
        OrionType type = obj.getOrionType();
        Property[] props = type.getKey();
        PropertyValue[] propValues = new PropertyValue[props.length];
        for (int i = 0; i < props.length; ++i) {
            propValues[i] = new PropertyValue(props[i], obj.get(props[i]));
        }
        try {
            BIOrionObject o = this.prepareAndFetchRecord(this.db, this.dmlConnection, obj, TableDefinition.get(this.db, type), propValues);
            if (this.canRead(o)) {
                return o;
            }
            return null;
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }

    public BIOrionObject read(OrionType type, BSimple key) {
        Property[] properties = type.getKey();
        if (properties == null || properties.length != 1) {
            throw new OrionException("The type " + type + " does not have exactly one key property.");
        }
        try {
            PropertyValue[] keys = new PropertyValue[]{new PropertyValue(properties[0], (BValue)key)};
            BIOrionObject o = this.prepareAndFetchRecord(this.db, this.dmlConnection, null, TableDefinition.get(this.db, type), keys);
            if (this.canRead(o)) {
                return o;
            }
            return null;
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }

    public BIOrionObject read(OrionType type, PropertyValue propValue) {
        return this.read(type, new PropertyValue[]{propValue});
    }

    public BIOrionObject read(OrionType type, PropertyValue[] propValues) {
        try {
            BIOrionObject o = this.prepareAndFetchRecord(this.db, this.dmlConnection, null, TableDefinition.get(this.db, type), propValues);
            if (this.canRead(o)) {
                return o;
            }
            return null;
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }

    public BIOrionObject read(OrionType type, String sql, BSimple[] paramValues) {
        String word = Read.firstWord(sql.trim()).toUpperCase();
        if (!word.equals("SELECT")) {
            throw new OrionException("Invalid SELECT statement: " + sql);
        }
        try {
            BIOrionObject o = this.fetchRecord(null, TableDefinition.get(this.db, type), this.makeQueryResultSet(sql, paramValues));
            if (this.canRead(o)) {
                return o;
            }
            return null;
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists(OrionType type, PropertyValue[] propValues) {
        try {
            TableDefinition tableDef = TableDefinition.get(this.db, type);
            RdbmsPreparedStatement prep = this.session.makeStatement(this.db, this.dmlConnection, this.buildPreparedSelect(tableDef, propValues));
            this.loadPreparedSelect(tableDef, propValues, prep);
            try (ResultSet rs = prep.executeQuery();){
                boolean bl = rs.next();
                return bl;
            }
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }
}

