/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.ColumnDefinition;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.SessionHelper;
import com.tridium.orion.priv.db.trans.TranslatorFactory;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;

public class Fetch
extends SessionHelper {
    public Fetch(DbOrionSession session) {
        super(session);
    }

    public void setPropertyValues(TableDefinition tableDef, BIOrionObject obj, RdbmsResultSet rs, boolean isRawSql) {
        ColumnDefinition[] columns = tableDef.getColumns();
        if (!isRawSql && this.anyAutoResolve(columns)) {
            this.setAutoResolvePropertyValues(tableDef, obj, rs, 1);
        } else {
            for (int i = 0; i < columns.length; ++i) {
                this.setPropertyValue(columns[i], obj, rs, i + 1);
            }
        }
        obj.clearAllModified();
    }

    private int setAutoResolvePropertyValues(TableDefinition sourceDef, BIOrionObject sourceObj, RdbmsResultSet rs, int rsIdx) {
        ColumnDefinition[] sourceCols = sourceDef.getColumns();
        for (int i = 0; i < sourceCols.length; ++i) {
            this.setPropertyValue(sourceCols[i], sourceObj, rs, rsIdx++);
            if (!sourceCols[i].isAutoResolve()) continue;
            BRef targetRef = (BRef)sourceObj.get(sourceCols[i].getProperty());
            TableDefinition targetDef = this.getRefTableDef(targetRef);
            BIOrionObject targetObj = (BIOrionObject)targetRef.getTargetTypeSpec().getInstance();
            if (rs.isNull(rsIdx - 1)) {
                rsIdx = this.skipAutoResolvePropertyValues(targetDef, targetObj, rsIdx);
                sourceObj.set(sourceCols[i].getProperty(), (BValue)BRef.NULL);
                continue;
            }
            rsIdx = this.setAutoResolvePropertyValues(targetDef, targetObj, rs, rsIdx);
            targetObj.clearAllModified();
            targetObj.setOrionDatabase(this.db);
            ((BObject)targetObj).fw(702, null, null, null, null);
            targetRef.resolve(targetObj);
        }
        return rsIdx;
    }

    private int skipAutoResolvePropertyValues(TableDefinition sourceDef, BIOrionObject sourceObj, int rsIdx) {
        ColumnDefinition[] sourceCols = sourceDef.getColumns();
        for (int i = 0; i < sourceCols.length; ++i) {
            ++rsIdx;
            if (!sourceCols[i].isAutoResolve()) continue;
            BRef targetRef = (BRef)sourceObj.get(sourceCols[i].getProperty());
            TableDefinition targetDef = this.getRefTableDef(targetRef);
            BIOrionObject targetObj = (BIOrionObject)targetRef.getTargetTypeSpec().getInstance();
            rsIdx = this.skipAutoResolvePropertyValues(targetDef, targetObj, rsIdx);
        }
        return rsIdx;
    }

    private void setPropertyValue(ColumnDefinition column, BIOrionObject obj, RdbmsResultSet rs, int rsIdx) {
        Property prop = column.getProperty();
        BColumnTranslator trans = column.getTranslator();
        if (rs.isNull(rsIdx)) {
            ((BObject)obj).fw(704, (Object)prop, (Object)Boolean.TRUE, null, null);
            obj.set(prop, prop.getDefaultValue());
        } else {
            obj.set(prop, trans.getResultSetValue(rs, rsIdx, (Context)prop.getFacets()));
        }
    }

    protected BIOrionObject prepareAndFetchRecord(BOrionDatabase db, Connection conn, BIOrionObject obj, TableDefinition tableDef, PropertyValue[] propValues) throws SQLException {
        RdbmsPreparedStatement prep = this.session.makeStatement(db, conn, this.buildPreparedSelect(tableDef, propValues));
        this.loadPreparedSelect(tableDef, propValues, prep);
        return this.fetchRecord(obj, tableDef, prep.executeQuery());
    }

    protected BIOrionObject fetchRecord(BIOrionObject obj, TableDefinition tableDef, ResultSet rs) throws SQLException {
        if (!rs.next()) {
            return null;
        }
        if (obj == null) {
            obj = tableDef.getInstance();
        }
        this.setPropertyValues(tableDef, obj, new RdbmsResultSet(rs), false);
        if (rs.next()) {
            throw new OrionException("More than one object found");
        }
        rs.close();
        obj.setOrionDatabase(this.db);
        ((BObject)obj).fw(702, null, null, null, null);
        return obj;
    }

    public String buildPreparedSelect(TableDefinition tableDef, PropertyValue[] propValues) {
        StringBuffer sql = this.makeSqlForType(tableDef);
        sql.append(" WHERE ");
        for (int i = 0; i < propValues.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append("(");
            sql.append(tableDef.getTableName()).append(".");
            sql.append(propValues[i].getProperty().getName());
            sql.append(" = ?)");
        }
        return sql.toString();
    }

    public void loadPreparedSelect(TableDefinition tableDef, PropertyValue[] propValues, RdbmsPreparedStatement prep) {
        for (int i = 0; i < propValues.length; ++i) {
            Property prop = propValues[i].getProperty();
            ColumnDefinition col = tableDef.getColumn(prop.getName());
            col.getTranslator().setPreparedStatementValue(prep, i + 1, propValues[i].getValue(), (Context)prop.getFacets());
        }
    }

    protected ResultSet makeQueryResultSet(String sql, BSimple[] paramValues) throws SQLException {
        if (paramValues == null || paramValues.length == 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, sql);
            }
            return this.dmlConnection.createStatement().executeQuery(sql);
        }
        RdbmsPreparedStatement prep = this.session.makeStatement(this.db, this.dmlConnection, sql);
        for (int i = 0; i < paramValues.length; ++i) {
            BColumnTranslator trans = TranslatorFactory.make(this.dialect, (BValue)paramValues[i]);
            trans.setPreparedStatementValue(prep, i + 1, (BValue)paramValues[i], null);
        }
        return prep.executeQuery();
    }

    protected StringBuffer makeSqlForType(TableDefinition sourceDef) {
        StringBuffer sql = new StringBuffer();
        ColumnDefinition[] sourceCols = sourceDef.getColumns();
        if (this.anyAutoResolve(sourceCols)) {
            sql.append("SELECT ");
            this.appendColumns(sql, sourceDef, sourceCols, true);
            sql.append(" FROM ").append(sourceDef.getTableName());
            this.appendJoins(sql, sourceDef, sourceCols);
        } else {
            sql.append("SELECT * FROM ").append(sourceDef.getTableName());
        }
        return sql;
    }

    public void appendColumns(StringBuffer sql, TableDefinition sourceDef, ColumnDefinition[] sourceCols, boolean isFirst) {
        for (int i = 0; i < sourceCols.length; ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                sql.append(", ");
            }
            sql.append(sourceDef.getTableName()).append('.').append(sourceCols[i].getColumnName());
            if (!sourceCols[i].isAutoResolve()) continue;
            TableDefinition targetDef = this.getRefTableDef(sourceCols[i]);
            this.appendColumns(sql, targetDef, targetDef.getColumns(), isFirst);
        }
    }

    private void appendJoins(StringBuffer sql, TableDefinition sourceDef, ColumnDefinition[] sourceCols) {
        for (int i = 0; i < sourceCols.length; ++i) {
            if (!sourceCols[i].isAutoResolve()) continue;
            TableDefinition targetDef = this.getRefTableDef(sourceCols[i]);
            ColumnDefinition targetKey = targetDef.getKeyColumn();
            sql.append(" LEFT JOIN ").append(targetDef.getTableName()).append(" ON ");
            sql.append(sourceDef.getTableName()).append(".").append(sourceCols[i].getColumnName()).append(" = ");
            sql.append(targetDef.getTableName()).append(".").append(targetKey.getColumnName());
            this.appendJoins(sql, targetDef, targetDef.getColumns());
        }
    }

    public TableDefinition getRefTableDef(ColumnDefinition column) {
        return this.getRefTableDef((BRef)column.getProperty().getDefaultValue());
    }

    public TableDefinition getRefTableDef(BRef ref) {
        OrionType targetType = TableDefinition.getRefType(this.db, ref);
        return TableDefinition.get(this.db, targetType);
    }

    private boolean anyAutoResolve(ColumnDefinition[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].isAutoResolve()) continue;
            return true;
        }
        return false;
    }
}

