/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.OrionException;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.sql.SessionHelper;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class Ddl
extends SessionHelper
implements AutoCloseable {
    private Connection ddlConnection;

    public Ddl(DbOrionSession session) {
        super(session);
    }

    public void invokeDdl(String ddl) {
        String word = Ddl.firstWord(ddl.trim()).toUpperCase();
        if (!(word.equals("CREATE") || word.equals("DROP") || word.equals("ALTER") || word.equals("RENAME"))) {
            throw new OrionException("Invalid ddl statement: " + ddl);
        }
        this.log.log(Level.FINE, ddl);
        try {
            if (this.ddlConnection == null || this.ddlConnection.isClosed()) {
                boolean dmlConnectionIsPrivileged = this.session.getDb().getRdbms().isPrivilegedConnection(this.dmlConnection);
                this.ddlConnection = dmlConnectionIsPrivileged ? this.dmlConnection : AccessController.doPrivileged(() -> this.session.getDb().getRdbms().getPrivilegedConnection(null));
            }
            try (Statement statement = this.ddlConnection.createStatement();){
                statement.executeUpdate(ddl);
            }
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new OrionException(cause);
        }
    }

    @Override
    public void close() {
        if (this.ddlConnection != null && this.ddlConnection != this.dmlConnection) {
            try {
                this.ddlConnection.close();
            }
            catch (SQLException e) {
                this.log.log(Level.FINE, "Unable to close ddlConnection", this.log.isLoggable(Level.FINE) ? e : null);
            }
        }
    }
}

