/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbBatchDelete;
import com.tridium.orion.priv.db.DbBatchInsert;
import com.tridium.orion.priv.db.DbBatchPersist;
import com.tridium.orion.priv.db.DbBatchUpdate;
import com.tridium.orion.priv.db.sql.Ddl;
import com.tridium.orion.priv.db.sql.Delete;
import com.tridium.orion.priv.db.sql.Insert;
import com.tridium.orion.priv.db.sql.LinkedScan;
import com.tridium.orion.priv.db.sql.Read;
import com.tridium.orion.priv.db.sql.Scan;
import com.tridium.orion.priv.db.sql.Select;
import com.tridium.orion.priv.db.sql.Update;
import com.tridium.orion.priv.util.MapHelper;
import com.tridium.orion.priv.util.OrionSessionManager;
import com.tridium.orion.sql.BSqlUpdate;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;

public class DbOrionSession
implements OrionSession {
    private static OrionSessionManager sessionManager = new OrionSessionManager();
    private static Logger log = Logger.getLogger("orion.jdbc");
    private Context context;
    private final BLocalOrionDatabase db;
    private Connection dmlConn;
    private Ddl ddlHelper;
    private Delete deleteHelper;
    private Insert insertHelper;
    private LinkedScan linkedHelper;
    private MapHelper mapHelper;
    private Read readHelper;
    private Scan scanHelper;
    private Select selectHelper;
    private Update updateHelper;
    private static final int MAX_PREP_CACHE = 50;
    private CacheMap<String, RdbmsPreparedStatement> prepCache = new CacheMap();

    public DbOrionSession(BLocalOrionDatabase db, Context cx) {
        this.db = db;
        this.context = cx;
        try {
            this.dmlConn = AccessController.doPrivileged(() -> db.getRdbms().getNonPrivilegedConnection(null));
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e instanceof PrivilegedActionException && e.getCause() != null) {
                cause = e.getCause();
            }
            throw new OrionException(cause);
        }
        this.ddlHelper = new Ddl(this);
        this.deleteHelper = new Delete(this);
        this.insertHelper = new Insert(this);
        this.linkedHelper = new LinkedScan(this);
        this.mapHelper = new MapHelper();
        this.readHelper = new Read(this);
        this.scanHelper = new Scan(this);
        this.selectHelper = new Select(this);
        this.updateHelper = new Update(this);
        sessionManager.openSpy(this);
    }

    @Override
    public BOrionDatabase getOrionDatabase() {
        return this.db;
    }

    @Override
    public RdbmsContext getRdbmsContext() {
        return this.db.getRdbms().getRdbmsContext();
    }

    @Override
    public void setAutoCommit(boolean auto) {
        try {
            this.dmlConn.setAutoCommit(auto);
        }
        catch (SQLException ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public boolean getAutoCommit() {
        try {
            return this.dmlConn.getAutoCommit();
        }
        catch (SQLException ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public void commit() {
        try {
            this.dmlConn.commit();
        }
        catch (SQLException ex) {
            throw new OrionException("Commit failed.", ex);
        }
    }

    @Override
    public void rollback() {
        try {
            this.dmlConn.rollback();
        }
        catch (SQLException ex) {
            throw new OrionException("Rollback failed.", ex);
        }
    }

    @Override
    public boolean isOpen() {
        try {
            return this.dmlConn != null && !this.dmlConn.isClosed();
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.");
        }
    }

    @Override
    public void close() {
        try {
            if (!this.dmlConn.getAutoCommit()) {
                this.rollback();
            }
            this.dmlConn.close();
            this.prepCache.clear();
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
        finally {
            if (this.ddlHelper != null) {
                this.ddlHelper.close();
            }
        }
        this.db.sessionClosed(this);
        sessionManager.closeSpy(this);
    }

    public String getTableName(OrionType type) {
        return this.db.getTableName(type);
    }

    @Override
    public void invokeDdl(DdlCommand ddl) {
        this.ddlHelper.invokeDdl(ddl.getDdl(this.getRdbmsContext()));
    }

    @Override
    public void insert(BIOrionObject object) {
        this.insertHelper.insert(object);
    }

    @Override
    public int insert(String sql) {
        return this.insertHelper.updateOrDelete("INSERT", sql);
    }

    @Override
    public int insert(String sql, BSimple[] paramValues) {
        return this.insertHelper.updateOrDelete("INSERT", sql, paramValues);
    }

    @Override
    public void mappedInsert(BObject object) {
        this.insertHelper.insert(this.mapHelper.mapForInsert(object));
    }

    @Override
    public int update(BSqlUpdate update) {
        return this.updateHelper.update(update);
    }

    @Override
    public int update(String sql) {
        return this.updateHelper.updateOrDelete("UPDATE", sql);
    }

    @Override
    public int update(String sql, BSimple[] paramValues) {
        return this.updateHelper.updateOrDelete("UPDATE", sql, paramValues);
    }

    @Override
    public void update(BIOrionObject object) {
        this.updateHelper.update(object, false);
    }

    @Override
    public void update(BIOrionObject object, boolean forceUpdate) {
        this.updateHelper.update(object, forceUpdate);
    }

    @Override
    public void mappedUpdate(BObject object) {
        this.updateHelper.update(this.mapHelper.mapForUpdate(object));
    }

    @Override
    public void persist(BIOrionObject object) {
        if (this.exists(object)) {
            this.update(object, true);
        } else {
            this.insert(object);
        }
    }

    @Override
    public int delete(OrionType type, BExpression condition) {
        return this.deleteHelper.delete(type, condition);
    }

    @Override
    public int delete(String sql) {
        return this.deleteHelper.updateOrDelete("DELETE", sql);
    }

    @Override
    public int delete(String sql, BSimple[] paramValues) {
        return this.deleteHelper.updateOrDelete("DELETE", sql, paramValues);
    }

    @Override
    public boolean mappedDelete(BObject object) {
        return this.deleteHelper.delete(this.mapHelper.mapForDelete(object));
    }

    @Override
    public boolean delete(BIOrionObject object) {
        return this.deleteHelper.delete(object);
    }

    @Override
    public OrionCursor select(BQuery query) {
        return this.selectHelper.select(query);
    }

    @Override
    public OrionCursor select(OrionType type, String sql) {
        return this.selectHelper.select(type, sql, null);
    }

    @Override
    public OrionCursor select(OrionType type, String sql, BSimple[] paramValues) {
        return this.selectHelper.select(type, sql, paramValues);
    }

    @Override
    public OrionCursor select(OrionType type, PropertyValue propValue) {
        return this.selectHelper.select(type, propValue);
    }

    @Override
    public OrionCursor select(OrionType type, PropertyValue[] propValues) {
        return this.selectHelper.select(type, propValues);
    }

    @Override
    public BIOrionObject mappedRead(BObject object) {
        BIOrionObject orionObject = this.mapHelper.mapForRead(object);
        if (this.readHelper.read(orionObject) == null) {
            return null;
        }
        return orionObject;
    }

    @Override
    public boolean exists(BIOrionObject obj) {
        return this.readHelper.exists(obj.getOrionType(), PropertyValue.makeKeys(obj));
    }

    @Override
    public boolean exists(OrionType type, PropertyValue[] propValues) {
        return this.readHelper.exists(type, propValues);
    }

    @Override
    public BIOrionObject read(BQuery query) {
        return this.readHelper.read(query);
    }

    @Override
    public BIOrionObject read(BIOrionObject object) {
        return this.readHelper.read(object);
    }

    @Override
    public BIOrionObject read(OrionType type, BSimple key) {
        return this.readHelper.read(type, key);
    }

    @Override
    public BIOrionObject read(OrionType type, PropertyValue propValue) {
        return this.readHelper.read(type, propValue);
    }

    @Override
    public BIOrionObject read(OrionType type, PropertyValue[] propValues) {
        return this.readHelper.read(type, propValues);
    }

    @Override
    public BIOrionObject read(OrionType type, String sql) {
        return this.readHelper.read(type, sql, null);
    }

    @Override
    public BIOrionObject read(OrionType type, String sql, BSimple[] paramValues) {
        return this.readHelper.read(type, sql, paramValues);
    }

    @Override
    public OrionCursor scan(OrionType type) {
        return this.scanHelper.scan(type);
    }

    @Override
    public OrionCursor linkedScan(BIOrionObject object, OrionType linkType, OrionType scanType) {
        return this.linkedHelper.linkedScan(object, linkType, scanType);
    }

    public BOrionDatabase getDb() {
        return this.db;
    }

    public Connection getConnection() {
        return this.dmlConn;
    }

    public Context getBase() {
        return this.context;
    }

    public String getLanguage() {
        if (this.context != null) {
            return this.context.getLanguage();
        }
        return Sys.getLanguage();
    }

    public BFacets getFacets() {
        if (this.context != null) {
            return this.context.getFacets();
        }
        return BFacets.DEFAULT;
    }

    public BObject getFacet(String key) {
        if (this.context != null) {
            return this.context.getFacet(key);
        }
        return null;
    }

    public BUser getUser() {
        if (this.context != null) {
            return this.context.getUser();
        }
        return null;
    }

    public RdbmsPreparedStatement makeStatement(BOrionDatabase db, Connection conn, String sql) throws SQLException {
        RdbmsPreparedStatement prep = (RdbmsPreparedStatement)this.prepCache.get(sql);
        if (prep == null) {
            prep = new RdbmsPreparedStatement(conn, sql);
            this.prepCache.put(sql, prep);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "cached " + sql);
            }
        }
        return prep;
    }

    public RdbmsPreparedStatement makeAutoKeyStatement(BOrionDatabase db, Connection conn, String sql, int autoKey) throws SQLException {
        String key = "AUTOKEY(" + autoKey + "):" + sql;
        RdbmsPreparedStatement prep = (RdbmsPreparedStatement)this.prepCache.get(key);
        if (prep == null) {
            prep = new RdbmsPreparedStatement(conn, sql, autoKey);
            this.prepCache.put(key, prep);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "cached autokey " + autoKey + ", " + sql);
            }
        }
        return prep;
    }

    @Override
    public BatchStatement batchInsert(OrionType type) {
        return new DbBatchInsert(this, type);
    }

    @Override
    public BatchStatement batchUpdate(OrionType type) {
        return new DbBatchUpdate(this, type);
    }

    @Override
    public BatchStatement batchPersist(OrionType type) {
        return new DbBatchPersist(this, type);
    }

    @Override
    public BatchStatement batchDelete(OrionType type) {
        return new DbBatchDelete(this, type);
    }

    public Connection getUnderylingConnection() {
        return this.dmlConn;
    }

    private static class CacheMap<K, V>
    extends LinkedHashMap<K, V> {
        private CacheMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 50;
        }
    }
}

