/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbBatch;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.sql.Update;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;

public class DbBatchUpdate
extends DbBatch {
    RdbmsPreparedStatement prep = null;

    public DbBatchUpdate(DbOrionSession session, OrionType type) {
        super(session, type);
    }

    @Override
    public void execute() {
        int i;
        BIOrionObject obj;
        if (this.arr.size() == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.arr.size(); ++i2) {
            obj = (BIOrionObject)this.arr.get(i2);
            if (obj.beforeUpdate(this.session)) continue;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "VETOED BATCH UPDATE: index " + i2 + ", object " + obj);
            }
            return;
        }
        try {
            if (this.prep == null) {
                String sql = Update.buildUpdateSql(this.tableDef, this.type, true, null);
                this.prep = this.session.makeStatement(this.db, this.conn, sql);
            }
            if (this.dialect.supportsBatchUpdate()) {
                int chunk = this.getChunkSize();
                int n = 0;
                for (int i3 = 0; i3 < this.arr.size(); ++i3) {
                    BIOrionObject obj2 = (BIOrionObject)this.arr.get(i3);
                    Update.loadUpdateStatement(this.prep, this.tableDef, this.type, true, obj2);
                    this.prep.addBatch();
                    if (chunk <= 0 || ++n < chunk) continue;
                    this.prep.executeBatch();
                    n = 0;
                }
                if (chunk == 0 || n > 0) {
                    this.prep.executeBatch();
                }
            } else {
                for (i = 0; i < this.arr.size(); ++i) {
                    obj = (BIOrionObject)this.arr.get(i);
                    Update.loadUpdateStatement(this.prep, this.tableDef, this.type, true, obj);
                    this.prep.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
        for (i = 0; i < this.arr.size(); ++i) {
            BIOrionObject obj3 = (BIOrionObject)this.arr.get(i);
            obj3.afterUpdate(this.session);
        }
        this.clear();
    }
}

