/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.audit;

import com.tridium.orion.BAuditMode;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridium.orion.priv.audit.BOrionAuditType;
import com.tridium.sys.Nre;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraOrionType
@NiagaraProperties(value={@NiagaraProperty(name="id", type="int", defaultValue="0", facets={@Facet(value="ID_KEY")}), @NiagaraProperty(name="timestamp", type="BAbsTime", defaultValue="BAbsTime.NULL"), @NiagaraProperty(name="userName", type="String", defaultValue="", facets={@Facet(name="INDEXED", value="true"), @Facet(name="WIDTH", value="64")}), @NiagaraProperty(name="objectTypeSpec", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT", facets={@Facet(name="WIDTH", value="64")}), @NiagaraProperty(name="objectDisplay", type="String", defaultValue="", facets={@Facet(name="WIDTH", value="512")}), @NiagaraProperty(name="auditType", type="BOrionAuditType", defaultValue="BOrionAuditType.unspecified"), @NiagaraProperty(name="slotName", type="String", defaultValue="", facets={@Facet(name="WIDTH", value="64")}), @NiagaraProperty(name="oldValue", type="String", defaultValue="", facets={@Facet(name="WIDTH", value="128")}), @NiagaraProperty(name="newValue", type="String", defaultValue="", facets={@Facet(name="WIDTH", value="128")})})
public class BOrionAudit
extends BOrionObject {
    @Generated
    public static final Property id = BOrionAudit.newProperty((int)0, (int)0, (BFacets)ID_KEY);
    @Generated
    public static final Property timestamp = BOrionAudit.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property userName = BOrionAudit.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"indexed", (boolean)true), (BFacets)BFacets.make((String)"width", (int)64)));
    @Generated
    public static final Property objectTypeSpec = BOrionAudit.newProperty((int)0, (BValue)BTypeSpec.DEFAULT, (BFacets)BFacets.make((String)"width", (int)64));
    @Generated
    public static final Property objectDisplay = BOrionAudit.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)512));
    @Generated
    public static final Property auditType = BOrionAudit.newProperty((int)0, (BValue)BOrionAuditType.unspecified, null);
    @Generated
    public static final Property slotName = BOrionAudit.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)64));
    @Generated
    public static final Property oldValue = BOrionAudit.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)128));
    @Generated
    public static final Property newValue = BOrionAudit.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)128));
    @Generated
    public static final Type TYPE = Sys.loadType(BOrionAudit.class);
    @Generated
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    public static final int ORION_INIT_ORIG = 702;
    public static final int ORION_GET_ORIG_VALUE = 703;

    @Generated
    public int getId() {
        return this.getInt(id);
    }

    @Generated
    public void setId(int v) {
        this.setInt(id, v, null);
    }

    @Generated
    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    @Generated
    public void setTimestamp(BAbsTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    @Generated
    public String getUserName() {
        return this.getString(userName);
    }

    @Generated
    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    @Generated
    public BTypeSpec getObjectTypeSpec() {
        return (BTypeSpec)this.get(objectTypeSpec);
    }

    @Generated
    public void setObjectTypeSpec(BTypeSpec v) {
        this.set(objectTypeSpec, (BValue)v, null);
    }

    @Generated
    public String getObjectDisplay() {
        return this.getString(objectDisplay);
    }

    @Generated
    public void setObjectDisplay(String v) {
        this.setString(objectDisplay, v, null);
    }

    @Generated
    public BOrionAuditType getAuditType() {
        return (BOrionAuditType)this.get(auditType);
    }

    @Generated
    public void setAuditType(BOrionAuditType v) {
        this.set(auditType, (BValue)v, null);
    }

    @Generated
    public String getSlotName() {
        return this.getString(slotName);
    }

    @Generated
    public void setSlotName(String v) {
        this.setString(slotName, v, null);
    }

    @Generated
    public String getOldValue() {
        return this.getString(oldValue);
    }

    @Generated
    public void setOldValue(String v) {
        this.setString(oldValue, v, null);
    }

    @Generated
    public String getNewValue() {
        return this.getString(newValue);
    }

    @Generated
    public void setNewValue(String v) {
        this.setString(newValue, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public static void auditCreated(BIOrionObject obj, String username, BAuditMode mode, OrionSession session) {
        Auditor auditor;
        if (mode.equals((Object)BAuditMode.both) || mode.equals((Object)BAuditMode.databaseRecord)) {
            BOrionAudit audit = BOrionAudit.makeAuditRecord(obj, username, session);
            audit.setAuditType(BOrionAuditType.created);
            session.insert(audit);
        }
        if ((mode.equals((Object)BAuditMode.both) || mode.equals((Object)BAuditMode.auditEvent)) && (auditor = Nre.auditor) != null) {
            auditor.audit(BOrionAudit.makeAuditEvent(obj, session, "Added", "", "", "", username));
        }
    }

    public static void auditDeleted(BIOrionObject obj, String username, BAuditMode mode, OrionSession session) {
        Auditor auditor;
        if (mode.equals((Object)BAuditMode.both) || mode.equals((Object)BAuditMode.databaseRecord)) {
            BOrionAudit rec = BOrionAudit.makeAuditRecord(obj, username, session);
            rec.setAuditType(BOrionAuditType.deleted);
            session.insert(rec);
        }
        if ((mode.equals((Object)BAuditMode.both) || mode.equals((Object)BAuditMode.auditEvent)) && (auditor = Nre.auditor) != null) {
            auditor.audit(BOrionAudit.makeAuditEvent(obj, session, "Removed", "", "", "", username));
        }
    }

    public static void auditModified(BIOrionObject obj, Property property, String username, BAuditMode mode, OrionSession session) {
        Auditor auditor;
        BValue newValue;
        BValue oldValue;
        if (mode.equals((Object)BAuditMode.both) || mode.equals((Object)BAuditMode.databaseRecord)) {
            BOrionAudit rec = BOrionAudit.makeAuditRecord(obj, username, session);
            rec.setAuditType(BOrionAuditType.modified);
            rec.setSlotName(property.getName());
            oldValue = (BValue)((BObject)obj).fw(703, (Object)property, null, null, null);
            newValue = obj.get(property);
            if (!BOrionObject.isSensitiveProperty(property)) {
                if (property.getType().equals(BRef.TYPE)) {
                    rec.setOldValue(BOrionAudit.makeRefString((BRef)oldValue, session));
                    rec.setNewValue(BOrionAudit.makeRefString((BRef)newValue, session));
                } else {
                    rec.setOldValue(oldValue.toString((Context)session));
                    rec.setNewValue(newValue.toString((Context)session));
                }
            } else {
                rec.setOldValue(BOrionObject.getSensitivePropertyString(null));
                rec.setNewValue(BOrionObject.getSensitivePropertyString(null));
            }
            session.insert(rec);
        }
        if ((mode.equals((Object)BAuditMode.both) || mode.equals((Object)BAuditMode.auditEvent)) && (auditor = Nre.auditor) != null) {
            oldValue = (BValue)((BObject)obj).fw(703, (Object)property, null, null, null);
            newValue = obj.get(property);
            if (!BOrionObject.isSensitiveProperty(property)) {
                if (property.getType().equals(BRef.TYPE)) {
                    auditor.audit(BOrionAudit.makeAuditEvent(obj, session, "Changed", property.getName(), BOrionAudit.makeRefString((BRef)oldValue, session), BOrionAudit.makeRefString((BRef)newValue, session), username));
                } else {
                    auditor.audit(BOrionAudit.makeAuditEvent(obj, session, "Changed", property.getName(), oldValue.toString((Context)session), newValue.toString((Context)session), username));
                }
            } else {
                auditor.audit(BOrionAudit.makeAuditEvent(obj, session, "Changed", property.getName(), BOrionObject.getSensitivePropertyString(null), BOrionObject.getSensitivePropertyString(null), username));
            }
        }
    }

    private static String makeRefString(BRef ref, OrionSession session) {
        BIOrionObject target = ref.getTarget(session);
        return target == null ? "null" : target.toDisplayString(session);
    }

    private static BOrionAudit makeAuditRecord(BIOrionObject obj, String username, OrionSession session) {
        BOrionAudit rec = new BOrionAudit();
        rec.setTimestamp(BAbsTime.now());
        rec.setUserName(username);
        rec.setObjectTypeSpec(obj.getOrionType().getTypeSpec());
        rec.setObjectDisplay(obj.toDisplayString(session));
        return rec;
    }

    private static AuditEvent makeAuditEvent(BIOrionObject obj, OrionSession session, String operation, String slotName, String oldValue, String value, String username) {
        String userName = username;
        String target = "Orion " + obj.getOrionType().getDisplayName(null) + ", " + obj.toDisplayString(session);
        AuditEvent event = new AuditEvent(operation, target, slotName, oldValue, value, userName);
        return event;
    }

    @Override
    public final boolean isAuditable() {
        return false;
    }
}

