/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.orion.BAuditMode;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionRoot;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BSecurityAuditMode;
import com.tridium.orion.OrionException;
import com.tridium.orion.priv.audit.BOrionAuditWorker;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.fox.BOrionChannel;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.sys.station.Station;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.security.dashboard.BISecurityDashboardProvider;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3, override=true), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3, override=true), @NiagaraProperty(name="ordMap", type="BOrdToCategoryMap", defaultValue="BOrdToCategoryMap.DEFAULT", flags=5), @NiagaraProperty(name="auditMode", type="BAuditMode", defaultValue="BAuditMode.none"), @NiagaraProperty(name="securityAuditMode", type="BSecurityAuditMode", defaultValue="BSecurityAuditMode.securityEventAndDatabaseRecord"), @NiagaraProperty(name="auditWorker", type="BOrionAuditWorker", defaultValue="new BOrionAuditWorker()", flags=4)})
public class BOrionService
extends BAbstractService
implements BIRestrictedComponent,
BISecurityDashboardProvider {
    @Generated
    public static final Property status = BOrionService.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BOrionService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property ordMap = BOrionService.newProperty((int)5, (BValue)BOrdToCategoryMap.DEFAULT, null);
    @Generated
    public static final Property auditMode = BOrionService.newProperty((int)0, (BValue)BAuditMode.none, null);
    @Generated
    public static final Property securityAuditMode = BOrionService.newProperty((int)0, (BValue)BSecurityAuditMode.securityEventAndDatabaseRecord, null);
    @Generated
    public static final Property auditWorker = BOrionService.newProperty((int)4, (BValue)new BOrionAuditWorker(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOrionService.class);
    private static final BIcon icon = BIcon.make((String)"module://orion/rc/orion.png");
    private static final SecurityDashboardItemBuilder dashboardItemBuilder = new SecurityDashboardItemBuilder(TYPE);
    private static final int SECURITY_DASHBOARD_VERSION = 1;
    public static final Logger log = Logger.getLogger("orion");
    private BOrionSpace space;
    private HashMap<String, BLocalOrionDatabase> dbs = new HashMap();
    private boolean ready = false;
    private Station.SaveListener saveListener = new Station.SaveListener(){

        public void stationSave() {
            BOrionService.this.checkpoint();
        }

        public void stationSaveOk() {
        }

        public void stationSaveFail(String cause) {
        }

        public String toString() {
            return "OrionService " + BOrionService.this.getNavOrd();
        }
    };

    @Generated
    public BOrdToCategoryMap getOrdMap() {
        return (BOrdToCategoryMap)this.get(ordMap);
    }

    @Generated
    public void setOrdMap(BOrdToCategoryMap v) {
        this.set(ordMap, (BValue)v, null);
    }

    @Generated
    public BAuditMode getAuditMode() {
        return (BAuditMode)this.get(auditMode);
    }

    @Generated
    public void setAuditMode(BAuditMode v) {
        this.set(auditMode, (BValue)v, null);
    }

    @Generated
    public BSecurityAuditMode getSecurityAuditMode() {
        return (BSecurityAuditMode)this.get(securityAuditMode);
    }

    @Generated
    public void setSecurityAuditMode(BSecurityAuditMode v) {
        this.set(securityAuditMode, (BValue)v, null);
    }

    @Generated
    public BOrionAuditWorker getAuditWorker() {
        return (BOrionAuditWorker)this.get(auditWorker);
    }

    @Generated
    public void setAuditWorker(BOrionAuditWorker v) {
        this.set(auditWorker, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BOrionService getService() {
        return (BOrionService)Sys.getService((Type)TYPE);
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() {
        Station.addSaveListener((Station.SaveListener)this.saveListener);
    }

    public void started() {
        if (this.getStatus().isValid()) {
            this.boot();
        }
    }

    public void stopped() {
        this.shutdown();
    }

    public void serviceStopped() {
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
    }

    public void boot() {
        for (BLocalOrionDatabase db : this.dbs.values()) {
            db.boot();
        }
        BValue channel = BFoxChannelRegistry.getPrototype().get("orion");
        if (channel == null) {
            BFoxChannelRegistry.getPrototype().add("orion", (BValue)new BOrionChannel());
        } else if (!channel.getType().is(BOrionChannel.TYPE)) {
            throw new OrionException("Orion channel already registered as " + channel.getType());
        }
        this.ready = true;
        for (BLocalOrionDatabase db : this.dbs.values()) {
            db.orionReady();
        }
    }

    public void shutdown() {
        this.ready = false;
        try {
            BFoxChannelRegistry.getPrototype().remove("orion");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.space != null) {
            try {
                BLocalHost.INSTANCE.removeNavChild((BINavNode)this.space);
                this.space.getRootComponent().removeAll();
                this.space.setRootComponent(null);
                this.space = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (BLocalOrionDatabase db : this.dbs.values()) {
            try {
                db.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.dbs.clear();
    }

    public boolean isOrionReady() {
        return this.ready;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context context) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context context) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        this.addOrionAuditModeStatus(items);
        return items;
    }

    private void addOrionAuditModeStatus(List<SecurityDashboardItem> items) {
        if (this.getAuditMode().equals((Object)BAuditMode.none)) {
            items.add(dashboardItemBuilder.makeAlert("securityDashboard.orionServiceAuditModeDisabled.summary", "securityDashboard.orionServiceAuditMode.description"));
        } else {
            items.add(dashboardItemBuilder.makeOk("securityDashboard.orionServiceAuditModeEnabled.summary", "securityDashboard.orionServiceAuditMode.description"));
        }
    }

    public BOrionSpace getOrionSpace() {
        if (this.space == null) {
            this.space = new BOrionSpace();
            BOrionRoot root = new BOrionRoot();
            BCategoryMask catMask = this.getCategoryMask(root.getOrdInSession());
            if (catMask == null) {
                root.setCategoryMask(BCategoryMask.make((String)"1"), Context.decoding);
            } else {
                root.setCategoryMask(catMask, Context.decoding);
            }
            this.space.setRootComponent(root);
            BLocalHost.INSTANCE.addNavChild((BINavNode)this.space);
        }
        return this.space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrionDatabase getOrionDatabase(BRdbms rdbms) {
        String rdbmsName = rdbms.getName();
        HashMap<String, BLocalOrionDatabase> hashMap = this.dbs;
        synchronized (hashMap) {
            BLocalOrionDatabase db = this.dbs.get(rdbmsName);
            if (db == null) {
                db = this.initDatabase(rdbms);
                this.getOrionSpace().getRootComponent().add(db.getId(), (BValue)db);
                BCategoryMask cats = this.getOrdMap().getCategoryMask(db.getOrdInSession());
                if (cats != null) {
                    db.setCategoryMask(cats, Context.decoding);
                }
                this.dbs.put(db.getId(), db);
            }
            return db;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrionDatabase getOrionDatabase(String dbId) {
        HashMap<String, BLocalOrionDatabase> hashMap = this.dbs;
        synchronized (hashMap) {
            return this.dbs.get(dbId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrionDatabase[] getOrionDatabases() {
        HashMap<String, BLocalOrionDatabase> hashMap = this.dbs;
        synchronized (hashMap) {
            BOrionDatabase[] result = new BOrionDatabase[this.dbs.size()];
            int count = 0;
            Iterator<BLocalOrionDatabase> i = this.dbs.values().iterator();
            while (i.hasNext()) {
                result[count] = i.next();
            }
            return result;
        }
    }

    private BLocalOrionDatabase initDatabase(BRdbms rdbms) {
        BLocalOrionDatabase db = new BLocalOrionDatabase();
        db.init(this, rdbms);
        return db;
    }

    public void setCategoryMask(BOrd ord, BCategoryMask mask) {
        this.setOrdMap(this.getOrdMap().setCategoryMask(ord, mask));
    }

    public BCategoryMask getCategoryMask(BOrd ord) {
        return this.getOrdMap().getCategoryMask(ord);
    }

    public BCategoryMask getAppliedCategoryMask(BOrd ord) {
        return this.getOrdMap().getAppliedCategoryMask(ord);
    }

    private void checkpoint() {
        for (BLocalOrionDatabase db : this.dbs.values()) {
            BRdbms rdb = db.getRdbms();
            RdbmsDialect dialect = (RdbmsDialect)rdb.getRdbmsContext();
            log.log(Level.INFO, "begin checkpoint on " + rdb.getName() + " (" + rdb.getType() + ")");
            try {
                DbOrionSession session = (DbOrionSession)db.createSession(null);
                Throwable throwable = null;
                try {
                    Connection conn = session.getUnderylingConnection();
                    dialect.issueCheckpoint(conn);
                    log.log(Level.INFO, "end checkpoint on " + rdb.getName() + " (" + rdb.getType() + ")");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (session == null) continue;
                    if (throwable != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    session.close();
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot issue checkpoint on " + rdb.getName() + " (" + rdb.getType() + ")", e);
            }
        }
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public BIcon getIcon() {
        return icon;
    }
}

