/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platMstp;

import com.tridium.platMstp.BBacnetMstpBaudRate;
import com.tridium.platMstp.BBacnetMstpSpecialBaudRate;
import com.tridium.platMstp.EmstpCommandEnum;
import com.tridium.platMstp.EmstpCommandPrefixEnum;
import com.tridium.platMstp.EmstpFrame;
import com.tridium.platMstp.EmstpStateEnum;
import com.tridium.platMstp.EmstpStats;
import com.tridium.platMstp.MstpFrame;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.sys.Clock;

public class EmstpStateMachine
implements Runnable {
    public static final int SEVERE_RECOVERY_MILLIS = 1000;
    public static final int PORT_RESET_RECOVERY_MILLIS = 2000;
    public static final int PORT_RECEIVE_TIMEOUT = 1;
    public static final int PORT_RECEIVE_THRESHOLD = 512;
    private EmstpFrame inframe;
    private final BISerialPort serialPort;
    private final String trunkName;
    private final EmstpStats statistics;
    private String osPortName;
    private boolean portDown;
    private BBaudRate baud = BBacnetMstpBaudRate.DEFAULT;
    private final LinkedBlockingDeque<MstpFrame> rxqueue;
    private final LinkedBlockingDeque<EmstpFrame> txqueue;
    private BufferedInputStream bufferedInputStream;
    private OutputStream serialOutputStream;
    Thread myThread;
    volatile boolean done = false;
    int bytesPerSec = 0;
    EmstpStateEnum state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
    boolean bufferAvailable = false;
    private int newAddress = -1;
    private int newMaxMaster = -1;
    private int newMaxInfoFrames = -1;
    private int newUsageTimeout = -1;
    private int newTxThrottle = -1;
    private int address = -1;
    private int maxMaster = -1;
    private int maxInfoFrames = -1;
    private int usageTimeout = -1;
    private int txThrottle = -1;
    private boolean commandPending;
    private boolean needToSetAddress;
    private boolean needToSetMaxMaster;
    private boolean needToSetMaxInfoFrames;
    private boolean needToSetUsageTimeout;
    private boolean needToSetTxThrottle;
    private boolean needToGetStatistics;
    private boolean needToResetStatistics;
    private boolean needToStartTokenPassing;
    private boolean needToStopTokenPassing;
    private boolean needToExitProcessorMode;
    private boolean needToRestartCoprocessorMode;
    private long keepAliveTicks;
    private int unknownEmstpMessages = 0;
    private int emstpResponseTimeout = 0;
    private int keepAliveSent = 0;
    private int txQ_fullCount = 0;
    private int ioErrorAvail = 0;
    public static Logger log = Logger.getLogger("plat.mstp");
    private static final int WAIT_RESPONSE_TIME = 10;
    private static final int KEEP_ALIVE_TIME = 3000;
    private static final int HOLD_TIME = 100;
    private static final int CONFIG_RESPONSE_TIME = 100;
    private static final String TMP_DIR = AccessController.doPrivileged(() -> System.getProperty("java.io.tmpdir"));

    public EmstpStateMachine(BISerialPort port, LinkedBlockingDeque<MstpFrame> rxq, LinkedBlockingDeque<EmstpFrame> txq, String trunk, EmstpStats stats) {
        this.serialPort = port;
        this.rxqueue = rxq;
        this.txqueue = txq;
        this.trunkName = trunk;
        this.statistics = stats;
        this.osPortName = this.serialPort.getOsPortName();
        try {
            this.serialOutputStream = this.serialPort.getOutputStream();
            this.bufferedInputStream = new BufferedInputStream(this.serialPort.getInputStream());
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "EmstpStateMachine " + this.osPortName + ": Unable to get i/o stream", e);
            this.done = true;
        }
    }

    public void setBytesPerSec(int bps) {
        this.bytesPerSec = bps;
    }

    public void setAddress(int address) {
        this.newAddress = address;
        this.needToSetAddress = true;
        this.commandPending = true;
    }

    public int getAddress() {
        return this.address;
    }

    public void setMaxMaster(int maxMaster) {
        this.newMaxMaster = maxMaster;
        this.needToSetMaxMaster = true;
        this.commandPending = true;
    }

    public void setMaxInfoFrames(int maxInfoFrames) {
        this.newMaxInfoFrames = maxInfoFrames;
        this.needToSetMaxInfoFrames = true;
        this.commandPending = true;
    }

    public void setUsageTimeout(int usageTimeout) {
        this.newUsageTimeout = usageTimeout;
        this.needToSetUsageTimeout = true;
        this.commandPending = true;
    }

    public void setTxThrottle(int txThrottle) {
        this.newTxThrottle = txThrottle;
        this.needToSetTxThrottle = true;
        this.commandPending = true;
    }

    public void pollStatistics() {
        this.needToGetStatistics = true;
        this.commandPending = true;
    }

    public void resetCounters() {
        this.needToResetStatistics = true;
        this.commandPending = true;
    }

    public void startTokenPassing() {
        this.needToStartTokenPassing = true;
        this.commandPending = true;
    }

    public void stopTokenPassing() {
        this.needToStopTokenPassing = true;
        this.commandPending = true;
    }

    public void exitCoprocessorMode() {
        this.needToExitProcessorMode = true;
        this.commandPending = true;
    }

    public void restartCoprocessorMode() {
        this.needToRestartCoprocessorMode = true;
        this.commandPending = true;
    }

    public void incrementQueueFullCount() {
        ++this.txQ_fullCount;
    }

    public void setBaudRate(BBacnetMstpBaudRate baudRate) {
        this.baud = baudRate;
    }

    @Override
    public void run() {
        this.needToStartTokenPassing = false;
        this.needToStopTokenPassing = false;
        this.needToGetStatistics = false;
        this.needToResetStatistics = false;
        if (log.isLoggable(Level.FINE)) {
            log.fine("EmstpStateMachine " + this.osPortName + ": starting");
        }
        this.inframe = new EmstpFrame(this.bufferedInputStream);
        this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
        block19: while (!this.done) {
            try {
                if (this.portDown) {
                    Thread.sleep(100L);
                }
                try {
                    switch (this.state) {
                        case ENTER_COPROCESSOR_MODE: {
                            this.enterCoprocessorMode(this.serialPort);
                            break;
                        }
                        case SET_ADDR: {
                            if (this.newAddress == -1) {
                                Thread.sleep(100L);
                                break;
                            }
                            this.inframe.flushInputStream();
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_ADDR, this.newAddress);
                            Thread.sleep(100L);
                            this.inframe.readResponse(this.serialPort);
                            this.portDown = false;
                            if (this.inframe.prefix == EmstpCommandPrefixEnum.ACK && this.inframe.command == EmstpCommandEnum.MSTP_SET_ADDR && this.inframe.statusByte == this.newAddress) {
                                this.address = this.newAddress;
                                this.needToSetAddress = false;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("EmstpStateMachine " + this.osPortName + ": MAC address is now " + this.address);
                                }
                                this.state = EmstpStateEnum.SET_MAX_MASTER;
                                break;
                            }
                            this.logInfo(this.state, this.inframe.command);
                            if (this.inframe.command != EmstpCommandEnum.EMSTP_RESPONSE_TIMEOUT) continue block19;
                            this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                            break;
                        }
                        case SET_MAX_MASTER: {
                            if (this.newMaxMaster == -1) {
                                Thread.sleep(100L);
                                break;
                            }
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_MAX_MASTER, this.newMaxMaster);
                            Thread.sleep(100L);
                            this.inframe.readResponse(this.serialPort);
                            this.portDown = false;
                            if (this.inframe.prefix == EmstpCommandPrefixEnum.ACK && this.inframe.command == EmstpCommandEnum.MSTP_SET_MAX_MASTER && this.inframe.statusByte == this.newMaxMaster) {
                                this.maxMaster = this.newMaxMaster;
                                this.needToSetMaxMaster = false;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("EmstpStateMachine " + this.osPortName + ": MaxMaster is now " + this.maxMaster);
                                }
                                this.state = EmstpStateEnum.SET_MAX_INFO;
                                break;
                            }
                            if (this.inframe.command == EmstpCommandEnum.EMSTP_RESPONSE_TIMEOUT) {
                                log.info("EmstpStateMachine " + this.osPortName + ": No response to MSTP_SET_MAX_MASTER, resetting port");
                                this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                                continue block19;
                            }
                            this.logInfo(this.state, this.inframe.command);
                            break;
                        }
                        case SET_MAX_INFO: {
                            if (this.newMaxInfoFrames == -1) {
                                Thread.sleep(100L);
                                break;
                            }
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_INFO_FRAMES, this.newMaxInfoFrames);
                            Thread.sleep(100L);
                            this.inframe.readResponse(this.serialPort);
                            this.portDown = false;
                            if (this.inframe.prefix == EmstpCommandPrefixEnum.ACK && this.inframe.command == EmstpCommandEnum.MSTP_SET_INFO_FRAMES && this.inframe.statusByte == this.newMaxInfoFrames) {
                                this.maxInfoFrames = this.newMaxInfoFrames;
                                this.needToSetMaxInfoFrames = false;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("EmstpStateMachine " + this.osPortName + ": MaxInfoFrames is now " + this.maxInfoFrames);
                                }
                                this.state = EmstpStateEnum.SET_USAGE_TIMEOUT;
                                break;
                            }
                            if (this.inframe.command == EmstpCommandEnum.EMSTP_RESPONSE_TIMEOUT) {
                                log.warning("EmstpStateMachine " + this.osPortName + ": No response to MSTP_SET_INFO_FRAMES, resetting port");
                                this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                                continue block19;
                            }
                            this.logInfo(this.state, this.inframe.command);
                            break;
                        }
                        case SET_USAGE_TIMEOUT: {
                            if (this.newUsageTimeout == -1) {
                                Thread.sleep(100L);
                                break;
                            }
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_USAGE, this.newUsageTimeout);
                            Thread.sleep(100L);
                            this.inframe.readResponse(this.serialPort);
                            this.portDown = false;
                            if (this.inframe.prefix == EmstpCommandPrefixEnum.ACK && this.inframe.command == EmstpCommandEnum.MSTP_SET_USAGE && this.inframe.statusByte == this.newUsageTimeout) {
                                this.usageTimeout = this.newUsageTimeout;
                                this.needToSetUsageTimeout = false;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("EmstpStateMachine " + this.osPortName + ": UsageTimeout is now " + this.usageTimeout);
                                }
                                this.state = EmstpStateEnum.SET_TX_THROTTLE;
                                break;
                            }
                            if (this.inframe.command == EmstpCommandEnum.EMSTP_RESPONSE_TIMEOUT) {
                                log.warning("EmstpStateMachine " + this.osPortName + ": No response to MSTP_SET_USAGE, resetting port");
                                this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                                continue block19;
                            }
                            log.warning("EmstpStateMachine " + this.osPortName + ": Received " + (Object)((Object)this.inframe.command) + " while expecting " + (Object)((Object)EmstpCommandEnum.MSTP_SET_USAGE) + ", retrying");
                            break;
                        }
                        case SET_TX_THROTTLE: {
                            if (this.newTxThrottle == -1) {
                                Thread.sleep(100L);
                                break;
                            }
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_TX_THROTTLE, this.newTxThrottle);
                            Thread.sleep(100L);
                            this.inframe.readResponse(this.serialPort);
                            this.portDown = false;
                            if (this.inframe.prefix == EmstpCommandPrefixEnum.ACK && this.inframe.command == EmstpCommandEnum.MSTP_SET_TX_THROTTLE && this.inframe.statusByte == this.newTxThrottle) {
                                this.txThrottle = this.newTxThrottle;
                                this.needToSetTxThrottle = false;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("EmstpStateMachine " + this.osPortName + ": TxThrottle is now " + this.txThrottle);
                                }
                                this.state = EmstpStateEnum.START_TOKEN_PASSING;
                                break;
                            }
                            if (this.inframe.command == EmstpCommandEnum.EMSTP_RESPONSE_TIMEOUT) {
                                log.warning("EmstpStateMachine " + this.osPortName + ": No response to MSTP_SET_TX_THROTTLE, resetting port");
                                this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                                continue block19;
                            }
                            log.warning("EmstpStateMachine " + this.osPortName + ": Received " + (Object)((Object)this.inframe.command) + " while expecting " + (Object)((Object)EmstpCommandEnum.MSTP_SET_TX_THROTTLE) + ", retrying");
                            break;
                        }
                        case START_TOKEN_PASSING: {
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_START, 0);
                            Thread.sleep(100L);
                            this.inframe.readResponse(this.serialPort);
                            this.portDown = false;
                            if (this.inframe.prefix == EmstpCommandPrefixEnum.ACK && this.inframe.command == EmstpCommandEnum.MSTP_START) {
                                log.info("EmstpStateMachine " + this.osPortName + ": Token passing started on " + this.trunkName);
                                this.bufferAvailable = this.inframe.isBufferAvailable();
                                this.state = EmstpStateEnum.CHECK_TRANSMIT;
                                this.keepAliveTicks = Clock.ticks();
                                this.needToStartTokenPassing = false;
                                break;
                            }
                            if (this.inframe.command == EmstpCommandEnum.EMSTP_RESPONSE_TIMEOUT) {
                                log.warning("EmstpStateMachine " + this.osPortName + ": No response to MSTP_START, resetting port");
                                this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                                continue block19;
                            }
                            log.warning("EmstpStateMachine " + this.osPortName + ": Received " + (Object)((Object)this.inframe.command) + " while expecting " + (Object)((Object)EmstpCommandEnum.MSTP_START) + ", retrying");
                            break;
                        }
                        case CHECK_TRANSMIT: {
                            if (this.commandPending) {
                                if (this.needToSetAddress) {
                                    this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_ADDR, this.newAddress);
                                    this.state = EmstpStateEnum.CHECK_RECEIVE;
                                    break;
                                }
                                if (this.needToSetMaxMaster) {
                                    this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_MAX_MASTER, this.newMaxMaster);
                                    this.state = EmstpStateEnum.CHECK_RECEIVE;
                                    break;
                                }
                                if (this.needToSetMaxInfoFrames) {
                                    this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_INFO_FRAMES, this.newMaxInfoFrames);
                                    this.state = EmstpStateEnum.CHECK_RECEIVE;
                                    break;
                                }
                                if (this.needToSetUsageTimeout) {
                                    this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_USAGE, this.newUsageTimeout);
                                    this.state = EmstpStateEnum.CHECK_RECEIVE;
                                    break;
                                }
                                if (this.needToSetTxThrottle) {
                                    this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_TX_THROTTLE, this.newTxThrottle);
                                    this.state = EmstpStateEnum.CHECK_RECEIVE;
                                    break;
                                }
                                if (this.needToGetStatistics) {
                                    this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_GET_STATS, 0);
                                    this.state = EmstpStateEnum.CHECK_RECEIVE;
                                    this.needToGetStatistics = false;
                                    break;
                                }
                                if (this.needToResetStatistics) {
                                    this.resetHostStatistics();
                                    this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_RESET_STATS, 0);
                                    this.state = EmstpStateEnum.CHECK_RECEIVE;
                                    break;
                                }
                                if (this.needToStartTokenPassing) {
                                    this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_START, 0);
                                    this.state = EmstpStateEnum.CHECK_RECEIVE;
                                    break;
                                }
                                if (this.needToStopTokenPassing) {
                                    this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_STOP, 0);
                                    this.state = EmstpStateEnum.CHECK_RECEIVE;
                                    break;
                                }
                                if (this.needToExitProcessorMode) {
                                    this.serialPort.setSerialPortParams((BBaudRate)BBacnetMstpSpecialBaudRate.cdcNormal, BSerialDataBits.dataBits8, BSerialStopBits.stopBit1, BSerialParity.none);
                                    this.serialPort.disableReceiveThreshold();
                                    this.serialPort.disableReceiveTimeout();
                                    this.serialPort.setSerialPortParams(this.baud, BSerialDataBits.dataBits8, BSerialStopBits.stopBit1, BSerialParity.none);
                                    this.needToExitProcessorMode = false;
                                    this.commandPending = false;
                                    break;
                                }
                                if (this.needToRestartCoprocessorMode) {
                                    this.needToRestartCoprocessorMode = false;
                                    this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                                    break;
                                }
                                this.commandPending = false;
                            }
                            if (this.bufferAvailable) {
                                EmstpFrame txFrame = this.txqueue.poll();
                                if (txFrame != null) {
                                    if (txFrame.command == EmstpCommandEnum.MSTP_APP_TX) {
                                        if (!this.txqueue.isEmpty()) {
                                            txFrame.setMoreMessagesToSend(true);
                                        }
                                        byte[] transmitBytes = txFrame.encodeToTransmit().toByteArray();
                                        this.serialOutputStream.write(transmitBytes, 0, transmitBytes.length);
                                        int sleepTime = transmitBytes.length * 1000 / this.bytesPerSec + 1;
                                        Thread.sleep(sleepTime);
                                        if (log.isLoggable(Level.FINE)) {
                                            log.fine("EmstpStateMachine " + this.osPortName + ": Sent " + (Object)((Object)txFrame.command) + " to " + txFrame.mstpFrame.getAddr() + " len:" + txFrame.payloadLength);
                                        }
                                    } else {
                                        log.warning("EmstpStateMachine " + this.osPortName + ": Unexpected msg type in txqueue: " + (Object)((Object)txFrame.command));
                                    }
                                }
                            } else {
                                Thread.sleep(10L);
                                if (this.txqueue.size() > 0 && log.isLoggable(Level.FINE)) {
                                    log.fine("EmstpStateMachine " + this.osPortName + ": " + this.txqueue.size() + " msgs are waiting for buffer available");
                                }
                            }
                            this.state = EmstpStateEnum.CHECK_RECEIVE;
                            break;
                        }
                        case CHECK_RECEIVE: {
                            int bytesAvailable = this.bufferedInputStream.available();
                            if (bytesAvailable < 0) {
                                ++this.ioErrorAvail;
                                log.severe("EmstpStateMachine " + this.osPortName + ": end of serial input stream");
                                Thread.sleep(1000L);
                                this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                                break;
                            }
                            if (bytesAvailable == 0) {
                                long ticks = Clock.ticks();
                                if (ticks - this.keepAliveTicks > 3000L) {
                                    this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_KEEP_ALIVE, 0);
                                    if (log.isLoggable(Level.FINE)) {
                                        log.fine("EmstpStateMachine " + this.osPortName + ": Send MSTP_KEEP_ALIVE");
                                    }
                                    ++this.keepAliveSent;
                                    this.keepAliveTicks = ticks;
                                    break;
                                }
                                Thread.sleep(10L);
                                this.state = EmstpStateEnum.CHECK_TRANSMIT;
                                break;
                            }
                            this.inframe.readResponse(this.serialPort);
                            this.portDown = false;
                            this.keepAliveTicks = Clock.ticks();
                            if (EmstpCommandEnum.EMSTP_RESPONSE_TIMEOUT == this.inframe.command) {
                                ++this.emstpResponseTimeout;
                                break;
                            }
                            if (EmstpCommandEnum.MSTP_COMMAND_UNKNOWN == this.inframe.command) {
                                log.warning("EmstpStateMachine " + this.osPortName + ": Received " + (Object)((Object)this.inframe.command));
                                ++this.unknownEmstpMessages;
                                break;
                            }
                            if (this.inframe.prefix == EmstpCommandPrefixEnum.ACK) {
                                this.bufferAvailable = this.inframe.isBufferAvailable();
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("EmstpStateMachine " + this.osPortName + ": Received ACK to " + (Object)((Object)this.inframe.command) + " bufferAvail:" + this.bufferAvailable);
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_APP_TX) {
                                    this.state = EmstpStateEnum.CHECK_TRANSMIT;
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_SET_ADDR) {
                                    this.needToSetAddress = false;
                                    this.address = this.inframe.getStatusByte();
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_SET_MAX_MASTER) {
                                    this.needToSetMaxMaster = false;
                                    this.maxMaster = this.inframe.getStatusByte();
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_SET_INFO_FRAMES) {
                                    this.needToSetMaxInfoFrames = false;
                                    this.maxInfoFrames = this.inframe.getStatusByte();
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_SET_USAGE) {
                                    this.needToSetUsageTimeout = false;
                                    this.usageTimeout = this.inframe.getStatusByte();
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_RESET_STATS) {
                                    this.needToResetStatistics = false;
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_START) {
                                    this.needToStartTokenPassing = false;
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_STOP) {
                                    this.needToStopTokenPassing = false;
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_SET_TX_THROTTLE) {
                                    this.needToSetTxThrottle = false;
                                    this.txThrottle = this.inframe.statusByte;
                                    break;
                                }
                                if (this.inframe.command != EmstpCommandEnum.MSTP_GET_STATS) continue block19;
                                this.needToGetStatistics = false;
                                ByteArrayInputStream in = new ByteArrayInputStream(this.inframe.getPayload());
                                this.statistics.setInputStream(in);
                                try {
                                    this.statistics.decodeStats();
                                    StringBuilder sb = new StringBuilder();
                                    sb.append("keepAliveSent    : ").append(this.keepAliveSent).append('\n');
                                    sb.append("txMsgBufferFull  : ").append(this.txQ_fullCount).append('\n');
                                    sb.append("unknownEmstpMsgs : ").append(this.unknownEmstpMessages).append('\n');
                                    sb.append("emstpRespTimeout : ").append(this.emstpResponseTimeout).append('\n');
                                    sb.append("ioErrorGetAvail  : ").append(this.ioErrorAvail).append('\n');
                                    sb.append("emstpTxqSize     : ").append(this.txqueue.size()).append('\n');
                                    sb.append("emstpRxqSize     : ").append(this.rxqueue.size()).append('\n');
                                    sb.append("invalidProtocol  : ").append(this.inframe.getInvalidProtocolCount()).append('\n');
                                    this.statistics.addClientSideStats(sb.toString());
                                }
                                catch (IOException e) {
                                    log.log(Level.WARNING, "EmstpStateMachine " + this.osPortName + ": Error decoding statistics", e);
                                }
                                String statsFile = TMP_DIR + File.separatorChar + this.trunkName;
                                try {
                                    AccessController.doPrivileged(() -> {
                                        try (FileWriter myWriter = new FileWriter(statsFile, false);){
                                            myWriter.write(this.statistics.toString());
                                        }
                                        catch (Throwable e) {
                                            log.log(Level.WARNING, "EmstpStateMachine " + this.osPortName + ": Cannot create statistics file " + statsFile, e);
                                        }
                                        return null;
                                    });
                                }
                                catch (PrivilegedActionException ioException) {
                                    log.log(Level.WARNING, "EmstpStateMachine " + this.osPortName + ": Unable to create or use mstp statistics file " + statsFile, ioException);
                                }
                                break;
                            }
                            if (this.inframe.prefix == EmstpCommandPrefixEnum.USOL) {
                                this.bufferAvailable = this.inframe.isBufferAvailable();
                                if (this.inframe.command == EmstpCommandEnum.MSTP_APP_RX) {
                                    byte[] srcbuf = this.inframe.getPayload();
                                    if (srcbuf != null) {
                                        MstpFrame appFrame = new MstpFrame();
                                        appFrame.setSrcAddr(srcbuf[0]);
                                        appFrame.setDataExpectingReply(srcbuf[1] == 1);
                                        byte[] data = new byte[srcbuf.length - 2];
                                        System.arraycopy(srcbuf, 2, data, 0, data.length);
                                        appFrame.setData(data);
                                        if (!this.rxqueue.offerLast(appFrame)) {
                                            log.warning("EmstpStateMachine " + this.osPortName + ": rxqueue full trying to post app message received from " + appFrame.getAddr() + ", length=" + data.length);
                                            break;
                                        }
                                        if (!log.isLoggable(Level.FINE)) continue block19;
                                        log.fine("EmstpStateMachine " + this.osPortName + ": app message received from " + appFrame.getAddr() + ", length=" + data.length);
                                        break;
                                    }
                                    log.warning("EmstpStateMachine " + this.osPortName + ": invalid data payload");
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_OK_TO_SEND) {
                                    this.state = EmstpStateEnum.CHECK_TRANSMIT;
                                    if (!log.isLoggable(Level.FINE)) continue block19;
                                    log.fine("EmstpStateMachine " + this.osPortName + ": Received " + (Object)((Object)this.inframe.command) + " bufferAvail:" + this.inframe.isBufferAvailable());
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_KEEP_ALIVE_EXPIRED) {
                                    log.warning("EmstpStateMachine " + this.osPortName + ": Received " + (Object)((Object)this.inframe.command));
                                    this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_KEEP_ALIVE, 0);
                                    ++this.keepAliveSent;
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_DEVICE_DOWN) {
                                    log.warning("EmstpStateMachine " + this.osPortName + ": " + (Object)((Object)this.inframe.command) + " address " + this.inframe.statusByte);
                                    int addr = this.inframe.statusByte;
                                    this.purgeDownDeviceFromTxQueue(addr);
                                    break;
                                }
                                log.warning("EmstpStateMachine " + this.osPortName + ": Received unexpected emstp frame type");
                                break;
                            }
                            if (this.inframe.prefix == EmstpCommandPrefixEnum.NAK) {
                                if (this.inframe.command == EmstpCommandEnum.EMSTP_RESPONSE_TIMEOUT) continue block19;
                                if (this.inframe.command == EmstpCommandEnum.EMSTP_INVALID_PROTOCOL_HEADER) break;
                                log.warning("EmstpStateMachine " + this.osPortName + ": Received NAK to " + (Object)((Object)this.inframe.command));
                                if (this.inframe.command == EmstpCommandEnum.MSTP_SET_ADDR) {
                                    this.needToSetAddress = false;
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_SET_MAX_MASTER) {
                                    this.needToSetMaxMaster = false;
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_SET_INFO_FRAMES) {
                                    this.needToSetMaxInfoFrames = false;
                                    break;
                                }
                                if (this.inframe.command == EmstpCommandEnum.MSTP_SET_USAGE) {
                                    this.needToSetUsageTimeout = false;
                                    break;
                                }
                                if (this.inframe.command != EmstpCommandEnum.MSTP_SET_TX_THROTTLE) continue block19;
                                this.needToSetTxThrottle = false;
                                break;
                            }
                            log.warning("EmstpStateMachine " + this.osPortName + ": Received unexpected message type " + (Object)((Object)this.inframe.command));
                            break;
                        }
                        default: {
                            log.warning("EmstpStateMachine " + this.osPortName + ": Undefined state machine state");
                        }
                    }
                }
                catch (IOException ioe) {
                    if (!this.portDown) {
                        log.log(Level.SEVERE, "EmstpStateMachine " + this.osPortName + ": IOException", ioe.getMessage());
                    }
                    this.portDown = true;
                }
            }
            catch (InterruptedException e) {
                log.log(Level.WARNING, "EmstpStateMachine " + this.osPortName + ": Interrupted", e.getMessage());
                this.serialPort.close();
                this.done = true;
            }
        }
    }

    private void logInfo(EmstpStateEnum command, EmstpCommandEnum result) {
        log.info("EmstpStateMachine " + this.osPortName + " state:" + (Object)((Object)command) + " result: " + (Object)((Object)result));
    }

    private void enterCoprocessorMode(BISerialPort serialPort) throws InterruptedException, IOException {
        serialPort.doResetPort();
        Thread.sleep(2000L);
        serialPort.setSerialPortParams((BBaudRate)BBacnetMstpSpecialBaudRate.cdcEmstp, BSerialDataBits.dataBits8, BSerialStopBits.stopBit1, BSerialParity.none);
        Thread.sleep(100L);
        serialPort.enableReceiveTimeout(1);
        serialPort.enableReceiveThreshold(512);
        serialPort.setSerialPortParams(this.baud, BSerialDataBits.dataBits8, BSerialStopBits.stopBit1, BSerialParity.none);
        Thread.sleep(100L);
        this.needToSetAddress = true;
        this.needToSetMaxMaster = true;
        this.needToSetMaxInfoFrames = true;
        this.needToSetUsageTimeout = true;
        this.needToSetTxThrottle = true;
        this.needToResetStatistics = true;
        this.needToStartTokenPassing = true;
        this.commandPending = true;
        log.info("EmstpStateMachine " + this.osPortName + ": Coprocessor mode");
        this.state = EmstpStateEnum.SET_ADDR;
    }

    private void sendCommand(OutputStream serialOutputStream, EmstpCommandEnum cmd, int val) throws IOException {
        byte[] bytes = new byte[]{(byte)(val & 0xFF)};
        EmstpFrame cmdFrame = new EmstpFrame(EmstpCommandPrefixEnum.REQ, cmd, bytes);
        byte[] sendBytes = cmdFrame.encodeToTransmit().toByteArray();
        serialOutputStream.write(sendBytes, 0, sendBytes.length);
        this.portDown = false;
    }

    private void emptyStream(InputStream in) {
        try {
            in.skip(in.available());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void resetHostStatistics() {
        this.keepAliveSent = 0;
        this.txQ_fullCount = 0;
        this.unknownEmstpMessages = 0;
        this.emstpResponseTimeout = 0;
        this.ioErrorAvail = 0;
        if (this.inframe != null) {
            this.inframe.resetInvalidProtocolCount();
        }
    }

    private void purgeDownDeviceFromTxQueue(int addr) {
        this.txqueue.removeIf(frame -> frame.getCommand() == EmstpCommandEnum.MSTP_APP_TX && frame.getMstpAddress() == addr);
    }
}

