/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platMstp;

import com.tridium.platMstp.EmstpCommandEnum;
import com.tridium.platMstp.EmstpCommandPrefixEnum;
import com.tridium.platMstp.MstpFrame;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.TextUtil;
import javax.baja.serial.BISerialPort;

public class EmstpFrame {
    BufferedInputStream bufferedInputStream;
    EmstpCommandPrefixEnum prefix;
    EmstpCommandEnum command;
    int protocolByte;
    int payloadLength;
    int statusByte;
    MstpFrame mstpFrame;
    byte[] payload;
    private int invalidProtocolCount;
    private boolean bufferAvailable;
    private boolean moreMessagesToSend;
    private int bytesRead;
    private int payloadOffset;
    private static final int RX_TIMEOUT = 50;
    private static final int MAX_READ_RETRY_COUNT = 40;
    private static final int PROTOCOL_EMSTP = 1;
    private static final int COMMAND_PREFIX_MASK = 192;
    private static final int COMMAND_MASK = 63;
    private static final int STATUS_BYTE_MASK = 127;
    private static final int BUFFER_AVAIL_BIT_MASK = 128;
    private static final int BUFFER_AVAIL = 128;
    private static final int APP_TX_MESSAGES_WAITING = 1;
    private static final int APP_TX_NO_MESSAGES_WAITING = 0;
    private static final int APP_TX_DATA_EXPECTING_REPLY = 1;
    private static final int APP_TX_DATA_NOT_EXPECTING_REPLY = 0;
    private static final int EMSTP_HEADER_SIZE = 4;
    private static final int EMSTP_MIN_PAYLOAD = 1;
    private static final int EMSTP_MAX_PAYLOAD = 1500;
    public static Logger log = Logger.getLogger("plat.mstp");

    public EmstpFrame(BufferedInputStream inputStream) {
        this.bufferedInputStream = inputStream;
        this.prefix = EmstpCommandPrefixEnum.NAK;
        this.command = EmstpCommandEnum.MSTP_COMMAND_UNKNOWN;
    }

    public EmstpFrame(EmstpCommandPrefixEnum prefix, EmstpCommandEnum command, MstpFrame mstpFrame) {
        this.prefix = prefix;
        this.command = command;
        this.mstpFrame = mstpFrame;
        this.payloadLength = mstpFrame.getData().length + 3;
        this.moreMessagesToSend = false;
    }

    public EmstpFrame(EmstpCommandPrefixEnum prefix, EmstpCommandEnum command, byte[] payload) {
        this.prefix = prefix;
        this.command = command;
        this.payload = (byte[])payload.clone();
        this.payloadLength = this.payload.length;
    }

    public void setMoreMessagesToSend(boolean more) {
        this.moreMessagesToSend = more;
    }

    public ByteArrayOutputStream encodeToTransmit() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (this.mstpFrame != null) {
            outputStream.write(1);
            outputStream.write(this.prefix.getPrefix() | this.command.getCommand());
            outputStream.write(this.payloadLength >> 8 & 0xFF);
            outputStream.write(this.payloadLength & 0xFF);
            outputStream.write(this.moreMessagesToSend ? 1 : 0);
            outputStream.write(this.mstpFrame.getAddr());
            outputStream.write(this.mstpFrame.getDataExpectingReply() ? 1 : 0);
            outputStream.write(this.mstpFrame.getData());
        } else if (this.payload != null) {
            outputStream.write(1);
            outputStream.write(this.prefix.getPrefix() | this.command.getCommand());
            outputStream.write(this.payloadLength >> 8 & 0xFF);
            outputStream.write(this.payloadLength & 0xFF);
            outputStream.write(this.payload);
        }
        return outputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readResponse(BISerialPort port) throws IOException, InterruptedException {
        this.reset();
        ReadState state = ReadState.READ_HEADER;
        long retryCount = 0L;
        int rxBytesAvailable = 0;
        block5: while (true) {
            if ((rxBytesAvailable = this.bufferedInputStream.available()) == 0) {
                if (++retryCount == 40L) {
                    log.warning((Object)((Object)this.command) + " on " + port.getOsPortName() + ", state:" + (Object)((Object)state) + " payloadLength:" + this.payloadLength + " bytesRead:" + this.bytesRead);
                    this.command = EmstpCommandEnum.EMSTP_RESPONSE_TIMEOUT;
                    return;
                }
                Thread.sleep(50L);
                continue;
            }
            retryCount = 0L;
            switch (state) {
                case READ_HEADER: {
                    if (rxBytesAvailable < 4) continue block5;
                    this.protocolByte = this.bufferedInputStream.read();
                    ++this.bytesRead;
                    if (this.protocolByte != 1) {
                        ++this.invalidProtocolCount;
                        this.command = EmstpCommandEnum.EMSTP_INVALID_PROTOCOL_HEADER;
                        this.flushInputStream();
                        return;
                    }
                    int inputByte = this.bufferedInputStream.read();
                    ++this.bytesRead;
                    this.prefix = EmstpCommandPrefixEnum.getEnum(inputByte & 0xC0);
                    this.command = EmstpCommandEnum.getEnum(inputByte & 0x3F);
                    if (!this.validateCommand(this.command)) {
                        log.warning("Invalid emstp header on " + port.getOsPortName() + ": " + TextUtil.byteToHexString((int)this.protocolByte) + " " + TextUtil.byteToHexString((int)inputByte));
                        this.command = EmstpCommandEnum.EMSTP_INVALID_PROTOCOL_HEADER;
                        this.flushInputStream();
                        return;
                    }
                    int lenhigh = this.bufferedInputStream.read();
                    ++this.bytesRead;
                    int lenlow = this.bufferedInputStream.read();
                    ++this.bytesRead;
                    this.payloadLength = (lenhigh << 8) + lenlow;
                    if (this.payloadLength < 1 || this.payloadLength > 1500) {
                        log.warning("Invalid emstp payload length " + this.payloadLength + " on " + port.getOsPortName());
                        this.command = EmstpCommandEnum.EMSTP_INVALID_PROTOCOL_HEADER;
                        this.flushInputStream();
                        return;
                    }
                    state = ReadState.READ_STATUS_BYTE;
                    continue block5;
                }
                case READ_STATUS_BYTE: {
                    this.statusByte = this.bufferedInputStream.read();
                    ++this.bytesRead;
                    this.bufferAvailable = (this.statusByte & 0x80) == 128;
                    this.statusByte &= 0x7F;
                    if (this.bytesRead == this.payloadLength + 4) {
                        return;
                    }
                    this.payload = new byte[this.payloadLength - 1];
                    this.payloadOffset = 0;
                    state = ReadState.READ_PAYLOAD;
                    continue block5;
                }
                case READ_PAYLOAD: {
                    int numBytesToRead = Math.min(rxBytesAvailable, this.payloadLength - this.payloadOffset - 1);
                    int actuallyRead = this.bufferedInputStream.read(this.payload, this.payloadOffset, numBytesToRead);
                    this.bytesRead += actuallyRead;
                    if (actuallyRead != numBytesToRead) {
                        log.warning("While reading emstp payload, expected to read " + numBytesToRead + " bytes, but only read " + actuallyRead);
                    }
                    this.payloadOffset += actuallyRead;
                    if (this.payloadOffset >= this.payloadLength - 1) return;
                    continue block5;
                }
            }
            break;
        }
        log.warning("Unexpected ReadState while reading emstp response");
    }

    public void flushInputStream() throws IOException {
        if (this.bufferedInputStream != null) {
            ByteArrayOutputStream flushedBytes = new ByteArrayOutputStream(this.bufferedInputStream.available());
            while (this.bufferedInputStream.available() > 0) {
                flushedBytes.write(this.bufferedInputStream.read());
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Flushed bytes:" + TextUtil.bytesToHexString((byte[])flushedBytes.toByteArray()));
            }
        }
    }

    public EmstpCommandEnum getCommand() {
        return this.command;
    }

    public int getMstpAddress() {
        if (this.mstpFrame != null) {
            return this.mstpFrame.getAddr();
        }
        return -1;
    }

    public boolean isBufferAvailable() {
        return this.bufferAvailable;
    }

    public int getStatusByte() {
        return this.statusByte;
    }

    public byte[] getPayload() {
        return (byte[])this.payload.clone();
    }

    public int getInvalidProtocolCount() {
        return this.invalidProtocolCount;
    }

    public void resetInvalidProtocolCount() {
        this.invalidProtocolCount = 0;
    }

    private void reset() {
        this.prefix = EmstpCommandPrefixEnum.NAK;
        this.command = EmstpCommandEnum.MSTP_COMMAND_UNKNOWN;
        this.payloadLength = 0;
        this.statusByte = 0;
        this.mstpFrame = null;
        this.payload = null;
        this.bytesRead = 0;
    }

    private boolean validateCommand(EmstpCommandEnum command) {
        switch (command) {
            case MSTP_START: 
            case MSTP_STOP: 
            case MSTP_GET_STATS: 
            case MSTP_RESET_STATS: 
            case MSTP_KEEP_ALIVE_EXPIRED: 
            case MSTP_DEVICE_DOWN: 
            case MSTP_APP_TX: 
            case MSTP_APP_RX: 
            case MSTP_OK_TO_SEND: 
            case MSTP_KEEP_ALIVE: 
            case MSTP_SET_ADDR: 
            case MSTP_GET_ADDR: 
            case MSTP_SET_MAX_MASTER: 
            case MSTP_SET_USAGE: 
            case MSTP_SET_INFO_FRAMES: 
            case MSTP_SET_TX_THROTTLE: {
                return true;
            }
        }
        return false;
    }

    static enum ReadState {
        READ_HEADER,
        READ_STATUS_BYTE,
        READ_PAYLOAD;

    }
}

