/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platMstp;

import com.tridium.platMstp.BBacnetMstpPlatformService;
import com.tridium.platMstp.MstpFrame;
import com.tridium.platMstp.MstpListener;
import com.tridium.sys.Nre;
import java.io.File;
import java.security.AccessController;
import java.util.HashMap;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.PortDeniedException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BBacnetMstpPlatformServiceNpsdk
extends BBacnetMstpPlatformService {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetMstpPlatformServiceNpsdk.class);
    private static boolean nativesLoaded = false;
    private HashMap<Integer, Runnable> trunkListeners = new HashMap();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        String mstplibPath = Nre.getNiagaraHome() + File.separator + "bin" + File.separator + "libmstpnpsdk.so";
        return AccessController.doPrivileged(() -> new File(mstplibPath).exists());
    }

    protected synchronized boolean loadLibraries() {
        if (nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                log.fine("Loading mstpnpsdk native library");
                System.loadLibrary("mstpnpsdk");
                nativesLoaded = true;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Cannot load mstpnpsdk native library", e);
            }
            return nativesLoaded;
        });
    }

    public void serviceStarted() throws Exception {
        if (!this.initMstp()) {
            throw new RuntimeException("failed to initialize mstp platform driver");
        }
        log.fine("mstp initialization complete");
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        this.cleanupMstp();
        log.fine("mstp cleanup complete");
        super.serviceStopped();
    }

    @Override
    protected boolean initMstp() {
        return this.loadLibraries() && this.init0();
    }

    @Override
    protected void cleanupMstp() {
        this.cleanup0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startDriver(String trunk, String osSerialPortName, int baudRate, int tsAddr, int maxMaster, int maxFrames, MstpListener linkListener) {
        log.fine("Starting mstp driver: " + osSerialPortName + " at " + baudRate + " baud, tsAddr=" + tsAddr + " maxMaster=" + maxMaster + " maxInfoFrames=" + maxFrames);
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        if (osSerialPortName == null) {
            throw new NullPointerException("Can start MSTP driver on null device");
        }
        try {
            this.lockSerial(osSerialPortName);
        }
        catch (PortDeniedException pde) {
            log.severe("Could not open mstp on serial port " + osSerialPortName + ", failed to obtain lock");
            throw new RuntimeException("Cannot open mstp");
        }
        boolean success = false;
        try {
            int handle = this.openDriver0(osSerialPortName, baudRate, tsAddr, maxMaster, maxFrames);
            if (handle == -1) {
                log.severe("Could not open mstp on serial port: " + osSerialPortName);
                throw new RuntimeException("Cannot open mstp");
            }
            this.handleToName.put(handle, osSerialPortName);
            MstpTrunkListener trunkListener = new MstpTrunkListener(handle, linkListener);
            Thread trunkListenerThread = new Thread((Runnable)trunkListener, "mstp" + handle);
            trunkListenerThread.start();
            trunkListener.myThread = trunkListenerThread;
            this.trunkListeners.put(handle, trunkListener);
            success = true;
            int n = handle;
            return n;
        }
        finally {
            if (!success) {
                try {
                    log.fine("Failed to open MSTP, unlocking serial device " + osSerialPortName);
                    this.unlockSerial(osSerialPortName);
                }
                catch (PortDeniedException pde) {
                    log.log(Level.WARNING, "Failed to unlock mstp serial device " + osSerialPortName, pde);
                }
            }
        }
    }

    @Override
    public void stopDriver(int handle) {
        log.fine("stopping mstp driver");
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        MstpTrunkListener ls = (MstpTrunkListener)this.trunkListeners.get(handle);
        if (ls == null) {
            throw new RuntimeException("Invalid handle " + handle);
        }
        ls.done = true;
        ls.myThread.interrupt();
        this.closeDriver0(handle);
        String osPortName = (String)this.handleToName.remove(handle);
        try {
            this.unlockSerial(osPortName);
        }
        catch (PortDeniedException pde) {
            log.log(Level.SEVERE, "Failed to unlock mstp serial device " + osPortName, pde);
        }
        log.fine("mstp driver stopped");
    }

    @Override
    public void sendFrame(int handle, byte destAddr, byte[] packet, boolean dataExpectingReply) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        this.sendFrame0(handle, (byte)(destAddr & 0xFF), packet, dataExpectingReply);
    }

    @Override
    public void setBaudRate(int handle, int baudRate) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.fine("setting baud rate to " + baudRate);
        this.setBaudRate0(handle, baudRate);
    }

    @Override
    public void setMaxMaster(int handle, int maxMaster) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.fine("setting max master to " + maxMaster);
        this.setMaxMaster0(handle, maxMaster);
    }

    @Override
    public void setMaxInfoFrames(int handle, int maxInfoFrames) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.fine("setting max info frames to " + maxInfoFrames);
        this.setMaxInfoFrames0(handle, maxInfoFrames);
    }

    @Override
    public void setAddress(int handle, int macAddress) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.fine("setting this station address to " + macAddress);
        this.setAddress0(handle, macAddress);
    }

    @Override
    public int getAddress(int handle) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        int addr = this.getAddress0(handle);
        log.fine("getAddress0 returned " + addr);
        return addr;
    }

    @Override
    public void setParameter(int handle, String name, String value) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        if (name == null || value == null) {
            throw new RuntimeException("Null mstp parameter");
        }
        log.fine("setting mstp parameter " + name + " to " + value);
        this.setParameter0(handle, name, value);
    }

    private native boolean init0();

    private native void cleanup0();

    private native int openDriver0(String var1, int var2, int var3, int var4, int var5);

    private native void closeDriver0(int var1);

    private native void rcvFrame0(int var1, MstpFrame var2);

    private native void sendFrame0(int var1, byte var2, byte[] var3, boolean var4);

    private native void setBaudRate0(int var1, int var2);

    private native void setMaxMaster0(int var1, int var2);

    private native void setMaxInfoFrames0(int var1, int var2);

    private native void setAddress0(int var1, int var2);

    private native int getAddress0(int var1);

    private native void setParameter0(int var1, String var2, String var3);

    class MstpTrunkListener
    implements Runnable {
        int handle;
        MstpListener linkListener;
        Thread myThread;
        boolean done = false;

        public MstpTrunkListener(int handle, MstpListener linkListener) {
            this.handle = handle;
            this.linkListener = linkListener;
        }

        @Override
        public void run() {
            MstpFrame frame = new MstpFrame();
            BBacnetMstpPlatformService.log.fine("mstp trunk listener starting");
            while (!this.done) {
                try {
                    BBacnetMstpPlatformServiceNpsdk.this.rcvFrame0(this.handle, frame);
                    if (this.linkListener == null) continue;
                    this.linkListener.receiveFrame(frame.getAddr(), frame.getData(), frame.getDataExpectingReply());
                }
                catch (Exception e) {
                    if (this.done) continue;
                    e.printStackTrace();
                }
            }
            BBacnetMstpPlatformService.log.fine("mstp trunk listener done");
        }
    }
}

