/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui.chart;

import com.tridium.ui.theme.Theme;
import java.text.DecimalFormat;
import javax.baja.chart.BChart;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.JoinTable;
import javax.baja.chart.Series;
import javax.baja.chart.SimpleChartModel;
import javax.baja.chart.binding.BTableChartBinding;
import javax.baja.chart.binding.BoundChartModel;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BEllipseGeom;
import javax.baja.gx.BFont;
import javax.baja.gx.BGeom;
import javax.baja.gx.BPathGeom;
import javax.baja.gx.BPen;
import javax.baja.gx.EllipseGeom;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="font", type="BFont", defaultValue="BFont.NULL"), @NiagaraProperty(name="showSliceLabels", type="boolean", defaultValue="true"), @NiagaraProperty(name="pen", type="BPen", defaultValue="BPen.make(1)"), @NiagaraProperty(name="stroke", type="BBrush", defaultValue="BColor.black.toBrush()")})
public class BRelativeContributionChart
extends BChart {
    @Generated
    public static final Property font = BRelativeContributionChart.newProperty((int)0, (BValue)BFont.NULL, null);
    @Generated
    public static final Property showSliceLabels = BRelativeContributionChart.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property pen = BRelativeContributionChart.newProperty((int)0, (BValue)BPen.make((double)1.0), null);
    @Generated
    public static final Property stroke = BRelativeContributionChart.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRelativeContributionChart.class);
    double[] values;
    String[] lables;
    BBrush[] brush;
    private static final int ABOVE = 0;
    private static final int BELOW = 2;
    private static final int RIGHT = 0;
    private static final int LEFT = 2;
    private static final int CENTER = 1;
    private static final BDouble ZERO = BDouble.make((double)0.0);
    private DecimalFormat ratioFormat = new DecimalFormat("0.00");
    private JoinTable joinTable;
    private int pieCount;
    private int pieColumns = -1;
    private Pie[] pies;
    private double cellWidth;
    private double cellHeight;
    private int pr;

    @Generated
    public BFont getFont() {
        return (BFont)this.get(font);
    }

    @Generated
    public void setFont(BFont v) {
        this.set(font, (BValue)v, null);
    }

    @Generated
    public boolean getShowSliceLabels() {
        return this.getBoolean(showSliceLabels);
    }

    @Generated
    public void setShowSliceLabels(boolean v) {
        this.setBoolean(showSliceLabels, v, null);
    }

    @Generated
    public BPen getPen() {
        return (BPen)this.get(pen);
    }

    @Generated
    public void setPen(BPen v) {
        this.set(pen, (BValue)v, null);
    }

    @Generated
    public BBrush getStroke() {
        return (BBrush)this.get(stroke);
    }

    @Generated
    public void setStroke(BBrush v) {
        this.set(stroke, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRelativeContributionChart() {
        this.setModel((ChartModel)new Model());
    }

    public BRelativeContributionChart(ChartModel model) {
        super(model);
    }

    public BRelativeContributionChart(String[] labels, double[] values) {
        this.setModel(labels, values);
    }

    private double processSeries(Series series) {
        double contribution = 0.0;
        for (int i = 0; i < series.getRowCount(); ++i) {
            contribution += ((BDouble)series.getValue(i, 1)).getDouble();
        }
        return contribution;
    }

    public void setModel(ChartModel model) {
        this.joinTable = null;
        super.setModel(model);
    }

    public ChartModel setModel(String[] labels, double[] values) {
        SimpleChartModel model = new SimpleChartModel();
        if (labels.length != values.length) {
            String msg = "Label list and value list must have equal lengths. (" + labels.length + " != " + values.length + ")";
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < labels.length; ++i) {
            SingleValueSeries series = new SingleValueSeries(labels[i], values[i]);
            series.setBrush(this.brush[i]);
            model.add(new ChartSpec((Series)series));
        }
        this.setModel((ChartModel)model);
        return model;
    }

    public void setPieLayout(int columns) {
        this.pieColumns = columns;
    }

    public boolean usesXAxis() {
        return false;
    }

    public boolean usesYAxis() {
        return false;
    }

    public void doLayout(BWidget[] kids) {
        double sqrt;
        double w = this.getWidth();
        double h = this.getHeight();
        ChartModel model = this.getModel();
        int specCount = model.getSpecCount();
        if (specCount == 0) {
            this.pies = new Pie[0];
            return;
        }
        if (this.joinTable == null) {
            this.joinTable = JoinTable.make((Series[])model.getAllSeries(), (int)0);
        }
        this.pieCount = this.joinTable.getRowCount();
        int pc = 1;
        pc = this.pieColumns > 0 ? this.pieColumns : ((double)((int)(sqrt = Math.sqrt(this.pieCount))) < sqrt ? (int)sqrt + 1 : (int)sqrt);
        if (pc < 1) {
            pc = 1;
        }
        this.pr = this.pieCount / pc;
        if (this.pr * pc < this.pieCount) {
            ++this.pr;
        }
        this.cellWidth = w / (double)pc;
        this.cellHeight = h / (double)this.pr;
        this.pies = new Pie[this.pieCount];
        double y = 0.0;
        int pieIndex = 0;
        for (int row = 0; row < this.pr; ++row) {
            double x = 0.0;
            for (int col = 0; col < pc; ++col) {
                this.pies[pieIndex] = this.makePie(x, y, this.cellWidth, this.cellHeight, this.joinTable, pieIndex);
                x += this.cellWidth;
                if (++pieIndex == this.pieCount) break;
            }
            y += this.cellHeight;
            if (pieIndex == this.pieCount) break;
        }
    }

    public void doPaint(Graphics g) {
        int len = this.pr;
        int col = 0;
        int row = 0;
        for (int i = 0; i < this.pies.length; ++i) {
            Pie pie = this.pies[i];
            boolean zero = true;
            for (int j = 0; j < pie.slices.length; ++j) {
                Slice slice = pie.slices[j];
                if (null == slice || !(slice.ratio > 0.0)) continue;
                zero = false;
                break;
            }
            if (zero) {
                double w = this.cellWidth;
                double h = this.cellHeight;
                double d = (Math.min(w / 2.0, h / 2.0) - 20.0) * 2.0;
                double x = (w - d) / 2.0;
                double y = (h - d) / 2.0;
                EllipseGeom elip = new EllipseGeom(x += (double)col * this.cellWidth, y += (double)row * this.cellHeight, d, d);
                g.setBrush(BColor.make((String)"#eee"));
                g.fill((IGeom)elip);
                g.setBrush(BColor.black);
                g.stroke((IGeom)elip);
            } else {
                pie.paint(g);
            }
            if (++col < len) continue;
            col = 0;
            ++row;
        }
    }

    private Pie makePie(double x, double y, double w, double h, JoinTable table, int row) {
        double total = 0.0;
        int colCount = table.getColumnCount();
        for (int col = 0; col < colCount; ++col) {
            BINumeric value = (BINumeric)table.getValue(row, col);
            if (null == value) continue;
            total += value.getNumeric();
        }
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double r = Math.min(w / 2.0, h / 2.0) - 20.0;
        double theta = 0.0;
        Slice[] slices = new Slice[colCount];
        for (int col = 0; col < colCount; ++col) {
            double ratio;
            BINumeric tableValue = (BINumeric)table.getValue(row, col);
            double value = 0.0;
            if (null != tableValue) {
                value = ((BINumeric)table.getValue(row, col)).getNumeric();
            }
            if (Math.abs((ratio = value / total) - 1.0) < 1.0E-7) {
                BEllipseGeom ellipse = BEllipseGeom.make((double)(cx - r), (double)(cy - r), (double)(2.0 * r), (double)(2.0 * r));
                double sliceTheta = ratio * 2.0 * Math.PI;
                LabelLocation labelLoc = this.creatLabelLocation(cx, cy, r, theta += sliceTheta, sliceTheta);
                slices[col] = new Slice(value, ratio, table.getSeries(col), (BGeom)ellipse, labelLoc);
                continue;
            }
            IPathGeom.Segment[] segs = new IPathGeom.Segment[4];
            segs[0] = new IPathGeom.MoveTo(true, cx, cy);
            double sx1 = cx + r * Math.sin(theta);
            double sy1 = cy - r * Math.cos(theta);
            segs[1] = new IPathGeom.LineTo(true, sx1, sy1);
            double sliceTheta = ratio * 2.0 * Math.PI;
            double sx2 = cx + r * Math.sin(theta += sliceTheta);
            double sy2 = cy - r * Math.cos(theta);
            segs[2] = new IPathGeom.ArcTo(true, r, r, 0.0, sliceTheta > Math.PI, true, sx2, sy2);
            segs[3] = new IPathGeom.LineTo(true, cx, cy);
            LabelLocation labelLoc = this.creatLabelLocation(cx, cy, r, theta, sliceTheta);
            slices[col] = new Slice(value, ratio, table.getSeries(col), (BGeom)BPathGeom.make((IPathGeom.Segment[])segs), labelLoc);
        }
        return new Pie(slices);
    }

    private LabelLocation creatLabelLocation(double cx, double cy, double r, double theta, double sliceTheta) {
        double tTheta = theta - sliceTheta / 2.0;
        double tx = cx + (r + 5.0) * Math.sin(tTheta);
        double ty = cy - (r + 5.0) * Math.cos(tTheta);
        LabelLocation labelLoc = new LabelLocation(tx, ty, this.getTextHAlign(tTheta), this.getTextVAlign(tTheta));
        return labelLoc;
    }

    private int getTextHAlign(double theta) {
        if (theta > 5.969026041820607 || theta < 0.3141592653589793 || theta > 2.827433388230814 && theta < 3.455751918948773) {
            return 1;
        }
        if (theta < Math.PI) {
            return 0;
        }
        return 2;
    }

    private int getTextVAlign(double theta) {
        if (theta >= 5.497787143782138 || theta <= 0.7853981633974483) {
            return 0;
        }
        if (theta > 0.7853981633974483 && theta < 2.356194490192345 || theta > 3.9269908169872414 && theta < 5.497787143782138) {
            return 1;
        }
        return 2;
    }

    private static class SingleValueSeries
    extends Series {
        String label;
        BDouble value;

        public SingleValueSeries(String label, double value) {
            this.label = label;
            this.value = BDouble.make((double)value);
        }

        public String getName() {
            return this.label;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "id";
            }
            return this.label;
        }

        public String getColumnDisplayName(int col) {
            return this.getColumnName(col);
        }

        public Type getColumnType(int col) {
            return BDouble.TYPE;
        }

        public int getRowCount() {
            return 1;
        }

        public Object getValue(int row, int col) {
            if (col == 1) {
                return this.value;
            }
            return ZERO;
        }

        public Object getMin(int col) {
            return this.getValue(0, col);
        }

        public Object getMax(int col) {
            return this.getValue(0, col);
        }
    }

    private static class LabelLocation {
        double x;
        double y;
        int halign;
        int valign;

        public LabelLocation(double x, double y, int halign, int valign) {
            this.x = x;
            this.y = y;
            this.halign = halign;
            this.valign = valign;
        }
    }

    private static class Slice {
        double value;
        double ratio;
        Series series;
        BGeom path;
        LabelLocation labelLoc;

        public Slice(double value, double ratio, Series series, BGeom path, LabelLocation labelLoc) {
            this.value = value;
            this.ratio = ratio;
            this.series = series;
            this.path = path;
            this.labelLoc = labelLoc;
        }
    }

    private class Pie {
        protected Slice[] slices;

        public Pie(Slice[] slices) {
            this.slices = slices;
        }

        public void paint(Graphics g) {
            for (int i = 0; i < this.slices.length; ++i) {
                if (null == this.slices[i] || this.slices[i].ratio == 0.0) continue;
                BBrush brush = this.slices[i].series.getBrush();
                if (brush == null) {
                    return;
                }
                g.setBrush(brush);
                g.fill((IGeom)this.slices[i].path);
            }
            BFont font = BRelativeContributionChart.this.getFont();
            if (font.isNull()) {
                font = Theme.widget().getTextFont();
            }
            g.setFont(font);
            g.setPen(BRelativeContributionChart.this.getPen());
            g.setBrush(BRelativeContributionChart.this.getStroke());
            for (int i = 0; i < this.slices.length; ++i) {
                if (null == this.slices[i] || this.slices[i].ratio == 0.0) continue;
                g.stroke((IGeom)this.slices[i].path);
                LabelLocation loc = this.slices[i].labelLoc;
                String text = BRelativeContributionChart.this.ratioFormat.format(this.slices[i].value) + "(" + BRelativeContributionChart.this.ratioFormat.format(this.slices[i].ratio * 100.0) + "%)";
                double tx = 0.0;
                double ty = 0.0;
                tx = loc.halign == 2 ? loc.x - font.width(text) : (loc.halign == 1 ? loc.x - font.width(text) / 2.0 : loc.x);
                ty = loc.valign == 0 ? loc.y : (loc.valign == 1 ? loc.y + font.getAscent() / 2.0 : loc.y + font.getAscent());
                g.drawString(text, tx, ty);
            }
        }
    }

    class Model
    extends BoundChartModel {
        Model() {
        }

        public synchronized void doSyncBindings() {
            BBinding[] allBindings = BRelativeContributionChart.this.getBindings();
            super.doSyncBindings();
            if (this.getSpecCount() == 0) {
                return;
            }
            BRelativeContributionChart.this.values = new double[this.getSpecCount()];
            BRelativeContributionChart.this.lables = new String[this.getSpecCount()];
            BRelativeContributionChart.this.brush = new BBrush[this.getSpecCount()];
            for (int i = 0; i < this.getSpecCount(); ++i) {
                ChartSpec spec = this.getSpec(i);
                BRelativeContributionChart.this.values[i] = BRelativeContributionChart.this.processSeries(spec.getSeries());
                BRelativeContributionChart.this.lables[i] = ((BTableChartBinding)allBindings[i]).getSeriesName() + "(" + BRelativeContributionChart.this.ratioFormat.format(BRelativeContributionChart.this.values[i]) + ")";
                BRelativeContributionChart.this.brush[i] = spec.getSeries().getBrush();
            }
            BRelativeContributionChart.this.setModel(BRelativeContributionChart.this.lables, BRelativeContributionChart.this.values);
        }
    }
}

