/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.ui.BNodeSelectionFe;
import com.tridiumx.analytics.ui.Ui;
import com.tridiumx.analytics.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"analytics:AnalyticService"}, requiredPermissions="r")})
@NiagaraActions(value={@NiagaraAction(name="nodeSelection"), @NiagaraAction(name="updateTable")})
public class BAnalyticServiceView
extends BWbComponentView {
    @Generated
    public static final Action nodeSelection = BAnalyticServiceView.newAction((int)0, null);
    @Generated
    public static final Action updateTable = BAnalyticServiceView.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAnalyticServiceView.class);
    static Comparator<Row> byAlertA = (r1, r2) -> r1.alert.compareTo(r2.alert);
    static Comparator<Row> byAlertD = (r1, r2) -> r2.alert.compareTo(r1.alert);
    static Comparator<Row> byAlertCountA = (r1, r2) -> r1.alertCount - r2.alertCount;
    static Comparator<Row> byAlertCountD = (r1, r2) -> r2.alertCount - r1.alertCount;
    static Comparator<Row> byCostA = (r1, r2) -> (int)(r1.cost - r2.cost);
    static Comparator<Row> byCostD = (r1, r2) -> (int)(r2.cost - r1.cost);
    static Comparator<Row> byNodeA = (r1, r2) -> r1.node.compareTo(r2.node);
    static Comparator<Row> byNodeD = (r1, r2) -> r2.node.compareTo(r1.node);
    static Comparator<Row> byNormalCountA = (r1, r2) -> r1.normalCount - r2.normalCount;
    static Comparator<Row> byNormalCountD = (r1, r2) -> r2.normalCount - r1.normalCount;
    private BRadioButton alertButton;
    private BRadioButton allButton;
    private BEdgePane edgePane;
    private BRadioButton nodeButton;
    private String selectedNode = "slot:/";
    private BAnalyticService service;
    private BTable table;
    private BTree tree;

    @Generated
    public void nodeSelection() {
        this.invoke(nodeSelection, null, null);
    }

    @Generated
    public void updateTable() {
        this.invoke(updateTable, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAnalyticServiceView() {
        BEdgePane content = new BEdgePane();
        this.edgePane = new BEdgePane();
        this.table = new BTable();
        this.table.setController((TableController)new MyController());
        this.table.setMultipleSelection(false);
        this.tree = BNodeSelectionFe.makeTree((BWbPlugin)this);
        ToggleCommandGroup group = new ToggleCommandGroup();
        BGridPane gp = new BGridPane(3);
        this.allButton = new BRadioButton(group, Ui.lex("all"), true);
        gp.add(null, (BValue)this.allButton);
        this.alertButton = new BRadioButton(group, Ui.lex("byAlert"));
        gp.add(null, (BValue)this.alertButton);
        this.nodeButton = new BRadioButton(group, Ui.lex("byNode"));
        gp.add(null, (BValue)this.nodeButton);
        this.edgePane.setCenter((BWidget)this.table);
        this.edgePane.setTop((BWidget)Ui.solid((BWidget)gp, 1, 0, 0, 1));
        BSplitPane splitPane = new BSplitPane((BWidget)new BScrollPane((BWidget)this.tree), (BWidget)this.edgePane);
        splitPane.setDividerPosition(25.0);
        content.setCenter((BWidget)new BScrollPane((BWidget)splitPane));
        gp = new BGridPane(6);
        BButton b = new BButton(Ui.hyperlink((BWidget)this, Ui.lex("alerts"), Utils.iconAlert, BOrd.make((String)"slot:alerts")));
        gp.add(null, (BValue)b);
        b = new BButton(Ui.hyperlink((BWidget)this, Ui.lex("algorithms"), Utils.iconAlgorithm, BOrd.make((String)"slot:algorithms")));
        gp.add(null, (BValue)b);
        b = new BButton(Ui.hyperlink((BWidget)this, Ui.lex("definitions"), Utils.iconDefinition, BOrd.make((String)"slot:definitions")));
        gp.add(null, (BValue)b);
        b = new BButton(Ui.hyperlink((BWidget)this, Ui.lex("pollers"), Utils.iconPoller, BOrd.make((String)"slot:pollers")));
        gp.add(null, (BValue)b);
        b = new BButton(Ui.hyperlink((BWidget)this, Ui.lex("propertySheet"), Utils.iconPoller, BOrd.make((String)"view:workbench:PropertySheet")));
        gp.add(null, (BValue)b);
        b = new BButton(Ui.refresh, Ui.lex("refresh"));
        gp.add(null, (BValue)b);
        this.linkTo((BComponent)b, (Slot)BButton.actionPerformed, (Slot)updateTable);
        content.setBottom((BWidget)new BBorderPane((BWidget)gp));
        this.setContent((BWidget)content);
    }

    public void doNodeSelection() {
        TreeNode node = this.tree.getSelection().getNode();
        if (node == null) {
            return;
        }
        String ord = node.getSubject().toString();
        if (ord.equals(this.selectedNode)) {
            return;
        }
        this.selectedNode = ord;
        this.doUpdateTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdateTable() {
        this.getWbShell().enterBusy();
        try {
            BITable allAlerts = (BITable)Ui.resolveOrd((BWbPlugin)this, this.selectedNode + "|alerts:");
            HashMap<String, Row> nodeMap = new HashMap<String, Row>();
            HashMap<String, Row> alertMap = new HashMap<String, Row>();
            ArrayList<Row> all = new ArrayList<Row>();
            if (allAlerts != null) {
                ColumnList cols = allAlerts.getColumns();
                Column alertCol = cols.get("alert");
                Column nodeCol = cols.get("node");
                Column stateCol = cols.get("state");
                Column costCol = cols.get("cost");
                TableCursor c = allAlerts.cursor();
                while (c.next()) {
                    Row r = new Row();
                    r.alert = c.cell(alertCol).toString(null);
                    r.node = c.cell(nodeCol).toString(null);
                    r.cost = ((BDouble)c.cell(costCol)).getDouble();
                    boolean alert = ((BBoolean)c.cell(stateCol)).getBoolean();
                    if (alert) {
                        ++r.alertCount;
                    } else {
                        ++r.normalCount;
                    }
                    all.add(r);
                    Row tmp = (Row)nodeMap.get(r.node);
                    if (tmp == null) {
                        tmp = new Row();
                        tmp.node = r.node;
                        nodeMap.put(r.node, tmp);
                    }
                    if (alert) {
                        ++tmp.alertCount;
                    } else {
                        ++tmp.normalCount;
                    }
                    tmp.cost += r.cost;
                    tmp = (Row)alertMap.get(r.alert);
                    if (tmp == null) {
                        tmp = new Row();
                        tmp.alert = r.alert;
                        alertMap.put(r.alert, tmp);
                    }
                    if (alert) {
                        ++tmp.alertCount;
                    } else {
                        ++tmp.normalCount;
                    }
                    tmp.cost += r.cost;
                }
            }
            ArrayList<Row> byAlert = new ArrayList<Row>();
            byAlert.addAll(alertMap.values());
            ArrayList<Row> byNode = new ArrayList<Row>();
            byNode.addAll(nodeMap.values());
            this.table.getSelection().deselectAll();
            if (this.allButton.isSelected()) {
                this.table.setModel((TableModel)new AllModel(all));
            } else if (this.alertButton.isSelected()) {
                this.table.setModel((TableModel)new AlertModel(byAlert));
            } else {
                this.table.setModel((TableModel)new NodeModel(byNode));
            }
            this.table.sizeColumnsToFit();
        }
        finally {
            this.getWbShell().exitBusy();
        }
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        ((BAnalyticService)value).lease(2);
        if (((BAnalyticService)value).getStatus().isFault()) {
            throw new LocalizableRuntimeException("analytics", "analyticService.faultMessage");
        }
        this.allButton.setSelected(true);
        this.linkTo((BComponent)this.allButton, (Slot)BButton.actionPerformed, (Slot)updateTable);
        this.linkTo((BComponent)this.alertButton, (Slot)BButton.actionPerformed, (Slot)updateTable);
        this.linkTo((BComponent)this.nodeButton, (Slot)BButton.actionPerformed, (Slot)updateTable);
        this.linkTo((BComponent)this.tree, (Slot)BTree.actionPerformed, (Slot)nodeSelection);
        this.expandTree();
        this.doUpdateTable();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        return value;
    }

    private void doubleClicked(Row row) {
        if (this.allButton.isSelected()) {
            this.selectedNode = row.node;
            this.expandTree();
            this.alertButton.setSelected(true);
            this.doUpdateTable();
        } else if (this.alertButton.isSelected()) {
            this.getWbShell().hyperlink(BOrd.make((String)row.alert));
        } else if (this.nodeButton.isSelected()) {
            this.selectedNode = row.node;
            this.expandTree();
            this.doUpdateTable();
        }
    }

    private void expand(String value, TreeNode node) {
        String s = node.getSubject().toString();
        if (!value.startsWith(s)) {
            return;
        }
        node.setExpanded(true);
        if (value.equals(s)) {
            node.getTree().getSelection().select(node);
            return;
        }
        int i = node.getChildCount();
        while (--i >= 0) {
            this.expand(value, node.getChild(i));
        }
    }

    private void expandTree() {
        TreeModel model = this.tree.getModel();
        int i = model.getRootCount();
        while (--i >= 0) {
            this.expand(this.selectedNode, model.getRoot(i));
        }
        this.tree.relayout();
    }

    private static class Row {
        String alert;
        int alertCount;
        double cost;
        String node;
        int normalCount;

        private Row() {
        }
    }

    private static class NodeModel
    extends TableModel {
        ArrayList<Row> rows;

        NodeModel(ArrayList<Row> rows) {
            this.rows = rows;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Ui.lex("node");
                }
                case 1: {
                    return Ui.lex("totalCost");
                }
                case 2: {
                    return Ui.lex("alertCount");
                }
                case 3: {
                    return Ui.lex("normalCount");
                }
            }
            return "???";
        }

        public Object getValueAt(int row, int col) {
            Row r = this.rows.get(row);
            switch (col) {
                case 0: {
                    return r.node;
                }
                case 1: {
                    return BDouble.make((double)r.cost);
                }
                case 2: {
                    return BInteger.make((int)r.alertCount);
                }
                case 3: {
                    return BInteger.make((int)r.normalCount);
                }
            }
            return "???";
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getSubject(int row) {
            return this.rows.get(row);
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            Comparator<Row> c = null;
            switch (col) {
                case 0: {
                    if (ascending) {
                        c = byNodeA;
                        break;
                    }
                    c = byNodeD;
                    break;
                }
                case 1: {
                    if (ascending) {
                        c = byCostA;
                        break;
                    }
                    c = byCostD;
                    break;
                }
                case 2: {
                    if (ascending) {
                        c = byAlertCountA;
                        break;
                    }
                    c = byAlertCountD;
                    break;
                }
                case 3: {
                    c = ascending ? byNormalCountA : byNormalCountD;
                }
            }
            Collections.sort(this.rows, c);
        }
    }

    private class MyController
    extends TableController {
        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            if (row >= 0) {
                BAnalyticServiceView.this.doubleClicked((Row)this.getModel().getSubject(row));
            }
        }
    }

    private static class AllModel
    extends TableModel {
        ArrayList<Row> rows;

        AllModel(ArrayList<Row> rows) {
            this.rows = rows;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Ui.lex("node");
                }
                case 1: {
                    return Ui.lex("alert");
                }
                case 2: {
                    return Ui.lex("cost");
                }
                case 3: {
                    return Ui.lex("state");
                }
            }
            return "???";
        }

        public Object getValueAt(int row, int col) {
            Row r = this.rows.get(row);
            switch (col) {
                case 0: {
                    return r.node;
                }
                case 1: {
                    return r.alert;
                }
                case 2: {
                    return BDouble.make((double)r.cost);
                }
                case 3: {
                    if (r.alertCount > 0) {
                        return Ui.lex("alert");
                    }
                    return Ui.lex("normal");
                }
            }
            return "???";
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getSubject(int row) {
            return this.rows.get(row);
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            Comparator<Row> c = null;
            switch (col) {
                case 0: {
                    if (ascending) {
                        c = byNodeA;
                        break;
                    }
                    c = byNodeD;
                    break;
                }
                case 1: {
                    if (ascending) {
                        c = byAlertA;
                        break;
                    }
                    c = byAlertD;
                    break;
                }
                case 2: {
                    if (ascending) {
                        c = byCostA;
                        break;
                    }
                    c = byCostD;
                    break;
                }
                case 3: {
                    if (ascending) {
                        c = byAlertCountA;
                        break;
                    }
                    c = byAlertCountD;
                    break;
                }
                case 4: {
                    c = ascending ? byNormalCountA : byNormalCountD;
                }
            }
            Collections.sort(this.rows, c);
        }
    }

    private static class AlertModel
    extends TableModel {
        ArrayList<Row> rows;

        AlertModel(ArrayList<Row> rows) {
            this.rows = rows;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Ui.lex("alert");
                }
                case 1: {
                    return Ui.lex("totalCost");
                }
                case 2: {
                    return Ui.lex("alertCount");
                }
                case 3: {
                    return Ui.lex("normalCount");
                }
            }
            return "???";
        }

        public Object getValueAt(int row, int col) {
            Row r = this.rows.get(row);
            switch (col) {
                case 0: {
                    return r.alert;
                }
                case 1: {
                    return BDouble.make((double)r.cost);
                }
                case 2: {
                    return BInteger.make((int)r.alertCount);
                }
                case 3: {
                    return BInteger.make((int)r.normalCount);
                }
            }
            return "???";
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getSubject(int row) {
            return this.rows.get(row);
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            Comparator<Row> c = null;
            switch (col) {
                case 0: {
                    if (ascending) {
                        c = byAlertA;
                        break;
                    }
                    c = byAlertD;
                    break;
                }
                case 1: {
                    if (ascending) {
                        c = byCostA;
                        break;
                    }
                    c = byCostD;
                    break;
                }
                case 2: {
                    if (ascending) {
                        c = byAlertCountA;
                        break;
                    }
                    c = byAlertCountD;
                    break;
                }
                case 3: {
                    c = ascending ? byNormalCountA : byNormalCountD;
                }
            }
            Collections.sort(this.rows, c);
        }
    }
}

