/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui.certExt;

import com.tridium.crypto.core.cert.CertificateParseException;
import com.tridium.crypto.core.cert.ext.NKeyUsage;
import com.tridium.crypto.core.cert.ext.NX509Extension;
import com.tridium.platcrypto.ui.certExt.BBaseKeyUsagePane;
import com.tridium.platcrypto.ui.certExt.BICertExtensionParameterPane;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import org.bouncycastle.asn1.x509.Extension;

@NiagaraType
public final class BKeyUsagePane
extends BBaseKeyUsagePane<Integer>
implements BICertExtensionParameterPane<NKeyUsage> {
    @Generated
    public static final Type TYPE = Sys.loadType(BKeyUsagePane.class);
    private static final List<Integer> KEY_USAGE_FLAGS = Collections.unmodifiableList(Arrays.asList(128, 64, 32, 16, 8, 4, 2, 1, 32768));
    private static final String EXT_NAME = LEX.getText("cert.field.keyUsage");
    private static final String HELP_LEX_KEY = "ku";
    private static final String OID = Extension.keyUsage.getId();
    private final BGridPane checkboxPane = new BGridPane(1);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BKeyUsagePane() {
        this.setContent((BWidget)this.checkboxPane);
    }

    @Override
    public String getExtensionOid() {
        return OID;
    }

    @Override
    public String getExtensionName() {
        return EXT_NAME;
    }

    @Override
    public String getHelpLexiconKey() {
        return HELP_LEX_KEY;
    }

    @Override
    public void loadFromJson(String json, Map<String, Object> properties) throws CertificateParseException, IOException {
        Map<Integer, Integer> checkBoxStates = BKeyUsagePane.getFlags();
        this.applyDefaultsForProfile(checkBoxStates, properties);
        if (!json.isEmpty()) {
            NKeyUsage keyUsage = (NKeyUsage)NX509Extension.decodeFromString((String)json);
            int loadedFlags = keyUsage.getKeyUsageValue();
            KEY_USAGE_FLAGS.forEach(flag -> {
                if ((loadedFlags & flag) > 0) {
                    int state = (Integer)checkBoxStates.get(flag);
                    checkBoxStates.put((Integer)flag, state | 2);
                }
            });
        }
        checkBoxStates.forEach((flag, state) -> {
            int indexOfFlag = KEY_USAGE_FLAGS.indexOf(flag);
            String flagName = LEX.getText("cert.field.keyUsage." + indexOfFlag);
            BCheckBox checkBox = new BCheckBox(flagName, (state & 2) > 0);
            checkBox.setEnabled((state & 1) == 0);
            this.checkboxPane.add(SlotPath.escape((String)flagName), (BValue)checkBox);
        });
    }

    @Override
    public NKeyUsage toExtension(boolean isCritical) throws IOException {
        int flags = 0;
        BCheckBox[] checkBoxes = (BCheckBox[])this.checkboxPane.getChildren(BCheckBox.class);
        for (int i = 0; i < checkBoxes.length; ++i) {
            BCheckBox checkBox = checkBoxes[i];
            if (!checkBox.isSelected()) continue;
            flags += KEY_USAGE_FLAGS.get(i).intValue();
        }
        return NKeyUsage.make((boolean)isCritical, (int)flags);
    }

    @Override
    public String toDisplayText(Context cx) {
        BCheckBox[] checkBoxes = (BCheckBox[])this.checkboxPane.getChildren(BCheckBox.class);
        return Arrays.stream(checkBoxes).filter(checkBox -> checkBox.isSelected()).map(checkBox -> SlotPath.unescape((String)checkBox.getName())).collect(Collectors.joining(", "));
    }

    @Override
    protected void applyDefaultsForClientProfile(Map<Integer, Integer> checkBoxStates) {
        BKeyUsagePane.disable(checkBoxStates, 128, 4, 2);
        BKeyUsagePane.preselect(checkBoxStates, 128);
    }

    @Override
    protected void applyDefaultsForServerProfile(Map<Integer, Integer> checkBoxStates) {
        BKeyUsagePane.disable(checkBoxStates, 128, 32, 4, 2);
        BKeyUsagePane.preselect(checkBoxStates, 128, 32);
    }

    @Override
    protected void applyDefaultsForCAProfile(Map<Integer, Integer> checkBoxStates) {
        BKeyUsagePane.disable(checkBoxStates, 4, 2);
    }

    @Override
    protected void applyDefaultsForCodeSigningProfile(Map<Integer, Integer> checkBoxStates) {
        BKeyUsagePane.disable(checkBoxStates, 128, 4, 2);
        BKeyUsagePane.preselect(checkBoxStates, 128);
    }

    private static Map<Integer, Integer> getFlags() {
        return KEY_USAGE_FLAGS.stream().collect(Collectors.toMap(flag -> flag, flag -> 0, (key1, key2) -> key1, LinkedHashMap::new));
    }
}

