/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.SigningUtil;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.nre.security.SecretChars;
import com.tridium.platcrypto.ui.BCryptoDialog;
import com.tridium.platcrypto.ui.BPasswordField;
import com.tridium.platcrypto.ui.JarFileSigner;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.workbench.fieldeditors.BWbCertificateAliasFE;
import java.io.File;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BFileSystem;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;

@NiagaraType
@NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BJarSignerDialog
extends BCryptoDialog {
    @Generated
    public static final Action cancelButtonPressed = BJarSignerDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJarSignerDialog.class);
    private BTextField srcFileText;
    private BWbCertificateAliasFE alias;
    private BPasswordField password;
    private BTextField tsaUrl;
    private ICoreKeyStore store;
    private BButton okButton;
    protected BButton cancelButton;
    private static final BImage OPEN = BImage.make((BIcon)BIcon.std((String)"open.png"));
    private static final String DEFAULT_TSA = "http://timestamp.digicert.com";

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static void show(BWidget parent) throws Exception {
        BJarSignerDialog dialog = new BJarSignerDialog(parent);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
    }

    private BJarSignerDialog(BWidget parent) throws Exception {
        super(parent, lex.getText("jar.signer.dialog.title"));
        ICryptoManager mgr = CertManagerFactory.getInstance();
        this.store = (ICoreKeyStore)mgr.getKeyStore();
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    @Override
    protected BWidget buildHeader() {
        return new BWizardHeader(logo, lex.getText("jar.signer.dialog.title"), lex.getText("jar.signer.dialog.info"));
    }

    @Override
    protected BWidget buildBody() throws Exception {
        BGridPane body = new BGridPane(1);
        body.setStretchColumn(0);
        body.setColumnAlign(BHalign.fill);
        BEdgePane srcSelectPane = new BEdgePane();
        srcSelectPane.setTop((BWidget)new BLabel(lex.getText("jar.signer.dialog.jar") + ":", BHalign.left));
        BGridPane srcSelect = new BGridPane(2);
        this.srcFileText = new BTextField("", 60, false);
        srcSelect.add(null, (BValue)this.srcFileText);
        BButton openBtn = new BButton((Command)new SelectJarCommand());
        openBtn.setButtonStyle(BButtonStyle.toolBar);
        srcSelect.add(null, (BValue)openBtn);
        srcSelectPane.setCenter((BWidget)srcSelect);
        body.add(null, (BValue)srcSelectPane);
        BEdgePane rowPane = new BEdgePane();
        BGridPane tuple = new BGridPane(2);
        tuple.setRowGap(7.0);
        this.alias = new BWbCertificateAliasFE();
        this.alias.loadValue((BObject)BString.make((String)""));
        this.password = new BPasswordField("", 20);
        this.tsaUrl = new BTextField(DEFAULT_TSA, 40);
        BJarSignerDialog.addLabelRow(tuple, "jar.signer.dialog.alias", (BValue)this.alias);
        BJarSignerDialog.addLabelRow(tuple, "jar.signer.dialog.password", (BValue)this.password);
        BJarSignerDialog.addLabelRow(tuple, "jar.signer.dialog.tsa", (BValue)this.tsaUrl);
        rowPane.setLeft((BWidget)tuple);
        body.add(null, (BValue)rowPane);
        body.setRowGap(7.0);
        return body;
    }

    private static void addLabelRow(BGridPane pane, String lexKey, BValue value) {
        pane.add(null, (BValue)new BLabel(lex.getText(lexKey) + ":"));
        pane.add(null, value);
    }

    @Override
    protected BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.cancelButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doOkButtonPressed(BWidgetEvent event) {
        String errorMessage;
        KeyStore store;
        String aliasString;
        block30: {
            aliasString = null;
            store = null;
            errorMessage = null;
            try {
                aliasString = this.alias.saveValue().toString();
                store = this.store.getKeyStore();
                if (this.srcFileText.getText().isEmpty()) {
                    errorMessage = lex.getText("jar.signer.srcNotSelected", new Object[]{aliasString});
                    break block30;
                }
                if (aliasString.isEmpty()) {
                    errorMessage = lex.getText("jar.signer.certNotSelected", new Object[]{aliasString});
                    break block30;
                }
                if (!store.containsAlias(aliasString)) {
                    errorMessage = lex.getText("jar.signer.entryNotFound", new Object[]{aliasString});
                    break block30;
                }
                if (!SigningUtil.isValidSigningCert((String)aliasString, (KeyStore)store)) {
                    errorMessage = lex.getText("jar.signer.notValidSigning");
                    break block30;
                }
                try (SecretChars passwordChars = this.password.getPassword().getSecretChars();){
                    if (!CertUtils.isPrivateKey((KeyStore)store, (String)aliasString, (char[])passwordChars.get())) {
                        errorMessage = lex.getText("jar.signer.notPrivateKey");
                    }
                }
                catch (UnrecoverableKeyException e) {
                    errorMessage = lex.getText("jar.signer.incorrectPassword");
                }
            }
            catch (Exception e) {
                errorMessage = e.getMessage();
            }
        }
        if (errorMessage != null) {
            BDialog.error((BWidget)this, (Object)errorMessage);
            return;
        }
        try {
            BOrd srcOrd = BOrd.make((String)this.srcFileText.getText());
            BAbstractFile srcFile = (BAbstractFile)srcOrd.get();
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            chooser.setCreateFileOnSave(false);
            chooser.addFilter((IFileFilter)new ExtFileFilter(lex.getText("jar.extension.info"), "jar"));
            chooser.setTitle(lex.getText("jar.signer.save.title"));
            chooser.setDefaultFileName(srcFile.getFileName());
            BOrd ord = chooser.show();
            if (ord == null) {
                return;
            }
            try {
                this.enterBusy();
                OrdQuery[] queries = ord.parse();
                FilePath path = (FilePath)queries[queries.length - 1];
                File destFile = BFileSystem.INSTANCE.pathToLocalFile(path);
                Path srcPath = ((BLocalFileStore)srcFile.getStore()).getLocalFile().toPath();
                Path destPath = destFile.toPath();
                JarFileSigner signer = new JarFileSigner(store, aliasString, this.password.getPassword().getValue(), this.tsaUrl.getText());
                if (srcPath.equals(destPath)) {
                    signer.signFile(srcPath);
                } else {
                    signer.signFile(srcPath, destPath);
                }
            }
            finally {
                this.exitBusy();
            }
            BDialog.info((BWidget)this, (Object)lex.getText("jar.signer.signingComplete"));
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)lex.getText("jar.signer.failedToSign"), (Throwable)e);
            return;
        }
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
    }

    private class SelectJarCommand
    extends Command {
        public SelectJarCommand() {
            super((BWidget)BJarSignerDialog.this, null, OPEN, null, null);
        }

        public CommandArtifact doInvoke() {
            try {
                BFileChooser chooser = BFileChooser.makeOpen((BWidget)this.getOwner());
                chooser.addFilter((IFileFilter)new ExtFileFilter(BCryptoDialog.lex.getText("jar.extension.info"), "jar"));
                chooser.setTitle(BCryptoDialog.lex.getText("jar.signer.dialog.jar"));
                BOrd ord = chooser.show();
                if (ord == null) {
                    return null;
                }
                BAbstractFile jarFile = (BAbstractFile)ord.get();
                if (jarFile != null) {
                    BJarSignerDialog.this.srcFileText.setText(jarFile.toPathString());
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }
}

